/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.VmObjectLike;

public final class InvokeMethodDirectNode
extends ExpressionNode {
    private final VmObjectLike owner;
    @Node.Child
    private ExpressionNode receiverNode;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    @Node.Child
    private DirectCallNode callNode;

    public InvokeMethodDirectNode(SourceSection sourceSection, ClassMethod method, ExpressionNode receiverNode, ExpressionNode[] argumentNodes) {
        super(sourceSection);
        this.owner = method.getOwner();
        this.receiverNode = receiverNode;
        this.argumentNodes = argumentNodes;
        this.callNode = DirectCallNode.create(method.getCallTarget(sourceSection));
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args = new Object[2 + this.argumentNodes.length];
        args[0] = this.receiverNode.executeGeneric(frame);
        args[1] = this.owner;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return this.callNode.call(args);
    }
}

