/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;

public final class InvokeMethodLexicalNode
extends ExpressionNode {
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final int levelsUp;
    @Node.Child
    private DirectCallNode callNode;

    InvokeMethodLexicalNode(SourceSection sourceSection, CallTarget callTarget, int levelsUp, ExpressionNode[] argumentNodes) {
        super(sourceSection);
        this.levelsUp = levelsUp;
        this.argumentNodes = argumentNodes;
        this.callNode = DirectCallNode.create(callTarget);
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args = new Object[2 + this.argumentNodes.length];
        Frame enclosingFrame = this.getEnclosingFrame(frame);
        args[0] = VmUtils.getReceiver(enclosingFrame);
        args[1] = VmUtils.getOwner(enclosingFrame);
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return this.callNode.call(args);
    }

    @ExplodeLoop
    private Frame getEnclosingFrame(VirtualFrame frame) {
        if (this.levelsUp == 0) {
            return frame;
        }
        VmObjectLike owner = VmUtils.getOwner(frame);
        for (int i = 1; i < this.levelsUp; ++i) {
            owner = owner.getEnclosingOwner();
            assert (owner != null);
        }
        return owner.getEnclosingFrame();
    }
}

