/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.internal.GetClassNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmFunction;

@ImportStatic(value={Identifier.class})
@NodeChildren(value={@NodeChild(value="receiverNode", type=ExpressionNode.class), @NodeChild(value="receiverClassNode", type=GetClassNode.class, executeWith={"receiverNode"})})
public abstract class InvokeMethodVirtualNode
extends ExpressionNode {
    protected final Identifier methodName;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final MemberLookupMode lookupMode;
    private final boolean needsConst;
    @CompilerDirectives.CompilationFinal
    private boolean isConstChecked;

    protected InvokeMethodVirtualNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, MemberLookupMode lookupMode, boolean needsConst) {
        super(sourceSection);
        this.methodName = methodName;
        this.argumentNodes = argumentNodes;
        this.lookupMode = lookupMode;
        this.needsConst = needsConst;
    }

    protected InvokeMethodVirtualNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, MemberLookupMode lookupMode) {
        this(sourceSection, methodName, argumentNodes, lookupMode, false);
    }

    public abstract Object executeWith(VirtualFrame var1, Object var2, VmClass var3);

    @ExplodeLoop
    @Specialization(guards={"methodName == APPLY", "receiver.getCallTarget() == cachedCallTarget"})
    protected Object evalFunctionCached(VirtualFrame frame, VmFunction receiver, VmClass receiverClass, @Cached(value="receiver.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
        Object[] args = new Object[2 + this.argumentNodes.length];
        args[0] = receiver.getThisValue();
        args[1] = receiver;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(args);
    }

    @ExplodeLoop
    @Specialization(guards={"methodName == APPLY"}, replaces={"evalFunctionCached"})
    protected Object evalFunction(VirtualFrame frame, VmFunction receiver, VmClass receiverClass, @Cached(value="create()") IndirectCallNode callNode) {
        this.checkConst(receiverClass);
        Object[] args = new Object[2 + this.argumentNodes.length];
        args[0] = receiver.getThisValue();
        args[1] = receiver;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(receiver.getCallTarget(), args);
    }

    @ExplodeLoop
    @Specialization(guards={"receiverClass == cachedReceiverClass"})
    protected Object evalCached(VirtualFrame frame, Object receiver, VmClass receiverClass, @Cached(value="receiverClass") VmClass cachedReceiverClass, @Cached(value="resolveMethod(receiverClass)") ClassMethod method, @Cached(value="create(method.getCallTarget(sourceSection))") DirectCallNode callNode) {
        this.checkConst(method);
        Object[] args = new Object[2 + this.argumentNodes.length];
        args[0] = receiver;
        args[1] = method.getOwner();
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(args);
    }

    @ExplodeLoop
    @Specialization(replaces={"evalCached"})
    protected Object eval(VirtualFrame frame, Object receiver, VmClass receiverClass, @Cached(value="create()") IndirectCallNode callNode) {
        ClassMethod method = this.resolveMethod(receiverClass);
        this.checkConst(method);
        Object[] args = new Object[2 + this.argumentNodes.length];
        args[0] = receiver;
        args[1] = method.getOwner();
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(method.getCallTarget(), args);
    }

    protected ClassMethod resolveMethod(VmClass receiverClass) {
        ClassMethod method = receiverClass.getMethod(this.methodName);
        if (method != null) {
            return method;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().cannotFindMethod(receiverClass.getPrototype(), this.methodName, this.argumentNodes.length, this.lookupMode != MemberLookupMode.EXPLICIT_RECEIVER).build();
    }

    private void checkConst(VmClass receiverClass) {
        this.checkConst(this.resolveMethod(receiverClass));
    }

    private void checkConst(ClassMethod method) {
        if (this.needsConst && !this.isConstChecked) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (!method.isConst()) {
                throw this.exceptionBuilder().evalError("methodMustBeConst", this.methodName.toString()).build();
            }
            this.isConstChecked = true;
        }
    }
}

