/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.internal.GetClassNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;

@GeneratedBy(value=GetClassNode.class)
public final class GetClassNodeGen
extends GetClassNode {
    @Node.Child
    private ExpressionNode valueNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private EvalVmValueData evalVmValue_cache;

    private GetClassNodeGen(SourceSection sourceSection, ExpressionNode valueNode) {
        super(sourceSection);
        this.valueNode_ = valueNode;
    }

    private GetClassNodeGen(ExpressionNode valueNode) {
        this.valueNode_ = valueNode;
    }

    @Override
    @ExplodeLoop
    public VmClass executeWith(VirtualFrame frameValue, Object valueNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && valueNodeValue instanceof String) {
            String valueNodeValue_ = (String)valueNodeValue;
            return this.evalString(valueNodeValue_);
        }
        if ((state_0 & 2) != 0 && valueNodeValue instanceof Long) {
            long valueNodeValue_ = (Long)valueNodeValue;
            return this.evalInt(valueNodeValue_);
        }
        if ((state_0 & 4) != 0 && valueNodeValue instanceof Double) {
            double valueNodeValue_ = (Double)valueNodeValue;
            return this.evalFloat(valueNodeValue_);
        }
        if ((state_0 & 8) != 0 && valueNodeValue instanceof Boolean) {
            boolean valueNodeValue_ = (Boolean)valueNodeValue;
            return this.evalBoolean(valueNodeValue_);
        }
        if ((state_0 & 0x10) != 0) {
            EvalVmValueData s4_ = this.evalVmValue_cache;
            while (s4_ != null) {
                if (valueNodeValue.getClass() == s4_.cachedClass_) {
                    return this.evalVmValue(valueNodeValue, s4_.cachedClass_);
                }
                s4_ = s4_.next_;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(valueNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1D) == 0 && state_0 != 0) {
            return this.executeGeneric_long0(state_0, frameValue);
        }
        if ((state_0 & 0x1B) == 0 && state_0 != 0) {
            return this.executeGeneric_double1(state_0, frameValue);
        }
        if ((state_0 & 0x17) == 0 && state_0 != 0) {
            return this.executeGeneric_boolean2(state_0, frameValue);
        }
        return this.executeGeneric_generic3(state_0, frameValue);
    }

    private Object executeGeneric_long0(int state_0, VirtualFrame frameValue) {
        long valueNodeValue_;
        try {
            valueNodeValue_ = this.valueNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.evalInt(valueNodeValue_);
    }

    private Object executeGeneric_double1(int state_0, VirtualFrame frameValue) {
        double valueNodeValue_;
        try {
            valueNodeValue_ = this.valueNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.evalFloat(valueNodeValue_);
    }

    private Object executeGeneric_boolean2(int state_0, VirtualFrame frameValue) {
        boolean valueNodeValue_;
        try {
            valueNodeValue_ = this.valueNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.evalBoolean(valueNodeValue_);
    }

    @ExplodeLoop
    private Object executeGeneric_generic3(int state_0, VirtualFrame frameValue) {
        Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && valueNodeValue_ instanceof String) {
            String valueNodeValue__ = (String)valueNodeValue_;
            return this.evalString(valueNodeValue__);
        }
        if ((state_0 & 2) != 0 && valueNodeValue_ instanceof Long) {
            long valueNodeValue__ = (Long)valueNodeValue_;
            return this.evalInt(valueNodeValue__);
        }
        if ((state_0 & 4) != 0 && valueNodeValue_ instanceof Double) {
            double valueNodeValue__ = (Double)valueNodeValue_;
            return this.evalFloat(valueNodeValue__);
        }
        if ((state_0 & 8) != 0 && valueNodeValue_ instanceof Boolean) {
            boolean valueNodeValue__ = (Boolean)valueNodeValue_;
            return this.evalBoolean(valueNodeValue__);
        }
        if ((state_0 & 0x10) != 0) {
            EvalVmValueData s4_ = this.evalVmValue_cache;
            while (s4_ != null) {
                if (valueNodeValue_.getClass() == s4_.cachedClass_) {
                    return this.evalVmValue(valueNodeValue_, s4_.cachedClass_);
                }
                s4_ = s4_.next_;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(valueNodeValue_);
    }

    private VmClass executeAndSpecialize(Object valueNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof String) {
                String valueNodeValue_ = (String)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                VmClass vmClass = this.evalString(valueNodeValue_);
                return vmClass;
            }
            if (valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                VmClass vmClass = this.evalInt(valueNodeValue_);
                return vmClass;
            }
            if (valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                VmClass vmClass = this.evalFloat(valueNodeValue_);
                return vmClass;
            }
            if (valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                VmClass vmClass = this.evalBoolean(valueNodeValue_);
                return vmClass;
            }
            int count4_ = 0;
            EvalVmValueData s4_ = this.evalVmValue_cache;
            if ((state_0 & 0x10) != 0) {
                while (s4_ != null && valueNodeValue.getClass() != s4_.cachedClass_) {
                    s4_ = s4_.next_;
                    ++count4_;
                }
            }
            if (s4_ == null) {
                Class<? extends VmValue> cachedClass__ = GetClassNode.getValueClass(valueNodeValue);
                if (valueNodeValue.getClass() == cachedClass__ && count4_ < 99) {
                    s4_ = new EvalVmValueData(this.evalVmValue_cache);
                    s4_.cachedClass_ = cachedClass__;
                    VarHandle.storeStoreFence();
                    this.evalVmValue_cache = s4_;
                    this.state_0_ = state_0 |= 0x10;
                }
            }
            if (s4_ != null) {
                lock.unlock();
                hasLock = false;
                VmClass vmClass = this.evalVmValue(valueNodeValue, s4_.cachedClass_);
                return vmClass;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.valueNode_}, valueNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        EvalVmValueData s4_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s4_ = this.evalVmValue_cache) == null || s4_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static GetClassNode create(SourceSection sourceSection, ExpressionNode valueNode) {
        return new GetClassNodeGen(sourceSection, valueNode);
    }

    public static GetClassNode create(ExpressionNode valueNode) {
        return new GetClassNodeGen(valueNode);
    }

    @GeneratedBy(value=GetClassNode.class)
    private static final class EvalVmValueData {
        @CompilerDirectives.CompilationFinal
        EvalVmValueData next_;
        @CompilerDirectives.CompilationFinal
        Class<? extends VmValue> cachedClass_;

        EvalVmValueData(EvalVmValueData next_) {
            this.next_ = next_;
        }
    }
}

