/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;
import org.pkl.core.ast.internal.IsInstanceOfNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;

@GeneratedBy(value=IsInstanceOfNode.class)
public final class IsInstanceOfNodeGen
extends IsInstanceOfNode {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private EvalVmValueData evalVmValue_cache;

    private IsInstanceOfNodeGen() {
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object arg0Value, VmClass arg1Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                return this.eval(arg0Value_, arg1Value);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return this.eval(arg0Value_, arg1Value);
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                return this.eval(arg0Value_, arg1Value);
            }
            if ((state_0 & 8) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.eval(arg0Value_, arg1Value);
            }
            if ((state_0 & 0x10) != 0) {
                EvalVmValueData s4_ = this.evalVmValue_cache;
                while (s4_ != null) {
                    if (arg0Value.getClass() == s4_.valueJavaClass_) {
                        return this.evalVmValue(arg0Value, arg1Value, s4_.valueJavaClass_);
                    }
                    s4_ = s4_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private boolean executeAndSpecialize(Object arg0Value, VmClass arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.eval(arg0Value_, arg1Value);
                return bl;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.eval(arg0Value_, arg1Value);
                return bl;
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.eval(arg0Value_, arg1Value);
                return bl;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                boolean bl = this.eval(arg0Value_, arg1Value);
                return bl;
            }
            int count4_ = 0;
            EvalVmValueData s4_ = this.evalVmValue_cache;
            if ((state_0 & 0x10) != 0) {
                while (s4_ != null && arg0Value.getClass() != s4_.valueJavaClass_) {
                    s4_ = s4_.next_;
                    ++count4_;
                }
            }
            if (s4_ == null) {
                Class<? extends VmValue> valueJavaClass__ = this.getJavaClass(arg0Value);
                if (arg0Value.getClass() == valueJavaClass__ && count4_ < 99) {
                    s4_ = new EvalVmValueData(this.evalVmValue_cache);
                    s4_.valueJavaClass_ = valueJavaClass__;
                    VarHandle.storeStoreFence();
                    this.evalVmValue_cache = s4_;
                    this.state_0_ = state_0 |= 0x10;
                }
            }
            if (s4_ != null) {
                lock.unlock();
                hasLock = false;
                boolean bl = this.evalVmValue(arg0Value, arg1Value, s4_.valueJavaClass_);
                return bl;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        EvalVmValueData s4_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s4_ = this.evalVmValue_cache) == null || s4_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static IsInstanceOfNode create() {
        return new IsInstanceOfNodeGen();
    }

    @GeneratedBy(value=IsInstanceOfNode.class)
    private static final class EvalVmValueData {
        @CompilerDirectives.CompilationFinal
        EvalVmValueData next_;
        @CompilerDirectives.CompilationFinal
        Class<? extends VmValue> valueJavaClass_;

        EvalVmValueData(EvalVmValueData next_) {
            this.next_ = next_;
        }
    }
}

