/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.locks.Lock;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.member.InvokeMethodVirtualNode;
import org.pkl.core.ast.internal.ToStringNode;
import org.pkl.core.runtime.VmTyped;

@GeneratedBy(value=ToStringNode.class)
public final class ToStringNodeGen
extends ToStringNode {
    @Node.Child
    private ExpressionNode operandNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private InvokeMethodVirtualNode evalTyped_invokeNode_;

    private ToStringNodeGen(SourceSection sourceSection, ExpressionNode operandNode) {
        super(sourceSection);
        this.operandNode_ = operandNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3D) == 0 && state_0 != 0) {
            return this.executeGeneric_long0(state_0, frameValue);
        }
        if ((state_0 & 0x3B) == 0 && state_0 != 0) {
            return this.executeGeneric_double1(state_0, frameValue);
        }
        if ((state_0 & 0x37) == 0 && state_0 != 0) {
            return this.executeGeneric_boolean2(state_0, frameValue);
        }
        return this.executeGeneric_generic3(state_0, frameValue);
    }

    private Object executeGeneric_long0(int state_0, VirtualFrame frameValue) {
        long operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.evalInt(operandNodeValue_);
    }

    private Object executeGeneric_double1(int state_0, VirtualFrame frameValue) {
        double operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.evalFloat(operandNodeValue_);
    }

    private Object executeGeneric_boolean2(int state_0, VirtualFrame frameValue) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.evalBoolean(operandNodeValue_);
    }

    private Object executeGeneric_generic3(int state_0, VirtualFrame frameValue) {
        Object operandNodeValue_ = this.operandNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && operandNodeValue_ instanceof String) {
            String operandNodeValue__ = (String)operandNodeValue_;
            return this.evalString(operandNodeValue__);
        }
        if ((state_0 & 2) != 0 && operandNodeValue_ instanceof Long) {
            long operandNodeValue__ = (Long)operandNodeValue_;
            return this.evalInt(operandNodeValue__);
        }
        if ((state_0 & 4) != 0 && operandNodeValue_ instanceof Double) {
            double operandNodeValue__ = (Double)operandNodeValue_;
            return this.evalFloat(operandNodeValue__);
        }
        if ((state_0 & 8) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__ = (Boolean)operandNodeValue_;
            return this.evalBoolean(operandNodeValue__);
        }
        if ((state_0 & 0x10) != 0 && operandNodeValue_ instanceof VmTyped) {
            VmTyped operandNodeValue__ = (VmTyped)operandNodeValue_;
            return this.evalTyped(frameValue, operandNodeValue__, this.evalTyped_invokeNode_);
        }
        if ((state_0 & 0x20) != 0 && ToStringNodeGen.fallbackGuard_(state_0, operandNodeValue_)) {
            return this.fallback(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, operandNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(VirtualFrame frameValue, Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            if (operandNodeValue instanceof String) {
                String operandNodeValue_ = (String)operandNodeValue;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.evalString(operandNodeValue_);
                return string;
            }
            if (operandNodeValue instanceof Long) {
                long operandNodeValue_ = (Long)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.evalInt(operandNodeValue_);
                return string;
            }
            if (operandNodeValue instanceof Double) {
                double operandNodeValue_ = (Double)operandNodeValue;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.evalFloat(operandNodeValue_);
                return string;
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_ = (Boolean)operandNodeValue;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                String string = this.evalBoolean(operandNodeValue_);
                return string;
            }
            if (operandNodeValue instanceof VmTyped) {
                VmTyped operandNodeValue_ = (VmTyped)operandNodeValue;
                this.evalTyped_invokeNode_ = super.insert(this.createInvokeNode());
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                String string = this.evalTyped(frameValue, operandNodeValue_, this.evalTyped_invokeNode_);
                return string;
            }
            this.state_0_ = state_0 |= 0x20;
            lock.unlock();
            hasLock = false;
            Object object = this.fallback(operandNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state_0, Object operandNodeValue) {
        if ((state_0 & 1) == 0 && operandNodeValue instanceof String) {
            return false;
        }
        if ((state_0 & 2) == 0 && operandNodeValue instanceof Long) {
            return false;
        }
        if ((state_0 & 4) == 0 && operandNodeValue instanceof Double) {
            return false;
        }
        if ((state_0 & 8) == 0 && operandNodeValue instanceof Boolean) {
            return false;
        }
        return (state_0 & 0x10) != 0 || !(operandNodeValue instanceof VmTyped);
    }

    public static ToStringNode create(SourceSection sourceSection, ExpressionNode operandNode) {
        return new ToStringNodeGen(sourceSection, operandNode);
    }
}

