/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.pkl.core.PClassInfo;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UnresolvedClassMemberNode;
import org.pkl.core.ast.member.UnresolvedMethodNode;
import org.pkl.core.ast.member.UnresolvedPropertyNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;

@NodeInfo(shortName="class")
public final class ClassNode
extends ExpressionNode {
    private final SourceSection headerSection;
    private final @Nullable SourceSection docComment;
    @Node.Children
    private final ExpressionNode[] annotationNodes;
    private final int modifiers;
    private final PClassInfo<?> classInfo;
    private final List<TypeParameter> typeParameters;
    private final @Nullable ModuleInfo moduleInfo;
    @Node.Child
    private @Nullable UnresolvedTypeNode unresolvedSupertypeNode;
    private final EconomicMap<Object, ObjectMember> prototypeMembers;
    @Node.Children
    private final UnresolvedPropertyNode[] unresolvedPropertyNodes;
    @Node.Children
    private final UnresolvedMethodNode[] unresolvedMethodNodes;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private VmClass cachedClass;

    public ClassNode(SourceSection section, SourceSection headerSection, @Nullable SourceSection docComment, ExpressionNode[] annotationNodes, int modifiers, PClassInfo<?> classInfo, List<TypeParameter> typeParameters, @Nullable ModuleInfo moduleInfo, @Nullable UnresolvedTypeNode unresolvedSupertypeNode, EconomicMap<Object, ObjectMember> prototypeMembers, UnresolvedPropertyNode[] unresolvedPropertyNodes, UnresolvedMethodNode[] unresolvedMethodNodes) {
        super(section);
        this.headerSection = headerSection;
        this.docComment = docComment;
        this.annotationNodes = annotationNodes;
        this.modifiers = modifiers;
        this.classInfo = classInfo;
        this.typeParameters = typeParameters;
        this.moduleInfo = moduleInfo;
        this.unresolvedSupertypeNode = unresolvedSupertypeNode;
        this.prototypeMembers = prototypeMembers;
        this.unresolvedPropertyNodes = unresolvedPropertyNodes;
        this.unresolvedMethodNodes = unresolvedMethodNodes;
    }

    @Override
    public VmClass executeGeneric(VirtualFrame frame) {
        VmTyped prototype;
        boolean isModuleClass;
        if (this.cachedClass != null) {
            return this.cachedClass;
        }
        CompilerDirectives.transferToInterpreter();
        VmTyped module = VmUtils.getTypedObjectReceiver(frame);
        boolean bl = isModuleClass = this.moduleInfo != null;
        if (isModuleClass) {
            prototype = module;
            prototype.setExtraStorage(this.moduleInfo);
            prototype.addProperties(this.prototypeMembers);
        } else {
            prototype = new VmTyped(frame.materialize(), null, null, this.prototypeMembers);
        }
        ArrayList<VmTyped> annotations = new ArrayList<VmTyped>(this.annotationNodes.length);
        if (this.moduleInfo != null) {
            this.moduleInfo.initAnnotations(annotations);
        }
        this.cachedClass = new VmClass(this.sourceSection, this.headerSection, this.docComment, annotations, this.modifiers, this.classInfo, this.typeParameters, prototype);
        if (this.unresolvedSupertypeNode != null) {
            TypeNode supertypeNode = this.unresolvedSupertypeNode.execute(frame);
            VmClass superclass = supertypeNode.getVmClass();
            this.checkSupertype(supertypeNode, superclass);
            this.cachedClass.initSupertype(supertypeNode, superclass);
        }
        VmUtils.evaluateAnnotations(frame, this.annotationNodes, annotations);
        for (UnresolvedPropertyNode unresolvedPropertyNode : this.unresolvedPropertyNodes) {
            this.cachedClass.addProperty(unresolvedPropertyNode.execute(frame, this.cachedClass));
        }
        for (UnresolvedClassMemberNode unresolvedClassMemberNode : this.unresolvedMethodNodes) {
            this.cachedClass.addMethod(((UnresolvedMethodNode)unresolvedClassMemberNode).execute(frame, this.cachedClass));
        }
        this.cachedClass.notifyInitialized();
        return this.cachedClass;
    }

    private void checkSupertype(TypeNode supertypeNode, @Nullable VmClass superclass) {
        if (superclass == null) {
            throw this.exceptionBuilder().evalError("invalidSupertype", supertypeNode.getSourceSection().getCharacters()).withSourceSection(supertypeNode.getSourceSection()).build();
        }
        if (this.moduleInfo != null) {
            if (this.cachedClass == superclass) {
                throw this.exceptionBuilder().evalError("moduleCannotExtendSelf", this.moduleInfo.getModuleName()).withSourceSection(supertypeNode.getSourceSection()).build();
            }
            if (superclass.isClosed()) {
                throw this.exceptionBuilder().evalError("cannotExtendFinalModule", superclass.getModuleName()).withSourceSection(supertypeNode.getSourceSection()).build();
            }
        } else {
            if (this.cachedClass == superclass) {
                throw this.exceptionBuilder().evalError("classCannotExtendSelf", superclass.getDisplayName()).withSourceSection(supertypeNode.getSourceSection()).build();
            }
            if (superclass.isClosed()) {
                throw this.exceptionBuilder().evalError("cannotExtendFinalClass", superclass.getDisplayName()).withSourceSection(supertypeNode.getSourceSection()).build();
            }
            if (superclass.isExternal() && !this.classInfo.isStandardLibraryClass()) {
                throw new VmExceptionBuilder().evalError("cannotExtendExternalClass", superclass.getDisplayName()).withSourceSection(supertypeNode.getSourceSection()).build();
            }
        }
    }
}

