/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.expression.primary.GetOwnerNode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public abstract class TypeCheckedPropertyNode
extends MemberNode {
    @Node.Child
    @Executed
    protected ExpressionNode ownerNode = new GetOwnerNode();

    protected TypeCheckedPropertyNode(@Nullable VmLanguage language, FrameDescriptor descriptor, ObjectMember member, ExpressionNode bodyNode) {
        super(language, descriptor, member, bodyNode);
        assert (member.isProp());
    }

    @Specialization(guards={"owner.getVmClass() == cachedOwnerClass"})
    protected Object evalTypedObjectCached(VirtualFrame frame, VmTyped owner, @Cached(value="owner.getVmClass()") VmClass cachedOwnerClass, @Cached(value="getProperty(cachedOwnerClass)") ClassProperty property, @Cached(value="createTypeCheckCallNode(property)") @Nullable DirectCallNode callNode) {
        Object result = this.executeBody(frame);
        if (callNode != null && !this.shouldRunTypecheck(frame)) {
            callNode.call(VmUtils.getReceiverOrNull(frame), property.getOwner(), result);
        }
        return result;
    }

    @Specialization(guards={"!owner.isDynamic()"})
    protected Object eval(VirtualFrame frame, VmObjectLike owner, @Cached(value="create()") IndirectCallNode callNode) {
        ClassProperty property;
        PropertyTypeNode typeAnnNode;
        Object result = this.executeBody(frame);
        if (!this.shouldRunTypecheck(frame) && (typeAnnNode = (property = this.getProperty(owner.getVmClass())).getTypeNode()) != null) {
            callNode.call(typeAnnNode.getCallTarget(), VmUtils.getReceiverOrNull(frame), property.getOwner(), result);
        }
        return result;
    }

    @Specialization
    protected Object eval(VirtualFrame frame, VmDynamic owner) {
        return this.executeBody(frame);
    }

    protected ClassProperty getProperty(VmClass ownerClass) {
        ClassProperty result = ownerClass.getProperty(this.member.getName());
        assert (result != null);
        return result;
    }

    protected @Nullable DirectCallNode createTypeCheckCallNode(ClassProperty property) {
        PropertyTypeNode typeCheckNode = property.getTypeNode();
        return typeCheckNode == null ? null : DirectCallNode.create(typeCheckNode.getCallTarget());
    }
}

