/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pkl.core.PType;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ConstantValueNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.SimpleRootNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.expression.primary.GetModuleNode;
import org.pkl.core.ast.frame.WriteFrameSlotNode;
import org.pkl.core.ast.frame.WriteFrameSlotNodeGen;
import org.pkl.core.ast.member.DefaultPropertyBodyNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.ast.type.IdentityMixinNode;
import org.pkl.core.ast.type.TypeConstraintNode;
import org.pkl.core.ast.type.TypeNodeFactory;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;

public abstract class TypeNode
extends PklNode {
    protected TypeNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    public boolean isNoopTypeCheck() {
        return false;
    }

    public abstract FrameSlotKind getFrameSlotKind();

    public abstract TypeNode initWriteSlotNode(int var1);

    public abstract void execute(VirtualFrame var1, Object var2);

    public abstract void executeAndSet(VirtualFrame var1, Object var2);

    public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
        return null;
    }

    public static TypeNode forClass(SourceSection sourceSection, VmClass clazz) {
        return clazz.isClosed() ? new FinalClassTypeNode(sourceSection, clazz) : TypeNodeFactory.NonFinalClassTypeNodeGen.create(sourceSection, clazz);
    }

    public static PType export(@Nullable TypeNode node) {
        return node != null ? node.doExport() : PType.UNKNOWN;
    }

    public static VmTyped getMirror(@Nullable TypeNode node) {
        return node != null ? node.getMirror() : MirrorFactories.unknownTypeFactory.create(null);
    }

    public static VmList getMirrors(TypeNode[] nodes) {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (TypeNode node : nodes) {
            builder.add(node.getMirror());
        }
        return builder.build();
    }

    protected PType doExport() {
        VmTypeAlias alias = this.getVmTypeAlias();
        if (alias != null) {
            return new PType.Alias(alias.export());
        }
        VmClass clazz = this.getVmClass();
        if (clazz != null) {
            return new PType.Class(clazz.export());
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().bug("`%s` must override method `doExport()`.", this.getClass().getTypeName()).build();
    }

    public @Nullable VmClass getVmClass() {
        return null;
    }

    public @Nullable VmTypeAlias getVmTypeAlias() {
        return null;
    }

    public VmTyped getMirror() {
        return MirrorFactories.classTypeFactory.create(this);
    }

    public VmList getTypeArgumentMirrors() {
        return VmList.EMPTY;
    }

    protected final VmTypeMismatchException typeMismatch(Object actualValue, Object expectedType) {
        return new VmTypeMismatchException.Simple(this.sourceSection, actualValue, expectedType);
    }

    private static @Nullable Object createDefaultValue(VmClass clazz) {
        if (clazz.isInstantiable()) {
            if (clazz.isListingClass()) {
                return VmListing.empty();
            }
            if (clazz.isMappingClass()) {
                return VmMapping.empty();
            }
            return clazz.getPrototype();
        }
        if (clazz.isListClass()) {
            return VmList.EMPTY;
        }
        if (clazz.isSetClass()) {
            return VmSet.EMPTY;
        }
        if (clazz.isMapClass()) {
            return VmMap.EMPTY;
        }
        if (clazz.isCollectionClass()) {
            return VmList.EMPTY;
        }
        if (clazz.isNullClass()) {
            return VmNull.withoutDefault();
        }
        return null;
    }

    private static VmList createUnknownTypeArgumentMirrors(VmClass clazz) {
        int typeParameterCount = clazz.getTypeParameterCount();
        if (typeParameterCount == 0) {
            return VmList.EMPTY;
        }
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (int i = 0; i < typeParameterCount; ++i) {
            builder.add(MirrorFactories.unknownTypeFactory.create(null));
        }
        return builder.build();
    }

    public static final class BooleanTypeNode
    extends FrameSlotTypeNode {
        public BooleanTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Boolean;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Boolean) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getBooleanClass());
        }

        @Override
        public void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setBoolean(this.slot, (Boolean)value2);
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getBooleanClass();
        }
    }

    public static final class FloatTypeNode
    extends FrameSlotTypeNode {
        public FloatTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Double;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Double) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getFloatClass());
        }

        @Override
        public void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setDouble(this.slot, (Double)value2);
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getFloatClass();
        }
    }

    public static final class IntTypeNode
    extends IntSlotTypeNode {
        public IntTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }
    }

    public static final class NumberTypeNode
    extends FrameSlotTypeNode {
        public NumberTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Illegal;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long || value2 instanceof Double) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getNumberClass());
        }

        @Override
        public void executeAndSet(VirtualFrame frame, Object value2) {
            FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.slot);
            if (value2 instanceof Long) {
                if (kind == FrameSlotKind.Double || kind == FrameSlotKind.Object) {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Object);
                    frame.setObject(this.slot, value2);
                } else {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Long);
                    frame.setLong(this.slot, (Long)value2);
                }
            } else if (value2 instanceof Double) {
                if (kind == FrameSlotKind.Long || kind == FrameSlotKind.Object) {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Object);
                    frame.setObject(this.slot, value2);
                } else {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Double);
                    frame.setDouble(this.slot, (Double)value2);
                }
            } else {
                throw this.typeMismatch(value2, BaseModule.getNumberClass());
            }
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getNumberClass();
        }
    }

    public static final class StringTypeNode
    extends ObjectSlotTypeNode {
        public StringTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof String) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getStringClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getStringClass();
        }
    }

    public static final class AnyTypeNode
    extends WriteFrameSlotTypeNode {
        public AnyTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public boolean isNoopTypeCheck() {
            return true;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getAnyClass();
        }
    }

    public static final class ConstrainedTypeNode
    extends TypeNode {
        @Node.Child
        private TypeNode childNode;
        @Node.Children
        private final TypeConstraintNode[] constraintNodes;
        @CompilerDirectives.CompilationFinal
        private int customThisSlot = -1;

        public ConstrainedTypeNode(SourceSection sourceSection, TypeNode childNode, TypeConstraintNode[] constraintNodes) {
            super(sourceSection);
            this.childNode = childNode;
            this.constraintNodes = constraintNodes;
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return this.childNode.getFrameSlotKind();
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            this.childNode.initWriteSlotNode(slot);
            return this;
        }

        @Override
        @ExplodeLoop
        public void execute(VirtualFrame frame, Object value2) {
            if (this.customThisSlot == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.customThisSlot = frame.getFrameDescriptor().findOrAddAuxiliarySlot(SymbolTable.CustomThisScope.FRAME_SLOT_ID);
            }
            this.childNode.execute(frame, value2);
            frame.setAuxiliarySlot(this.customThisSlot, value2);
            for (TypeConstraintNode node : this.constraintNodes) {
                node.execute(frame);
            }
        }

        @Override
        public void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            this.childNode.executeAndSet(frame, value2);
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.childNode.createDefaultValue(language, headerSection, qualifiedName);
        }

        public SourceSection getBaseTypeSection() {
            return this.childNode.getSourceSection();
        }

        public SourceSection getFirstConstraintSection() {
            return this.constraintNodes[0].getSourceSection();
        }

        @Override
        protected PType doExport() {
            return new PType.Constrained(this.childNode.doExport(), Arrays.stream(this.constraintNodes).map(TypeConstraintNode::export).collect(Collectors.toList()));
        }

        @Override
        public VmTyped getMirror() {
            return this.childNode.getMirror();
        }
    }

    public static final class TypeAliasTypeNode
    extends TypeNode {
        private final VmTypeAlias typeAlias;
        private final TypeNode[] typeArgumentNodes;
        @Node.Child
        private TypeNode aliasedTypeNode;

        public TypeAliasTypeNode(SourceSection sourceSection, VmTypeAlias typeAlias, TypeNode[] typeArgumentNodes) {
            super(sourceSection);
            if (!typeAlias.isInitialized()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("cyclicTypeAlias", new Object[0]).build();
            }
            if (typeArgumentNodes.length > 0 && typeArgumentNodes.length != typeAlias.getTypeParameterCount()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("wrongTypeArgumentCount", typeAlias.getTypeParameterCount(), typeArgumentNodes.length).build();
            }
            this.typeAlias = typeAlias;
            this.typeArgumentNodes = typeArgumentNodes;
            this.aliasedTypeNode = typeAlias.instantiate(typeArgumentNodes);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return this.aliasedTypeNode.getFrameSlotKind();
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            this.aliasedTypeNode.initWriteSlotNode(slot);
            return this;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return TypeAliasTypeNode.getMirrors(this.typeArgumentNodes);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            this.aliasedTypeNode.execute(frame, value2);
        }

        @Override
        public void executeAndSet(VirtualFrame frame, Object value2) {
            this.aliasedTypeNode.executeAndSet(frame, value2);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            if (this.typeAlias == BaseModule.getMixinTypeAlias()) {
                return new VmFunction(VmUtils.createEmptyMaterializedFrame(), null, 1, new IdentityMixinNode(language, new FrameDescriptor(), this.getSourceSection(), qualifiedName, this.typeArgumentNodes.length == 1 ? this.typeArgumentNodes[0] : null), null);
            }
            return this.aliasedTypeNode.createDefaultValue(language, headerSection, qualifiedName);
        }

        @Override
        public @Nullable VmClass getVmClass() {
            return this.aliasedTypeNode.getVmClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return this.typeAlias;
        }

        @Override
        protected PType doExport() {
            return new PType.Alias(this.typeAlias.export(), Arrays.stream(this.typeArgumentNodes).map(TypeNode::export).collect(Collectors.toList()), this.aliasedTypeNode.doExport());
        }
    }

    public static final class Int32TypeAliasTypeNode
    extends IntSlotTypeNode {
        public Int32TypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                long v = (Long)value2;
                if (v == (long)((int)v)) {
                    return;
                }
                throw new VmTypeMismatchException.Constraint(BaseModule.getInt32TypeAlias().getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(BaseModule.getInt32TypeAlias().getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getInt32TypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }
    }

    public static final class Int16TypeAliasTypeNode
    extends IntSlotTypeNode {
        public Int16TypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                long v = (Long)value2;
                if (v == (long)((short)v)) {
                    return;
                }
                throw new VmTypeMismatchException.Constraint(BaseModule.getInt16TypeAlias().getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(BaseModule.getInt16TypeAlias().getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getInt16TypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }
    }

    public static final class Int8TypeAliasTypeNode
    extends IntSlotTypeNode {
        public Int8TypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                long v = (Long)value2;
                if (v == (long)((byte)v)) {
                    return;
                }
                throw new VmTypeMismatchException.Constraint(BaseModule.getInt8TypeAlias().getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(BaseModule.getInt8TypeAlias().getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getInt8TypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }
    }

    public static final class UIntTypeAliasTypeNode
    extends IntSlotTypeNode {
        private final VmTypeAlias typeAlias;
        private final long mask;

        public UIntTypeAliasTypeNode(VmTypeAlias typeAlias, long mask) {
            super(VmUtils.unavailableSourceSection());
            this.typeAlias = typeAlias;
            this.mask = mask;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                long v = (Long)value2;
                if ((v & this.mask) == v) {
                    return;
                }
                throw new VmTypeMismatchException.Constraint(this.typeAlias.getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(this.typeAlias.getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return this.typeAlias;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }
    }

    public static final class NonNullTypeAliasTypeNode
    extends WriteFrameSlotTypeNode {
        public NonNullTypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmNull) {
                throw new VmTypeMismatchException.Constraint(BaseModule.getNonNullTypeAlias().getConstraintSection(), value2);
            }
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getNonNullTypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }
    }

    public static final class TypeVariableNode
    extends WriteFrameSlotTypeNode {
        private final TypeParameter typeParameter;

        public TypeVariableNode(SourceSection sourceSection, TypeParameter typeParameter) {
            super(sourceSection);
            this.typeParameter = typeParameter;
        }

        public int getTypeParameterIndex() {
            return this.typeParameter.getIndex();
        }

        @Override
        public boolean isNoopTypeCheck() {
            return true;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeVariableFactory.create(this);
        }

        public VmTyped getTypeParameterMirror() {
            return MirrorFactories.typeParameterFactory.create(this.typeParameter);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
        }

        @Override
        protected PType doExport() {
            return new PType.TypeVariable(this.typeParameter);
        }
    }

    public static class VarArgsTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;

        public VarArgsTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("internalStdLibClass", "VarArgs").withSourceSection(headerSection).build();
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getVarArgsClass().export(), this.elementTypeNode.doExport());
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("internalStdLibClass", "VarArgs").build();
        }
    }

    public static abstract class PairTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode firstTypeNode;
        @Node.Child
        private TypeNode secondTypeNode;

        protected PairTypeNode(SourceSection sourceSection, TypeNode firstTypeNode, TypeNode secondTypeNode) {
            super(sourceSection);
            this.firstTypeNode = firstTypeNode;
            this.secondTypeNode = secondTypeNode;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getPairClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.firstTypeNode.getMirror(), this.secondTypeNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getPairClass().export(), this.firstTypeNode.doExport(), this.secondTypeNode.doExport());
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmPair value2) {
            this.firstTypeNode.execute(frame, value2.getFirst());
            this.secondTypeNode.execute(frame, value2.getSecond());
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getPairClass());
        }
    }

    public static abstract class FunctionNClassTypeNode
    extends ObjectSlotTypeNode {
        private final TypeNode[] typeArgumentNodes;

        protected FunctionNClassTypeNode(SourceSection sourceSection, TypeNode[] typeArgumentNodes) {
            super(sourceSection);
            this.typeArgumentNodes = typeArgumentNodes;
        }

        @Override
        public final VmClass getVmClass() {
            return this.getFunctionNClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return FunctionNClassTypeNode.getMirrors(this.typeArgumentNodes);
        }

        @Override
        protected final PType doExport() {
            List<PType> typeArguments = Arrays.stream(this.typeArgumentNodes).map(TypeNode::export).collect(Collectors.toList());
            return new PType.Class(this.getFunctionNClass().export(), typeArguments);
        }

        @Specialization(guards={"value.getVmClass() == getFunctionNClass()"})
        protected void eval(VmFunction value2) {
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, this.getFunctionNClass());
        }

        protected VmClass getFunctionNClass() {
            return BaseModule.getFunctionNClass(this.typeArgumentNodes.length - 1);
        }
    }

    public static abstract class FunctionClassTypeNode
    extends ObjectSlotTypeNode {
        private final TypeNode typeArgumentNode;

        protected FunctionClassTypeNode(SourceSection sourceSection, TypeNode typeArgumentNode) {
            super(sourceSection);
            this.typeArgumentNode = typeArgumentNode;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getFunctionClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.typeArgumentNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getFunctionClass().export(), TypeNode.export(this.typeArgumentNode));
        }

        @Specialization
        protected void eval(VmFunction value2) {
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getFunctionClass());
        }
    }

    public static abstract class FunctionTypeNode
    extends ObjectSlotTypeNode {
        private final TypeNode[] parameterTypeNodes;
        private final TypeNode returnTypeNode;

        protected FunctionTypeNode(SourceSection sourceSection, TypeNode[] parameterTypeNodes, TypeNode returnTypeNode) {
            super(sourceSection);
            this.parameterTypeNodes = parameterTypeNodes;
            this.returnTypeNode = returnTypeNode;
        }

        @Override
        public final VmClass getVmClass() {
            return this.getFunctionNClass();
        }

        @Override
        public final VmTyped getMirror() {
            return MirrorFactories.functionTypeFactory.create(this);
        }

        public final VmList getParameterTypeMirrors() {
            return FunctionTypeNode.getMirrors(this.parameterTypeNodes);
        }

        public final VmTyped getReturnTypeMirror() {
            return this.returnTypeNode.getMirror();
        }

        @Override
        protected final PType doExport() {
            List<PType> parameterTypes = Arrays.stream(this.parameterTypeNodes).map(TypeNode::export).collect(Collectors.toList());
            return new PType.Function(parameterTypes, TypeNode.export(this.returnTypeNode));
        }

        @Specialization(guards={"value.getVmClass() == getFunctionNClass()"})
        protected void eval(VmFunction value2) {
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, this.getFunctionNClass());
        }

        protected VmClass getFunctionNClass() {
            return BaseModule.getFunctionNClass(this.parameterTypeNodes.length);
        }
    }

    public static abstract class ListingOrMappingTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        protected @Nullable TypeNode keyTypeNode;
        @Node.Child
        protected TypeNode valueTypeNode;
        private final boolean skipKeyTypeChecks;
        private final boolean skipValueTypeChecks;

        protected ListingOrMappingTypeNode(SourceSection sourceSection, @Nullable TypeNode keyTypeNode, TypeNode valueTypeNode) {
            super(sourceSection);
            this.keyTypeNode = keyTypeNode;
            this.valueTypeNode = valueTypeNode;
            this.skipKeyTypeChecks = keyTypeNode == null || keyTypeNode.isNoopTypeCheck();
            this.skipValueTypeChecks = valueTypeNode.isNoopTypeCheck();
        }

        private boolean isListing() {
            return this.keyTypeNode == null;
        }

        public @Nullable TypeNode getKeyTypeNode() {
            return this.keyTypeNode;
        }

        public TypeNode getValueTypeNode() {
            return this.valueTypeNode;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            if (this.valueTypeNode instanceof UnknownTypeNode) {
                if (this.isListing()) {
                    return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), EconomicMaps.create(), 0);
                }
                return new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), EconomicMaps.create());
            }
            ObjectMember defaultMember = new ObjectMember(headerSection, headerSection, 8, Identifier.DEFAULT, qualifiedName + ".default");
            Object defaultMemberValue = this.valueTypeNode.createDefaultValue(language, headerSection, qualifiedName);
            if (defaultMemberValue == null) {
                defaultMember.initMemberNode(new UntypedObjectMemberNode(language, new FrameDescriptor(), defaultMember, (ExpressionNode)new DefaultPropertyBodyNode(headerSection, Identifier.DEFAULT, null)));
            } else {
                defaultMember.initConstantValue(new VmFunction(VmUtils.createEmptyMaterializedFrame(), null, 1, new SimpleRootNode(language, new FrameDescriptor(), headerSection, defaultMember.getQualifiedName() + ".<function>", new ConstantValueNode(defaultMemberValue)), null));
            }
            if (this.isListing()) {
                return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), EconomicMaps.of(Identifier.DEFAULT, defaultMember), 0);
            }
            return new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), EconomicMaps.of(Identifier.DEFAULT, defaultMember));
        }

        protected void doEval(VirtualFrame frame, VmObject object) {
            if (this.skipKeyTypeChecks && this.skipValueTypeChecks) {
                return;
            }
            int loopCount = 0;
            for (VmObject owner = object; owner != null; owner = owner.getParent()) {
                UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(owner.getMembers());
                while (cursor.advance()) {
                    ++loopCount;
                    ObjectMember member = cursor.getValue();
                    if (member.isProp()) continue;
                    Object memberKey = cursor.getKey();
                    if (!this.skipKeyTypeChecks) {
                        assert (this.keyTypeNode != null);
                        this.keyTypeNode.execute(frame, memberKey);
                    }
                    if (this.skipValueTypeChecks) continue;
                    Object memberValue = object.getCachedValue(memberKey);
                    if (memberValue == null) {
                        memberValue = member.getConstantValue();
                        if (memberValue == null) {
                            RootCallTarget callTarget = member.getCallTarget();
                            memberValue = callTarget.call(object, owner, memberKey);
                        }
                        object.setCachedValue(memberKey, memberValue);
                    }
                    this.valueTypeNode.execute(frame, memberValue);
                }
            }
            LoopNode.reportLoopCount(this, loopCount);
        }

        @Fallback
        protected void fallback(Object value2) {
            VmClass clazz = this.getVmClass();
            assert (clazz != null);
            throw this.typeMismatch(value2, clazz);
        }
    }

    public static abstract class MappingTypeNode
    extends ListingOrMappingTypeNode {
        public MappingTypeNode(SourceSection sourceSection, TypeNode keyTypeNode, TypeNode valueTypeNode) {
            super(sourceSection, keyTypeNode, valueTypeNode);
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmMapping value2) {
            this.doEval(frame, value2);
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getMappingClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            assert (this.keyTypeNode != null);
            return VmList.of(this.keyTypeNode.getMirror(), this.valueTypeNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            assert (this.keyTypeNode != null);
            return new PType.Class(BaseModule.getMappingClass().export(), this.keyTypeNode.doExport(), this.valueTypeNode.doExport());
        }
    }

    public static abstract class ListingTypeNode
    extends ListingOrMappingTypeNode {
        public ListingTypeNode(SourceSection sourceSection, TypeNode valueTypeNode) {
            super(sourceSection, null, valueTypeNode);
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmListing value2) {
            this.doEval(frame, value2);
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getListingClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.valueTypeNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getListingClass().export(), this.valueTypeNode.doExport());
        }
    }

    public static abstract class MapTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode keyTypeNode;
        @Node.Child
        private TypeNode valueTypeNode;
        private final boolean skipEntryTypeChecks;

        protected MapTypeNode(SourceSection sourceSection, TypeNode keyTypeNode, TypeNode valueTypeNode) {
            super(sourceSection);
            this.keyTypeNode = keyTypeNode;
            this.valueTypeNode = valueTypeNode;
            this.skipEntryTypeChecks = keyTypeNode.isNoopTypeCheck() && valueTypeNode.isNoopTypeCheck();
        }

        @Override
        public final Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmMap.EMPTY;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getMapClass();
        }

        public TypeNode getValueTypeNode() {
            return this.valueTypeNode;
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.keyTypeNode.getMirror(), this.valueTypeNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getMapClass().export(), this.keyTypeNode.doExport(), this.valueTypeNode.doExport());
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmMap value2) {
            if (this.skipEntryTypeChecks) {
                return;
            }
            for (Map.Entry<Object, Object> entry : value2) {
                this.keyTypeNode.execute(frame, VmUtils.getKey(entry));
                this.valueTypeNode.execute(frame, VmUtils.getValue(entry));
            }
            LoopNode.reportLoopCount(this, value2.getLength());
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getMapClass());
        }
    }

    public static abstract class SetTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;
        private final boolean skipElementTypeChecks;

        protected SetTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
            this.skipElementTypeChecks = elementTypeNode.isNoopTypeCheck();
        }

        @Override
        public final Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmSet.EMPTY;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getSetClass();
        }

        public TypeNode getElementTypeNode() {
            return this.elementTypeNode;
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.elementTypeNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getSetClass().export(), this.elementTypeNode.doExport());
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmSet value2) {
            if (this.skipElementTypeChecks) {
                return;
            }
            for (Object elem : value2) {
                this.elementTypeNode.execute(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getSetClass());
        }
    }

    public static abstract class ListTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;
        private final boolean skipElementTypeChecks;

        protected ListTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
            this.skipElementTypeChecks = elementTypeNode.isNoopTypeCheck();
        }

        @Override
        public final Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmList.EMPTY;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getListClass();
        }

        public TypeNode getElementTypeNode() {
            return this.elementTypeNode;
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.elementTypeNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getListClass().export(), this.elementTypeNode.doExport());
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmList value2) {
            if (this.skipElementTypeChecks) {
                return;
            }
            for (Object elem : value2) {
                this.elementTypeNode.execute(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getListClass());
        }
    }

    public static abstract class CollectionTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;

        protected CollectionTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmList.EMPTY;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getCollectionClass();
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getCollectionClass().export(), this.elementTypeNode.doExport());
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.elementTypeNode.getMirror());
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmList value2) {
            for (Object elem : value2) {
                this.elementTypeNode.execute(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
        }

        @Specialization
        protected void eval(VirtualFrame frame, VmSet value2) {
            for (Object elem : value2) {
                this.elementTypeNode.execute(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getCollectionClass());
        }
    }

    public static final class UnionOfStringLiteralsTypeNode
    extends ObjectSlotTypeNode {
        private final Set<String> stringLiterals;
        private final @Nullable String unionDefault;

        UnionOfStringLiteralsTypeNode(SourceSection sourceSection, int defaultIndex, Set<String> stringLiterals) {
            super(sourceSection);
            assert (!stringLiterals.isEmpty());
            this.stringLiterals = stringLiterals;
            this.unionDefault = defaultIndex == -1 ? null : stringLiterals.toArray(new String[0])[defaultIndex];
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.unionOfStringLiteralsTypeFactory.create(this);
        }

        public VmList getElementTypeMirrors() {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            for (String literal : this.stringLiterals) {
                builder.add(MirrorFactories.stringLiteralTypeFactory2.create(literal));
            }
            return builder.build();
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (this.contains(value2)) {
                return;
            }
            throw this.typeMismatch(value2, this.stringLiterals);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean contains(Object value2) {
            return this.stringLiterals.contains(value2);
        }

        @Override
        protected PType doExport() {
            return new PType.Union(this.stringLiterals.stream().map(PType.StringLiteral::new).collect(Collectors.toList()));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.unionDefault;
        }
    }

    public static final class UnionTypeNode
    extends WriteFrameSlotTypeNode {
        @Node.Children
        final TypeNode[] elementTypeNodes;
        private final boolean skipElementTypeChecks;
        private final int defaultIndex;

        public UnionTypeNode(SourceSection sourceSection, int defaultIndex, TypeNode[] elementTypeNodes, boolean skipElementTypeChecks) {
            super(sourceSection);
            assert (elementTypeNodes.length > 0);
            this.elementTypeNodes = elementTypeNodes;
            this.defaultIndex = defaultIndex;
            this.skipElementTypeChecks = skipElementTypeChecks;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.unionTypeFactory.create(this);
        }

        public VmList getElementTypeMirrors() {
            return UnionTypeNode.getMirrors(this.elementTypeNodes);
        }

        public TypeNode[] getElementTypeNodes() {
            return this.elementTypeNodes;
        }

        @Override
        public boolean isNoopTypeCheck() {
            return this.skipElementTypeChecks;
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.defaultIndex == -1 ? null : this.elementTypeNodes[this.defaultIndex].createDefaultValue(language, headerSection, qualifiedName);
        }

        @Override
        protected PType doExport() {
            List<PType> elementTypes = Arrays.stream(this.elementTypeNodes).map(TypeNode::export).collect(Collectors.toList());
            return new PType.Union(elementTypes);
        }

        @Override
        @ExplodeLoop
        public void execute(VirtualFrame frame, Object value2) {
            if (this.skipElementTypeChecks) {
                return;
            }
            VmTypeMismatchException[] typeMismatches = new VmTypeMismatchException[this.elementTypeNodes.length];
            for (int i = 0; i < this.elementTypeNodes.length; ++i) {
                try {
                    this.elementTypeNodes[i].execute(frame, value2);
                    return;
                }
                catch (VmTypeMismatchException e2) {
                    typeMismatches[i] = e2;
                    continue;
                }
            }
            throw new VmTypeMismatchException.Union(this.sourceSection, value2, this, typeMismatches);
        }
    }

    public static abstract class NullableTypeNode
    extends WriteFrameSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;

        public NullableTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        public TypeNode getElementTypeNode() {
            return this.elementTypeNode;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.nullableTypeFactory.create(this);
        }

        public VmTyped getElementTypeMirror() {
            return this.elementTypeNode.getMirror();
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmNull.withDefault(this.elementTypeNode.createDefaultValue(language, headerSection, qualifiedName));
        }

        @Override
        protected final PType doExport() {
            return new PType.Nullable(this.elementTypeNode.doExport());
        }

        @Specialization
        protected void eval(VmNull value2) {
        }

        @Fallback
        protected void eval(VirtualFrame frame, Object value2) {
            this.elementTypeNode.execute(frame, value2);
        }
    }

    public static abstract class NonFinalClassTypeNode
    extends ObjectSlotTypeNode {
        protected final VmClass clazz;

        public NonFinalClassTypeNode(SourceSection sourceSection, VmClass clazz) {
            super(sourceSection);
            this.clazz = clazz;
        }

        @Override
        public final VmClass getVmClass() {
            return this.clazz;
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return TypeNode.createUnknownTypeArgumentMirrors(this.clazz);
        }

        @ExplodeLoop
        @Specialization(guards={"value.getVmClass() == cachedClass"})
        protected void eval(VmValue value2, @Cached(value="value.getVmClass()") VmClass cachedClass, @Cached(value="clazz.isSuperclassOf(cachedClass)") boolean isSuperclass) {
            if (isSuperclass) {
                return;
            }
            throw this.typeMismatch(value2, this.clazz);
        }

        @Specialization
        protected void eval(VmValue value2) {
            if (this.clazz.isSuperclassOf(value2.getVmClass())) {
                return;
            }
            throw this.typeMismatch(value2, this.clazz);
        }

        @Fallback
        protected void eval(Object value2) {
            throw this.typeMismatch(value2, this.clazz);
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return TypeNode.createDefaultValue(this.clazz);
        }
    }

    public static final class FinalClassTypeNode
    extends ObjectSlotTypeNode {
        private final VmClass clazz;

        public FinalClassTypeNode(SourceSection sourceSection, VmClass clazz) {
            super(sourceSection);
            this.clazz = clazz;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmValue && this.clazz == ((VmValue)value2).getVmClass()) {
                return;
            }
            throw this.typeMismatch(value2, this.clazz);
        }

        @Override
        public VmClass getVmClass() {
            return this.clazz;
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return TypeNode.createUnknownTypeArgumentMirrors(this.clazz);
        }

        @Override
        public @Nullable Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return TypeNode.createDefaultValue(this.clazz);
        }
    }

    public static final class DynamicTypeNode
    extends ObjectSlotTypeNode {
        public DynamicTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmDynamic) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getDynamicClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getDynamicClass();
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmDynamic.empty();
        }
    }

    public static final class TypedTypeNode
    extends ObjectSlotTypeNode {
        public TypedTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmTyped) {
                return;
            }
            throw this.typeMismatch(value2, BaseModule.getTypedClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getTypedClass();
        }
    }

    public static final class StringLiteralTypeNode
    extends ObjectSlotTypeNode {
        private final String literal;

        public StringLiteralTypeNode(SourceSection sourceSection, String literal) {
            super(sourceSection);
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (this.literal.equals(value2)) {
                return;
            }
            throw this.typeMismatch(value2, this.literal);
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.literal;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.stringLiteralTypeFactory.create(this);
        }

        @Override
        protected PType doExport() {
            return new PType.StringLiteral(this.literal);
        }
    }

    public static final class NonFinalModuleTypeNode
    extends ObjectSlotTypeNode {
        private final VmClass moduleClass;
        @Node.Child
        private ExpressionNode getModuleNode;

        public NonFinalModuleTypeNode(SourceSection sourceSection, VmClass moduleClass) {
            super(sourceSection);
            this.moduleClass = moduleClass;
            this.getModuleNode = new GetModuleNode(sourceSection);
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            VmClass valueClass;
            VmClass moduleClass = ((VmTyped)this.getModuleNode.executeGeneric(frame)).getVmClass();
            if (value2 instanceof VmTyped && moduleClass.isSuperclassOf(valueClass = ((VmTyped)value2).getVmClass())) {
                return;
            }
            throw this.typeMismatch(value2, moduleClass);
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.moduleTypeFactory.create(null);
        }

        @Override
        protected PType doExport() {
            return PType.MODULE;
        }

        @Override
        public VmClass getVmClass() {
            return this.moduleClass;
        }
    }

    public static final class FinalModuleTypeNode
    extends ObjectSlotTypeNode {
        private final VmClass moduleClass;

        public FinalModuleTypeNode(SourceSection sourceSection, VmClass moduleClass) {
            super(sourceSection);
            this.moduleClass = moduleClass;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmTyped && ((VmTyped)value2).getVmClass() == this.moduleClass) {
                return;
            }
            throw this.typeMismatch(value2, this.moduleClass);
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.moduleTypeFactory.create(null);
        }

        @Override
        protected PType doExport() {
            return PType.MODULE;
        }

        @Override
        public VmClass getVmClass() {
            return this.moduleClass;
        }
    }

    public static final class NothingTypeNode
    extends TypeNode {
        public NothingTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            return this;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
            CompilerDirectives.transferToInterpreter();
            throw new VmTypeMismatchException.Nothing(this.sourceSection, value2);
        }

        @Override
        public void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Illegal;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.nothingTypeFactory.create(null);
        }

        @Override
        protected PType doExport() {
            return PType.NOTHING;
        }
    }

    public static final class UnknownTypeNode
    extends WriteFrameSlotTypeNode {
        public UnknownTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public boolean isNoopTypeCheck() {
            return true;
        }

        @Override
        public void execute(VirtualFrame frame, Object value2) {
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.unknownTypeFactory.create(null);
        }

        @Override
        protected PType doExport() {
            return PType.UNKNOWN;
        }
    }

    public static abstract class WriteFrameSlotTypeNode
    extends TypeNode {
        @CompilerDirectives.CompilationFinal
        protected int slot;
        @Node.Child
        @LateInit
        private WriteFrameSlotNode writeSlotNode;

        protected WriteFrameSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public final FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Illegal;
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            this.writeSlotNode = WriteFrameSlotNodeGen.create(VmUtils.unavailableSourceSection(), slot, null);
            this.slot = slot;
            return this;
        }

        @Override
        public final void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            this.writeSlotNode.executeWithValue(frame, value2);
        }
    }

    public static abstract class ObjectSlotTypeNode
    extends FrameSlotTypeNode {
        protected ObjectSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public final FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Object;
        }

        @Override
        public final void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setObject(this.slot, value2);
        }
    }

    public static abstract class IntSlotTypeNode
    extends FrameSlotTypeNode {
        protected IntSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public final FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Long;
        }

        @Override
        public final void executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setLong(this.slot, (Long)value2);
        }
    }

    public static abstract class FrameSlotTypeNode
    extends TypeNode {
        @CompilerDirectives.CompilationFinal
        protected int slot = -1;
        @CompilerDirectives.CompilationFinal
        @Node.Child
        protected WriteFrameSlotNode writeFrameSlotNode;

        protected FrameSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slot = slot;
            this.writeFrameSlotNode = WriteFrameSlotNodeGen.create(this.sourceSection, slot, null);
            return this;
        }
    }
}

