/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.project.CanonicalPackageUri;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.ProjectDeps;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.json.Json;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;

public class ProjectDependenciesManager {
    public static final String PKL_PROJECT_FILENAME = "PklProject";
    public static final String PKL_PROJECT_DEPS_FILENAME = "PklProject.deps.json";
    private final DeclaredDependencies declaredDependencies;
    private final Path projectDir;
    @GuardedBy(value="lock")
    private ProjectDeps projectDeps;
    @GuardedBy(value="lock")
    private Map<String, Dependency> myDependencies = null;
    @GuardedBy(value="lock")
    private EconomicMap<PackageUri, Map<String, Dependency>> localPackageDependencies = null;
    @GuardedBy(value="lock")
    private EconomicMap<PackageUri, Map<String, Dependency>> packageDependencies = EconomicMaps.create();
    private final Object lock = new Object();

    public ProjectDependenciesManager(DeclaredDependencies declaredDependencies) {
        this.declaredDependencies = declaredDependencies;
        this.projectDir = Path.of(declaredDependencies.getProjectFileUri()).getParent();
    }

    public boolean hasPath(Path path) {
        return path.startsWith(this.projectDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDependenciesInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myDependencies != null) {
                return;
            }
            ProjectDeps projectDeps = this.getProjectDeps();
            this.myDependencies = this.doBuildResolvedDependenciesForProject(this.declaredDependencies, projectDeps);
            this.localPackageDependencies = EconomicMaps.create();
            for (DeclaredDependencies localPkg : this.declaredDependencies.getLocalDependencies().values()) {
                this.ensureLocalProjectDependencyInitialized(localPkg, projectDeps);
            }
        }
    }

    private void ensureLocalProjectDependencyInitialized(DeclaredDependencies localProjectDependencies, ProjectDeps projectDeps) {
        assert (this.localPackageDependencies != null);
        PackageUri uri = PackageUri.create("project" + localProjectDependencies.getMyPackageUri());
        if (this.localPackageDependencies.containsKey(uri)) {
            return;
        }
        Map<String, Dependency> resolvedDeps = this.doBuildResolvedDependenciesForProject(localProjectDependencies, projectDeps);
        this.localPackageDependencies.put(uri, resolvedDeps);
        for (DeclaredDependencies declaredDeps : localProjectDependencies.getLocalDependencies().values()) {
            this.ensureLocalProjectDependencyInitialized(declaredDeps, projectDeps);
        }
    }

    private void checkProjectDependencyOutOfDate(URI projectFileUri, PackageUri declaredPackage, Dependency resolvedDependency) {
        if (resolvedDependency.getVersion().compareTo(declaredPackage.getVersion()) < 0) {
            throw new PackageLoadError("projectDependenciesOutOfDateInProject", projectFileUri, declaredPackage.getDisplayName(), resolvedDependency.getPackageUri().getDisplayName());
        }
    }

    private Map<String, Dependency> doBuildResolvedDependenciesForProject(DeclaredDependencies declaredDeps, ProjectDeps resolvedProjectDeps) {
        Object packageUri;
        HashMap<String, Dependency> ret = new HashMap<String, Dependency>(declaredDeps.getRemoteDependencies().size() + declaredDeps.getLocalDependencies().size());
        for (Map.Entry<String, DeclaredDependencies> entry : declaredDeps.getLocalDependencies().entrySet()) {
            DeclaredDependencies localDeclaredDependencies = entry.getValue();
            packageUri = localDeclaredDependencies.getMyPackageUri();
            assert (packageUri != null);
            CanonicalPackageUri canonicalPackageUri = CanonicalPackageUri.fromPackageUri(localDeclaredDependencies.getMyPackageUri());
            Dependency resolvedDep = resolvedProjectDeps.get(canonicalPackageUri);
            if (resolvedDep == null) {
                throw new PackageLoadError("unresolvedProjectDependency", packageUri);
            }
            this.checkProjectDependencyOutOfDate(declaredDeps.getProjectFileUri(), (PackageUri)packageUri, resolvedDep);
            ret.put(entry.getKey(), resolvedDep);
        }
        for (Map.Entry<String, Object> entry : declaredDeps.getRemoteDependencies().entrySet()) {
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)entry.getValue();
            packageUri = CanonicalPackageUri.fromPackageUri(remoteDep.getPackageUri());
            Dependency resolvedDep = resolvedProjectDeps.get((CanonicalPackageUri)packageUri);
            if (resolvedDep == null) {
                throw new PackageLoadError("unresolvedProjectDependency", ((Dependency.RemoteDependency)entry.getValue()).getPackageUri());
            }
            this.checkProjectDependencyOutOfDate(declaredDeps.getProjectFileUri(), remoteDep.getPackageUri(), resolvedDep);
            ret.put(entry.getKey(), resolvedDep);
        }
        return ret;
    }

    public Map<String, Dependency> getDependencies() {
        this.ensureDependenciesInitialized();
        return this.myDependencies;
    }

    public boolean isLocalPackage(PackageUri packageUri) {
        this.ensureDependenciesInitialized();
        return this.localPackageDependencies.containsKey(packageUri);
    }

    public Map<String, Dependency> getLocalPackageDependencies(PackageUri packageUri) {
        this.ensureDependenciesInitialized();
        Map dep = (Map)this.localPackageDependencies.get(packageUri);
        assert (dep != null);
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Dependency> getResolvedDependenciesForPackage(PackageUri packageUri, DependencyMetadata dependencyMetadata) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.packageDependencies.containsKey(packageUri)) {
                Map<String, Dependency.RemoteDependency> declaredDependencies = dependencyMetadata.getDependencies();
                HashMap<String, Dependency> resolvedDeps = new HashMap<String, Dependency>(declaredDependencies.size());
                for (Map.Entry<String, Dependency.RemoteDependency> entry : declaredDependencies.entrySet()) {
                    Dependency.RemoteDependency packageDependency = entry.getValue();
                    CanonicalPackageUri canonicalPackage = CanonicalPackageUri.fromPackageUri(packageDependency.getPackageUri());
                    Dependency resolvedDep = this.projectDeps.get(canonicalPackage);
                    if (resolvedDep == null) {
                        throw new PackageLoadError("unresolvedProjectDependency", packageDependency);
                    }
                    if (resolvedDep.getVersion().compareTo(packageDependency.getVersion()) < 0) {
                        throw new PackageLoadError("projectDependenciesOutOfDateInPackage", packageUri.getDisplayName(), packageDependency.getPackageUri().getDisplayName(), resolvedDep.getPackageUri().getDisplayName());
                    }
                    resolvedDeps.put(entry.getKey(), resolvedDep);
                }
                this.packageDependencies.put(packageUri, resolvedDeps);
            }
            return (Map)this.packageDependencies.get(packageUri);
        }
    }

    public Dependency getResolvedDependency(PackageUri packageUri) {
        Dependency dep = this.getProjectDeps().get(CanonicalPackageUri.fromPackageUri(packageUri));
        if (dep == null) {
            throw new PackageLoadError("unresolvedProjectDependency", packageUri);
        }
        return dep;
    }

    public Path getProjectDir() {
        return this.projectDir;
    }

    public Path getProjectDepsFile() {
        return this.projectDir.resolve(PKL_PROJECT_DEPS_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectDeps getProjectDeps() {
        Object object = this.lock;
        synchronized (object) {
            if (this.projectDeps == null) {
                Path depsPath = this.getProjectDepsFile();
                if (!Files.exists(depsPath, new LinkOption[0])) {
                    throw new VmExceptionBuilder().evalError("missingProjectDepsJson", this.projectDir).build();
                }
                try {
                    this.projectDeps = ProjectDeps.parse(depsPath);
                }
                catch (IOException | URISyntaxException | Json.JsonParseException e2) {
                    throw new VmExceptionBuilder().evalError("invalidProjectDepsJson", depsPath, e2.getMessage()).withCause(e2).build();
                }
            }
            return this.projectDeps;
        }
    }
}

