/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.parser;

import org.pkl.core.parser.Lexer;
import org.pkl.thirdparty.antlr.v4.runtime.DefaultErrorStrategy;
import org.pkl.thirdparty.antlr.v4.runtime.InputMismatchException;
import org.pkl.thirdparty.antlr.v4.runtime.NoViableAltException;
import org.pkl.thirdparty.antlr.v4.runtime.Parser;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.antlr.v4.runtime.TokenStream;
import org.pkl.thirdparty.antlr.v4.runtime.misc.IntervalSet;

class ErrorStrategy
extends DefaultErrorStrategy {
    ErrorStrategy() {
    }

    @Override
    protected void reportNoViableAlternative(Parser parser, NoViableAltException e2) {
        StringBuilder builder = new StringBuilder();
        Token offendingToken = e2.getOffendingToken();
        if (Lexer.isKeyword(offendingToken)) {
            this.appendKeywordNotAllowedMessage(builder, e2.getOffendingToken(), e2.getExpectedTokens());
        } else {
            builder.append("No viable alternative at input ");
            TokenStream tokens = parser.getInputStream();
            if (e2.getStartToken().getType() == -1) {
                builder.append("<EOF>");
            } else {
                builder.append(this.escapeWSAndQuote(tokens.getText(e2.getStartToken(), offendingToken)));
            }
        }
        parser.notifyErrorListeners(offendingToken, builder.toString(), e2);
    }

    @Override
    protected void reportInputMismatch(Parser parser, InputMismatchException e2) {
        StringBuilder builder = new StringBuilder();
        Token offendingToken = e2.getOffendingToken();
        if (Lexer.isKeyword(offendingToken)) {
            this.appendKeywordNotAllowedMessage(builder, e2.getOffendingToken(), e2.getExpectedTokens());
        } else {
            builder.append("Mismatched input: ").append(this.getTokenErrorDisplay(offendingToken)).append(". ");
            this.appendExpectedTokensMessage(builder, parser);
        }
        parser.notifyErrorListeners(offendingToken, builder.toString(), e2);
    }

    @Override
    protected void reportUnwantedToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        StringBuilder builder = new StringBuilder();
        Token currentToken = parser.getCurrentToken();
        if (Lexer.isKeyword(currentToken)) {
            this.appendKeywordNotAllowedMessage(builder, currentToken, parser.getExpectedTokens());
        } else {
            builder.append("Extraneous input: ").append(this.getTokenErrorDisplay(currentToken)).append(". ");
            this.appendExpectedTokensMessage(builder, parser);
        }
        parser.notifyErrorListeners(currentToken, builder.toString(), null);
    }

    @Override
    protected void reportMissingToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        StringBuilder builder = new StringBuilder();
        Token currentToken = parser.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(parser);
        builder.append("Missing ").append(expecting.toString(parser.getVocabulary())).append(" at ").append(this.getTokenErrorDisplay(currentToken)).append(". ");
        parser.notifyErrorListeners(currentToken, builder.toString(), null);
    }

    private void appendExpectedTokensMessage(StringBuilder builder, Parser parser) {
        IntervalSet expectedTokens = parser.getExpectedTokens();
        int size = expectedTokens.size();
        if (size == 0) {
            return;
        }
        builder.append(size == 1 ? "Expected: " : "Expected one of: ");
        String msg = expectedTokens.toString(parser.getVocabulary());
        if (msg.startsWith("{")) {
            msg = msg.substring(1);
        }
        if (msg.endsWith("}")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        builder.append(msg);
    }

    private void appendKeywordNotAllowedMessage(StringBuilder builder, Token offendingToken, IntervalSet expectedTokens) {
        builder.append("Keyword `").append(offendingToken.getText()).append("` is not allowed here.");
        if (expectedTokens.contains(88)) {
            builder.append(" (If you must use this name as identifier, enclose it in backticks.)");
        }
    }
}

