/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.pkl.core.parser.ErrorStrategy;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.Lexer;
import org.pkl.core.parser.antlr.PklLexer;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.ANTLRInputStream;
import org.pkl.thirdparty.antlr.v4.runtime.BaseErrorListener;
import org.pkl.thirdparty.antlr.v4.runtime.CharStream;
import org.pkl.thirdparty.antlr.v4.runtime.CommonTokenStream;
import org.pkl.thirdparty.antlr.v4.runtime.ParserRuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.RecognitionException;
import org.pkl.thirdparty.antlr.v4.runtime.Recognizer;
import org.pkl.thirdparty.antlr.v4.runtime.RuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.antlr.v4.runtime.TokenStream;
import org.pkl.thirdparty.antlr.v4.runtime.atn.ParserATNSimulator;
import org.pkl.thirdparty.antlr.v4.runtime.atn.PredictionMode;
import org.pkl.thirdparty.antlr.v4.runtime.tree.ParseTree;

public class Parser {
    @CompilerDirectives.TruffleBoundary
    public PklParser createParser(TokenStream stream, @Nullable List<LexParseException> errorCollector) {
        PklParser parser = new PklParser(stream);
        parser.setErrorHandler(new ErrorStrategy());
        this.registerErrorListener(parser, errorCollector);
        return parser;
    }

    @CompilerDirectives.TruffleBoundary
    public PklParser.ModuleContext parseModule(CharStream source) throws LexParseException {
        return this.parseProduction(source, PklParser::module);
    }

    @CompilerDirectives.TruffleBoundary
    public PklParser.ModuleContext parseModule(String source) throws LexParseException {
        return this.parseModule(this.toCharStream(source));
    }

    @CompilerDirectives.TruffleBoundary
    public PklParser.ReplInputContext parseReplInput(CharStream source) throws LexParseException {
        PklParser.ReplInputContext ctx = this.parseProduction(source, PklParser::replInput);
        this.checkIsCompleteInput(ctx);
        return ctx;
    }

    @CompilerDirectives.TruffleBoundary
    public PklParser.ReplInputContext parseReplInput(String source) throws LexParseException {
        return this.parseReplInput(this.toCharStream(source));
    }

    @CompilerDirectives.TruffleBoundary
    public PklParser.ExprInputContext parseExpressionInput(CharStream source) throws LexParseException {
        PklParser.ExprInputContext ctx = this.parseProduction(source, PklParser::exprInput);
        this.checkIsCompleteInput(ctx);
        return ctx;
    }

    @CompilerDirectives.TruffleBoundary
    public <T extends ParserRuleContext> T parseProduction(CharStream source, Function<PklParser, T> production) throws LexParseException {
        Optional<LexParseException> mostRelevant;
        PklLexer lexer = Lexer.createLexer(source);
        ArrayList<LexParseException> errorCollector = new ArrayList<LexParseException>();
        PklParser parser = this.createParser(new CommonTokenStream(lexer), errorCollector);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        ParserRuleContext result = (ParserRuleContext)production.apply(parser);
        if (!errorCollector.isEmpty()) {
            errorCollector.clear();
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            result = (ParserRuleContext)production.apply(parser);
        }
        if ((mostRelevant = errorCollector.stream().max(Comparator.comparingInt(LexParseException::getRelevance))).isPresent()) {
            throw mostRelevant.get().withPartialParseResult(result);
        }
        return (T)result;
    }

    @CompilerDirectives.TruffleBoundary
    public PklParser.ExprInputContext parseExpressionInput(String source) throws LexParseException {
        return this.parseExpressionInput(this.toCharStream(source));
    }

    private CharStream toCharStream(String source) {
        return new ANTLRInputStream(source);
    }

    private void checkIsCompleteInput(ParserRuleContext ctx) {
        if (ctx.getChildCount() == 1) {
            return;
        }
        ParseTree curr = ctx.getChild(ctx.getChildCount() - 2);
        while (curr.getChildCount() > 0) {
            if (curr instanceof PklParser.ClassBodyContext) {
                if (((PklParser.ClassBodyContext)curr).err == null) {
                    throw this.incompleteInput(curr, "}");
                }
                return;
            }
            if (curr instanceof PklParser.ParameterListContext) {
                if (((PklParser.ParameterListContext)curr).err == null) {
                    throw this.incompleteInput(curr, ")");
                }
                return;
            }
            if (curr instanceof PklParser.ArgumentListContext) {
                if (((PklParser.ArgumentListContext)curr).err == null) {
                    throw this.incompleteInput(curr, ")");
                }
                return;
            }
            if (curr instanceof PklParser.TypeParameterListContext) {
                if (((PklParser.TypeParameterListContext)curr).err == null) {
                    throw this.incompleteInput(curr, ">");
                }
                return;
            }
            if (curr instanceof PklParser.TypeArgumentListContext) {
                if (((PklParser.TypeArgumentListContext)curr).err == null) {
                    throw this.incompleteInput(curr, ">");
                }
                return;
            }
            if (curr instanceof PklParser.ParenthesizedTypeContext) {
                if (((PklParser.ParenthesizedTypeContext)curr).err == null) {
                    throw this.incompleteInput(curr, ")");
                }
                return;
            }
            if (curr instanceof PklParser.ConstrainedTypeContext) {
                if (((PklParser.ConstrainedTypeContext)curr).err == null) {
                    throw this.incompleteInput(curr, ")");
                }
                return;
            }
            if (curr instanceof PklParser.ParenthesizedExprContext) {
                if (((PklParser.ParenthesizedExprContext)curr).err == null) {
                    throw this.incompleteInput(curr, ")");
                }
                return;
            }
            if (curr instanceof PklParser.SuperSubscriptExprContext) {
                if (((PklParser.SuperSubscriptExprContext)curr).err == null) {
                    throw this.incompleteInput(curr, "]");
                }
                return;
            }
            if (curr instanceof PklParser.SubscriptExprContext) {
                if (((PklParser.SubscriptExprContext)curr).err == null) {
                    throw this.incompleteInput(curr, "]");
                }
                return;
            }
            if (curr instanceof PklParser.ObjectBodyContext) {
                if (((PklParser.ObjectBodyContext)curr).err == null) {
                    throw this.incompleteInput(curr, "}");
                }
                return;
            }
            curr = curr.getChild(curr.getChildCount() - 1);
        }
    }

    private void registerErrorListener(PklParser parser, final @Nullable List<LexParseException> errorCollector) {
        parser.removeErrorListeners();
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public <T extends Token> void syntaxError(Recognizer<T, ?> recognizer, T offendingToken, int line, int charPositionInLine, String msg, @Nullable RecognitionException e2) {
                assert (charPositionInLine == offendingToken.getCharPositionInLine());
                int length2 = offendingToken.getStopIndex() - offendingToken.getStartIndex() + 1;
                LexParseException.ParseError exception = offendingToken.getType() == -1 ? new LexParseException.IncompleteInput(msg, line, charPositionInLine + 1, length2) : new LexParseException.ParseError(msg, line, charPositionInLine + 1, length2, Parser.getAstDepth(e2));
                if (errorCollector == null) {
                    throw exception;
                }
                errorCollector.add(exception);
            }
        });
    }

    private LexParseException incompleteInput(ParseTree tree, String missingDelimiter) {
        ParserRuleContext ctx = (ParserRuleContext)tree;
        return new LexParseException.IncompleteInput("Missing closing delimiter `" + missingDelimiter + "`.", ctx.stop.getLine(), ctx.stop.getCharPositionInLine() + 1, ctx.stop.getStopIndex() - ctx.stop.getStartIndex() + 1);
    }

    private static int getAstDepth(@Nullable RecognitionException e2) {
        if (e2 == null) {
            return 0;
        }
        int depth = 0;
        for (RuleContext context = e2.getContext(); context != null; context = context.getParent()) {
            ++depth;
        }
        return depth;
    }
}

