/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.Composite;
import org.pkl.core.Duration;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PClassInfo;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.Version;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.packages.PackageUtils;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Package;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.util.Nullable;

public final class Project {
    private final @Nullable Package pkg;
    private final DeclaredDependencies dependencies;
    private final EvaluatorSettings evaluatorSettings;
    private final URI projectFileUri;
    private final Path projectDir;
    private final List<Path> tests;
    private final Map<String, Project> localProjectDependencies;

    public static Project loadFromPath(Path path, SecurityManager securityManager, @Nullable java.time.Duration timeout, StackFrameTransformer stackFrameTransformer, Map<String, String> envVars) {
        Evaluator evaluator = EvaluatorBuilder.unconfigured().setSecurityManager(securityManager).setStackFrameTransformer(stackFrameTransformer).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.file()).addEnvironmentVariables(envVars).setTimeout(timeout).build();
        try {
            PObject output = evaluator.evaluateOutputValueAs(ModuleSource.path(path), PClassInfo.Project);
            Project project = Project.parseProject(output);
            if (evaluator != null) {
                evaluator.close();
            }
            return project;
        }
        catch (Throwable throwable) {
            try {
                if (evaluator != null) {
                    try {
                        evaluator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (URISyntaxException e2) {
                throw new PklException(e2.getMessage(), e2);
            }
        }
    }

    public static Project loadFromPath(Path path, SecurityManager securityManager, @Nullable java.time.Duration timeout) {
        return Project.loadFromPath(path, securityManager, timeout, StackFrameTransformers.defaultTransformer, System.getenv());
    }

    public static Project loadFromPath(Path path) {
        return Project.loadFromPath(path, SecurityManagers.defaultManager, null);
    }

    private static DeclaredDependencies parseDependencies(PObject module, URI projectFileUri, @Nullable PackageUri packageUri) throws URISyntaxException {
        HashMap<String, Dependency.RemoteDependency> remoteDependencies = new HashMap<String, Dependency.RemoteDependency>();
        HashMap<String, DeclaredDependencies> localDependencies = new HashMap<String, DeclaredDependencies>();
        Map dependencies = (Map)module.getProperty("dependencies");
        for (Map.Entry entry : dependencies.entrySet()) {
            PObject value2 = (PObject)entry.getValue();
            if (value2.getClassInfo().equals(PClassInfo.Project)) {
                URI localProjectFileUri = URI.create((String)value2.getProperty("projectFileUri"));
                PackageUri localPkgUri = PackageUri.create((String)((PObject)value2.getProperty("package")).getProperty("uri"));
                localDependencies.put((String)entry.getKey(), Project.parseDependencies(value2, localProjectFileUri, localPkgUri));
                continue;
            }
            remoteDependencies.put((String)entry.getKey(), Project.parseRemoteDependency(value2));
        }
        return new DeclaredDependencies(remoteDependencies, localDependencies, projectFileUri, packageUri);
    }

    private static Dependency.RemoteDependency parseRemoteDependency(PObject object) throws URISyntaxException {
        PackageUri packageUri = new PackageUri((String)object.getProperty("uri"));
        PackageUtils.checkHasNoChecksumComponent(packageUri);
        Object objChecksum = object.getProperty("checksums");
        Checksums checksums = null;
        if (objChecksum instanceof PObject) {
            String sha2562 = (String)((PObject)objChecksum).get("sha256");
            assert (sha2562 != null);
            checksums = new Checksums(sha2562);
        }
        return new Dependency.RemoteDependency(packageUri, checksums);
    }

    public static Project parseProject(PObject module) throws URISyntaxException {
        Object pkgObj = Project.getNullableProperty(module, "package");
        URI projectFileUri = URI.create((String)module.getProperty("projectFileUri"));
        DeclaredDependencies dependencies = Project.parseDependencies(module, projectFileUri, null);
        Path projectDir = Path.of(projectFileUri).getParent();
        Package pkg = null;
        if (pkgObj != null) {
            pkg = Project.parsePackage((PObject)pkgObj);
        }
        EvaluatorSettings evaluatorSettings = Project.getProperty(module, "evaluatorSettings", settings -> Project.parseEvaluatorSettings(settings, projectDir));
        List testPathStrs = (List)Project.getProperty(module, "tests");
        List<Path> tests = testPathStrs.stream().map(it -> projectDir.resolve((String)it).normalize()).collect(Collectors.toList());
        Map<String, Project> localProjectDependencies = Project.parseLocalProjectDependencies(module);
        return new Project(pkg, dependencies, evaluatorSettings, projectFileUri, projectDir, tests, localProjectDependencies);
    }

    private static Map<String, Project> parseLocalProjectDependencies(PObject module) throws URISyntaxException {
        Map dependencies = (Map)module.getProperty("dependencies");
        HashMap<String, Project> result = new HashMap<String, Project>();
        for (Map.Entry entry : dependencies.entrySet()) {
            PObject value2 = (PObject)entry.getValue();
            if (!value2.getClassInfo().equals(PClassInfo.Project)) continue;
            result.put((String)entry.getKey(), Project.parseProject((PObject)entry.getValue()));
        }
        return result;
    }

    private static EvaluatorSettings parseEvaluatorSettings(Object settings, Path projectDir) {
        PObject pSettings = (PObject)settings;
        Map externalProperties = Project.getNullableProperty(pSettings, "externalProperties", Project::asMap);
        Map env = Project.getNullableProperty(pSettings, "env", Project::asMap);
        List allowedModules = Project.getNullableProperty(pSettings, "allowedModules", Project::asPatternList);
        List allowedResources = Project.getNullableProperty(pSettings, "allowedResources", Project::asPatternList);
        Boolean noCache = (Boolean)Project.getNullableProperty(pSettings, "noCache");
        List modulePathStrs = (List)Project.getNullableProperty(pSettings, "modulePath");
        List<Path> modulePath = null;
        if (modulePathStrs != null) {
            modulePath = modulePathStrs.stream().map(it -> projectDir.resolve((String)it).normalize()).collect(Collectors.toList());
        }
        Duration timeout = (Duration)Project.getNullableProperty(pSettings, "timeout");
        Path moduleCacheDir = Project.getNullablePath(pSettings, "moduleCacheDir", projectDir);
        Path rootDir = Project.getNullablePath(pSettings, "rootDir", projectDir);
        return new EvaluatorSettings(externalProperties, env, allowedModules, allowedResources, noCache, moduleCacheDir, modulePath, timeout, rootDir);
    }

    private static Map<String, String> asMap(Object t) {
        assert (t instanceof Map);
        return (Map)t;
    }

    private static List<Pattern> asPatternList(Object t) {
        return ((List)t).stream().map(Pattern::compile).collect(Collectors.toList());
    }

    private static Object getProperty(PObject settings, String propertyName) {
        return settings.getProperty(propertyName);
    }

    private static <T> T getProperty(PObject settings, String propertyName, Function<Object, T> f) {
        return Objects.requireNonNull(Project.getNullableProperty(settings, propertyName, f));
    }

    private static @Nullable Object getNullableProperty(Composite object, String propertyName) {
        Object result = object.getPropertyOrNull(propertyName);
        if (result instanceof PNull || result == null) {
            return null;
        }
        return result;
    }

    private static <T> @Nullable T getNullableProperty(Composite object, String propertyName, Function<Object, T> f) {
        Object value2 = object.getPropertyOrNull(propertyName);
        if (value2 instanceof PNull || value2 == null) {
            return null;
        }
        return f.apply(value2);
    }

    private static @Nullable URI getNullableURI(Composite object, String propertyName) throws URISyntaxException {
        Object value2 = object.getPropertyOrNull(propertyName);
        if (value2 instanceof PNull || value2 == null) {
            return null;
        }
        return new URI((String)value2);
    }

    private static @Nullable Path getNullablePath(Composite object, String propertyName, Path projectDir) {
        return Project.getNullableProperty(object, propertyName, obj -> projectDir.resolve((String)obj).normalize());
    }

    private static Package parsePackage(PObject pObj) throws URISyntaxException {
        String name = (String)pObj.getProperty("name");
        PackageUri uri = new PackageUri((String)pObj.getProperty("uri"));
        Version version = Version.parse((String)Project.getProperty(pObj, "version"));
        URI packageZipUrl = new URI((String)Project.getProperty(pObj, "packageZipUrl"));
        String description = (String)Project.getNullableProperty(pObj, "description");
        List authors = (List)Project.getProperty(pObj, "authors");
        URI website = Project.getNullableURI(pObj, "website");
        URI documentation = Project.getNullableURI(pObj, "documentation");
        URI sourceCode = Project.getNullableURI(pObj, "sourceCode");
        String sourceCodeUrlScheme = (String)Project.getNullableProperty(pObj, "sourceCodeUrlScheme");
        String license = (String)Project.getNullableProperty(pObj, "license");
        String licenseText = (String)Project.getNullableProperty(pObj, "licenseText");
        URI issueTracker = Project.getNullableURI(pObj, "issueTracker");
        List apiTestStrs = (List)Project.getProperty(pObj, "apiTests");
        List<Path> apiTests = apiTestStrs.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList());
        List exclude = (List)Project.getProperty(pObj, "exclude");
        return new Package(name, uri, version, packageZipUrl, description, authors, website, documentation, sourceCode, sourceCodeUrlScheme, license, licenseText, issueTracker, apiTests, exclude);
    }

    private Project(@Nullable Package pkg, DeclaredDependencies dependencies, EvaluatorSettings evaluatorSettings, URI projectFileUri, Path projectDir, List<Path> tests, Map<String, Project> localProjectDependencies) {
        this.pkg = pkg;
        this.dependencies = dependencies;
        this.evaluatorSettings = evaluatorSettings;
        this.projectFileUri = projectFileUri;
        this.projectDir = projectDir;
        this.tests = tests;
        this.localProjectDependencies = localProjectDependencies;
    }

    public @Nullable Package getPackage() {
        return this.pkg;
    }

    public EvaluatorSettings getSettings() {
        return this.evaluatorSettings;
    }

    public URI getProjectFileUri() {
        return this.projectFileUri;
    }

    public List<Path> getTests() {
        return this.tests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.pkg, project.pkg) && this.dependencies.equals(project.dependencies) && this.evaluatorSettings.equals(project.evaluatorSettings) && this.projectFileUri.equals(project.projectFileUri) && this.tests.equals(project.tests);
    }

    public int hashCode() {
        return Objects.hash(this.pkg, this.dependencies, this.evaluatorSettings, this.projectFileUri, this.tests);
    }

    public DeclaredDependencies getDependencies() {
        return this.dependencies;
    }

    public Map<String, Project> getLocalProjectDependencies() {
        return this.localProjectDependencies;
    }

    public Path getProjectDir() {
        return this.projectDir;
    }

    public static class EvaluatorSettings {
        private final @Nullable Map<String, String> externalProperties;
        private final @Nullable Map<String, String> env;
        private final @Nullable List<Pattern> allowedModules;
        private final @Nullable List<Pattern> allowedResources;
        private final @Nullable Boolean noCache;
        private final @Nullable Path moduleCacheDir;
        private final @Nullable List<Path> modulePath;
        private final @Nullable Duration timeout;
        private final @Nullable Path rootDir;

        public EvaluatorSettings(@Nullable Map<String, String> externalProperties, @Nullable Map<String, String> env, @Nullable List<Pattern> allowedModules, @Nullable List<Pattern> allowedResources, @Nullable Boolean noCache, @Nullable Path moduleCacheDir, @Nullable List<Path> modulePath, @Nullable Duration timeout, @Nullable Path rootDir) {
            this.externalProperties = externalProperties;
            this.env = env;
            this.allowedModules = allowedModules;
            this.allowedResources = allowedResources;
            this.noCache = noCache;
            this.moduleCacheDir = moduleCacheDir;
            this.modulePath = modulePath;
            this.timeout = timeout;
            this.rootDir = rootDir;
        }

        public @Nullable Map<String, String> getExternalProperties() {
            return this.externalProperties;
        }

        public @Nullable Map<String, String> getEnv() {
            return this.env;
        }

        public @Nullable List<Pattern> getAllowedModules() {
            return this.allowedModules;
        }

        public @Nullable List<Pattern> getAllowedResources() {
            return this.allowedResources;
        }

        public @Nullable Boolean isNoCache() {
            return this.noCache;
        }

        public @Nullable List<Path> getModulePath() {
            return this.modulePath;
        }

        public @Nullable Duration getTimeout() {
            return this.timeout;
        }

        public @Nullable Path getModuleCacheDir() {
            return this.moduleCacheDir;
        }

        public @Nullable Path getRootDir() {
            return this.rootDir;
        }

        private boolean arePatternsEqual(@Nullable List<Pattern> myPattern, @Nullable List<Pattern> thatPattern) {
            if (myPattern == null) {
                return thatPattern == null;
            }
            if (thatPattern == null) {
                return false;
            }
            if (myPattern.size() != thatPattern.size()) {
                return false;
            }
            for (int i = 0; i < myPattern.size(); ++i) {
                if (myPattern.get(i).pattern().equals(thatPattern.get(i).pattern())) continue;
                return false;
            }
            return true;
        }

        private int hashPatterns(@Nullable List<Pattern> patterns) {
            if (patterns == null) {
                return 0;
            }
            int ret = 1;
            for (Pattern pattern2 : patterns) {
                ret = 31 * ret + pattern2.pattern().hashCode();
            }
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvaluatorSettings that = (EvaluatorSettings)o;
            return Objects.equals(this.externalProperties, that.externalProperties) && Objects.equals(this.env, that.env) && this.arePatternsEqual(this.allowedModules, that.allowedModules) && this.arePatternsEqual(this.allowedResources, that.allowedResources) && Objects.equals(this.noCache, that.noCache) && Objects.equals(this.moduleCacheDir, that.moduleCacheDir) && Objects.equals(this.modulePath, that.modulePath) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.rootDir, that.rootDir);
        }

        public int hashCode() {
            int result = Objects.hash(this.externalProperties, this.env, this.noCache, this.moduleCacheDir, this.modulePath, this.timeout, this.rootDir);
            result = 31 * result + this.hashPatterns(this.allowedModules);
            result = 31 * result + this.hashPatterns(this.allowedResources);
            return result;
        }

        public String toString() {
            return "EvaluatorSettings{externalProperties=" + this.externalProperties + ", env=" + this.env + ", allowedModules=" + this.allowedModules + ", allowedResources=" + this.allowedResources + ", noCache=" + this.noCache + ", moduleCacheDir=" + this.moduleCacheDir + ", modulePath=" + this.modulePath + ", timeout=" + this.timeout + ", rootDir=" + this.rootDir + "}";
        }
    }
}

