/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.repl;

import java.net.URI;

public abstract class ReplRequest {
    public final String id;

    private ReplRequest(String id) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("Request ID must be empty.");
        }
        this.id = id;
    }

    public static final class Reset
    extends ReplRequest {
        public Reset(String id) {
            super(id);
        }

        public String toString() {
            return String.format("%s()", this.getClass().getSimpleName());
        }
    }

    public static final class Completion
    extends ReplRequest {
        public final String text;

        public Completion(String id, String text) {
            super(id);
            this.text = text;
        }

        public String toString() {
            return String.format("%s(text=%s)", this.getClass().getSimpleName(), this.text);
        }
    }

    public static final class Load
    extends ReplRequest {
        public final URI uri;

        public Load(String id, URI uri) {
            super(id);
            this.uri = uri;
        }

        public String toString() {
            return String.format("%s(url=%s)", this.getClass().getSimpleName(), this.uri);
        }
    }

    public static final class Eval
    extends ReplRequest {
        public final String text;
        public final boolean evalDefinitions;
        public final boolean forceResults;

        public Eval(String id, String text, boolean evalDefinitions, boolean forceResults) {
            super(id);
            this.text = text;
            this.evalDefinitions = evalDefinitions;
            this.forceResults = forceResults;
        }

        public String toString() {
            return String.format("%s(text=%s,evalDefinitions=%s,forceResults=%s)", this.getClass().getSimpleName(), this.text, this.evalDefinitions, this.forceResults);
        }
    }
}

