/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.repl;

import java.util.Collection;
import java.util.List;

public abstract class ReplResponse {
    private final String message;

    private ReplResponse(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static final class InternalError
    extends ReplResponse {
        private final Throwable cause;

        public InternalError(Throwable cause) {
            super(cause.toString());
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return String.format("%s(cause=%s)", this.getClass().getSimpleName(), this.cause);
        }
    }

    public static final class InvalidRequest
    extends ReplResponse {
        public InvalidRequest(String message) {
            super(message);
        }

        public String toString() {
            return String.format("%s(message=%s)", this.getClass().getSimpleName(), this.getMessage());
        }
    }

    public static final class IncompleteInput
    extends ReplResponse {
        public IncompleteInput(String message) {
            super(message);
        }

        public String toString() {
            return String.format("%s(message=%s)", this.getClass().getSimpleName(), this.getMessage());
        }
    }

    public static final class EvalError
    extends ReplResponse {
        public EvalError(String message) {
            super(message);
        }

        public String toString() {
            return String.format("%s(message=%s)", this.getClass().getSimpleName(), this.getMessage());
        }
    }

    public static final class EvalSuccess
    extends ReplResponse {
        public EvalSuccess(String message) {
            super(message);
        }

        public String getResult() {
            return this.getMessage();
        }

        public String toString() {
            return String.format("%s(result=%s)", this.getClass().getSimpleName(), this.getResult());
        }
    }

    public static final class Completion
    extends ReplResponse {
        public static final Completion EMPTY = new Completion(List.of());
        public final Collection<String> members;

        public Completion(Collection<String> members) {
            super("");
            this.members = members;
        }

        public String toString() {
            return String.format("%s(members=%s)", this.getClass().getSimpleName(), this.members);
        }
    }
}

