/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.repl;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pkl.core.Logger;
import org.pkl.core.PClassInfo;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.SimpleRootNode;
import org.pkl.core.ast.builder.AstBuilder;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UnresolvedMethodNode;
import org.pkl.core.ast.member.UnresolvedPropertyNode;
import org.pkl.core.ast.repl.ResolveClassMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.Parser;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.repl.ReplRequest;
import org.pkl.core.repl.ReplResponse;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.ResourceManager;
import org.pkl.core.runtime.StackTraceRenderer;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmExceptionRenderer;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.MutableReference;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.tree.ParseTree;
import org.pkl.thirdparty.antlr.v4.runtime.tree.TerminalNode;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.graalvm.polyglot.Context;

public class ReplServer
implements AutoCloseable {
    private final IndirectCallNode callNode = Truffle.getRuntime().createIndirectCallNode();
    private final Context polyglotContext;
    private final VmLanguage language;
    private final ReplState replState;
    private final Path workingDir;
    private final SecurityManager securityManager;
    private final ModuleResolver moduleResolver;
    private final VmExceptionRenderer errorRenderer;
    private final PackageResolver packageResolver;
    private final @Nullable ProjectDependenciesManager projectDependenciesManager;

    public ReplServer(SecurityManager securityManager, Logger logger, Collection<ModuleKeyFactory> moduleKeyFactories, Collection<ResourceReader> resourceReaders, Map<String, String> environmentVariables, Map<String, String> externalProperties, @Nullable Path moduleCacheDir, @Nullable DeclaredDependencies projectDependencies, @Nullable String outputFormat, Path workingDir, StackFrameTransformer frameTransformer) {
        this.workingDir = workingDir;
        this.securityManager = securityManager;
        this.moduleResolver = new ModuleResolver(moduleKeyFactories);
        this.errorRenderer = new VmExceptionRenderer(new StackTraceRenderer(frameTransformer));
        this.replState = new ReplState(this.createEmptyReplModule(BaseModule.getModuleClass().getPrototype()));
        MutableReference<Object> languageRef = new MutableReference<Object>(null);
        this.packageResolver = PackageResolver.getInstance(securityManager, moduleCacheDir);
        this.projectDependenciesManager = projectDependencies == null ? null : new ProjectDependenciesManager(projectDependencies);
        this.polyglotContext = VmUtils.createContext(() -> {
            languageRef.set(VmLanguage.get(null));
            VmContext vmContext = VmContext.get(null);
            vmContext.initialize(new VmContext.Holder(frameTransformer, securityManager, this.moduleResolver, new ResourceManager(securityManager, resourceReaders), logger, environmentVariables, externalProperties, moduleCacheDir, outputFormat, this.packageResolver, this.projectDependenciesManager));
        });
        this.language = languageRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplResponse> handleRequest(ReplRequest request) {
        this.polyglotContext.enter();
        try {
            if (request instanceof ReplRequest.Eval) {
                List<ReplResponse> list = this.handleEval((ReplRequest.Eval)request);
                return list;
            }
            if (request instanceof ReplRequest.Load) {
                List<ReplResponse> list = this.handleLoad((ReplRequest.Load)request);
                return list;
            }
            if (request instanceof ReplRequest.Completion) {
                List<ReplResponse> list = this.handleCompletion((ReplRequest.Completion)request);
                return list;
            }
            if (request instanceof ReplRequest.Reset) {
                List<ReplResponse> list = this.handleReset();
                return list;
            }
            List<ReplResponse> list = List.of(new ReplResponse.InvalidRequest("Unsupported request type: " + request.getClass().getSimpleName()));
            return list;
        }
        catch (Exception e2) {
            List<ReplResponse> list = List.of(new ReplResponse.InternalError(e2));
            return list;
        }
        finally {
            this.polyglotContext.leave();
        }
    }

    @Override
    public void close() {
        this.polyglotContext.close(true);
        try {
            this.packageResolver.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<ReplResponse> handleEval(ReplRequest.Eval request) {
        List<Object> results = this.evaluate(this.replState, request.id, request.text, request.evalDefinitions, request.forceResults);
        return results.stream().map(result -> result instanceof ReplResponse ? (ReplResponse)result : new ReplResponse.EvalSuccess(this.render(result))).collect(Collectors.toList());
    }

    private List<Object> evaluate(ReplState replState, String requestId, String text, boolean evalDefinitions, boolean forceResults) {
        ResolvedModuleKey resolved;
        PklParser.ReplInputContext replInputContext;
        Parser parser = new Parser();
        URI uri = URI.create("repl:" + requestId);
        try {
            replInputContext = parser.parseReplInput(text);
        }
        catch (LexParseException.IncompleteInput e2) {
            return List.of(new ReplResponse.IncompleteInput(e2.getMessage()));
        }
        catch (LexParseException e3) {
            VmException exception = VmUtils.toVmException(e3, text, uri, uri.toString());
            String errorMessage = this.errorRenderer.render(exception);
            return List.of(new ReplResponse.EvalError(errorMessage));
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ModuleKey module = ModuleKeys.synthetic(uri, this.workingDir.toUri(), uri, text, false);
        try {
            resolved = module.resolve(this.securityManager);
        }
        catch (SecurityManagerException e4) {
            throw new VmExceptionBuilder().withCause(e4).build();
        }
        catch (IOException e5) {
            throw new AssertionError((Object)e5);
        }
        AstBuilder builder = new AstBuilder(VmUtils.loadSource(resolved), this.language, replState.module.getModuleInfo(), this.moduleResolver);
        List childrenExceptEof = replInputContext.children.subList(0, replInputContext.children.size() - 1);
        for (ParseTree tree : childrenExceptEof) {
            try {
                if (tree instanceof PklParser.ExprContext) {
                    ExpressionNode exprNode = (ExpressionNode)tree.accept(builder);
                    this.evaluateExpr(replState, exprNode, forceResults, results);
                    continue;
                }
                if (tree instanceof PklParser.ImportClauseContext) {
                    this.addStaticModuleProperty(builder.visitImportClause((PklParser.ImportClauseContext)tree));
                    continue;
                }
                if (tree instanceof PklParser.ClassPropertyContext) {
                    UnresolvedPropertyNode propertyNode = builder.visitClassProperty((PklParser.ClassPropertyContext)tree);
                    ObjectMember property = this.addModuleProperty(propertyNode);
                    if (!evalDefinitions) continue;
                    this.evaluateMemberDef(replState, property, forceResults, results);
                    continue;
                }
                if (tree instanceof PklParser.ClazzContext) {
                    this.addStaticModuleProperty(builder.visitClazz((PklParser.ClazzContext)tree));
                    continue;
                }
                if (tree instanceof PklParser.TypeAliasContext) {
                    this.addStaticModuleProperty(builder.visitTypeAlias((PklParser.TypeAliasContext)tree));
                    continue;
                }
                if (tree instanceof PklParser.ClassMethodContext) {
                    this.addModuleMethodDef(builder.visitClassMethod((PklParser.ClassMethodContext)tree));
                    continue;
                }
                if (tree instanceof PklParser.ModuleDeclContext || tree instanceof TerminalNode && tree.toString().equals(",")) continue;
                results.add(new ReplResponse.InternalError(new IllegalStateException("Unexpected parse result")));
            }
            catch (VmException e6) {
                results.add(new ReplResponse.EvalError(this.errorRenderer.render(e6)));
            }
        }
        return results;
    }

    private void addStaticModuleProperty(ObjectMember property) {
        this.replState.module.getPrototype().addProperty(property);
    }

    private ObjectMember addModuleProperty(UnresolvedPropertyNode propertyNode) {
        boolean needToCreateNewModuleToEnforceLateBinding;
        boolean bl = needToCreateNewModuleToEnforceLateBinding = !propertyNode.isLocal() && this.replState.module.hasMember(propertyNode.getName());
        if (needToCreateNewModuleToEnforceLateBinding) {
            this.replState.module = this.createEmptyReplModule(this.replState.module);
        }
        ResolveClassMemberNode resolveNode = new ResolveClassMemberNode(this.language, new FrameDescriptor(), propertyNode, this.replState.module.getVmClass());
        ClassProperty property = (ClassProperty)this.callNode.call(resolveNode.getCallTarget(), this.replState.module, this.replState.module);
        this.replState.module.getVmClass().addProperty(property);
        return property.getInitializer();
    }

    private void addModuleMethodDef(UnresolvedMethodNode methodNode) {
        boolean needToCreateNewModuleToEnforceLateBinding;
        boolean bl = needToCreateNewModuleToEnforceLateBinding = !methodNode.isLocal() && this.replState.module.getVmClass().hasDeclaredMethod(methodNode.getName());
        if (needToCreateNewModuleToEnforceLateBinding) {
            this.replState.module = this.createEmptyReplModule(this.replState.module);
        }
        ResolveClassMemberNode resolveNode = new ResolveClassMemberNode(this.language, new FrameDescriptor(), methodNode, this.replState.module.getVmClass());
        ClassMethod method = (ClassMethod)this.callNode.call(resolveNode.getCallTarget(), this.replState.module, this.replState.module);
        this.replState.module.getVmClass().addMethod(method);
    }

    private void evaluateExpr(ReplState replState, ExpressionNode exprNode, boolean forceResults, List<Object> results) {
        SimpleRootNode rootNode = new SimpleRootNode(this.language, new FrameDescriptor(), exprNode.getSourceSection(), "", exprNode);
        Object result = this.callNode.call(rootNode.getCallTarget(), replState.module, replState.module);
        if (forceResults) {
            VmValue.force(result, false);
        }
        results.add(result);
    }

    private void evaluateMemberDef(ReplState replState, ObjectMember memberDef, boolean forceResults, List<Object> results) {
        Object result;
        Object object = result = memberDef.getConstantValue() != null ? memberDef.getConstantValue() : this.callNode.call(memberDef.getCallTarget(), replState.module, replState.module);
        if (forceResults) {
            VmValue.force(result, false);
        }
        results.add(result);
    }

    private List<ReplResponse> handleLoad(ReplRequest.Load request) {
        try {
            URI uri = IoUtils.resolve(this.workingDir.toUri(), request.uri);
            ModuleKey moduleToLoad = this.moduleResolver.resolve(uri);
            VmTyped loadedModule = this.language.loadModule(moduleToLoad);
            this.replState.module = this.createReplModule(loadedModule.getVmClass().getDeclaredProperties(), loadedModule.getVmClass().getDeclaredMethods(), loadedModule.getMembers(), loadedModule.getParent());
            return List.of();
        }
        catch (VmException e2) {
            return List.of(new ReplResponse.EvalError(this.errorRenderer.render(e2)));
        }
    }

    private List<ReplResponse> handleCompletion(ReplRequest.Completion request) {
        HashSet<String> members = new HashSet<String>();
        if (IoUtils.isWhitespace(request.text)) {
            this.collectMembers(members, BaseModule.getModule());
            this.collectMembers(members, this.replState.module);
            return List.of(new ReplResponse.Completion(members));
        }
        ReplState tempModule = new ReplState(this.createReplModule(this.replState.module.getVmClass().getDeclaredProperties(), this.replState.module.getVmClass().getDeclaredMethods(), this.replState.module.getMembers(), this.replState.module.getParent()));
        List<Object> results = this.evaluate(tempModule, request.id, request.text, false, false);
        if (results.isEmpty()) {
            return List.of(ReplResponse.Completion.EMPTY);
        }
        Object lastResult = results.get(results.size() - 1);
        if (lastResult instanceof ReplResponse.EvalError || lastResult instanceof ReplResponse.IncompleteInput) {
            return List.of(ReplResponse.Completion.EMPTY);
        }
        assert (!(lastResult instanceof ReplResponse));
        VmObjectLike composite = lastResult instanceof VmObjectLike ? (VmObjectLike)lastResult : VmUtils.getClass(lastResult).getPrototype();
        this.collectMembers(members, composite);
        return List.of(new ReplResponse.Completion(members));
    }

    private void collectMembers(Set<String> members, VmObjectLike composite) {
        composite.iterateMembers((key2, prop) -> {
            if (key2 instanceof Identifier) {
                members.add(key2.toString());
            }
            return true;
        });
        composite.getVmClass().visitMethodDefsTopDown(fun -> members.add(fun.getName() + (fun.getParameterCount() == 0 ? "()" : "(")));
    }

    private List<ReplResponse> handleReset() {
        this.replState.module = this.createEmptyReplModule(BaseModule.getModuleClass().getPrototype());
        return List.of();
    }

    private VmTyped createEmptyReplModule(@Nullable VmTyped parent) {
        return this.createReplModule(List.of(), List.of(), EconomicMaps.create(), parent);
    }

    private VmTyped createReplModule(Iterable<ClassProperty> propertyDefs, Iterable<ClassMethod> methodDefs, UnmodifiableEconomicMap<Object, ObjectMember> moduleMembers, @Nullable VmTyped parent) {
        ResolvedModuleKey resolvedModuleKey;
        URI uri = URI.create("repl:repl");
        PClassInfo<?> classInfo = PClassInfo.get("repl", "module", uri);
        ModuleKey moduleKey = ModuleKeys.synthetic(uri, this.workingDir.toUri(), uri, "", false);
        try {
            resolvedModuleKey = moduleKey.resolve(this.securityManager);
        }
        catch (IOException | SecurityManagerException e2) {
            throw new RuntimeException(e2);
        }
        ModuleInfo moduleInfo = new ModuleInfo(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), null, "repl", moduleKey, resolvedModuleKey, false);
        VmTyped module = new VmTyped(VmUtils.createEmptyMaterializedFrame(), null, null, moduleMembers);
        module.setExtraStorage(moduleInfo);
        VmClass clazz = new VmClass(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), null, List.of(), 0, classInfo, List.of(), module);
        if (parent != null) {
            VmClass superclass = parent.getVmClass();
            TypeNode supertypeNode = TypeNode.forClass(VmUtils.unavailableSourceSection(), superclass);
            clazz.initSupertype(supertypeNode, superclass);
        }
        clazz.addProperties(propertyDefs);
        clazz.addMethods(methodDefs);
        return module;
    }

    private String render(Object value2) {
        return VmValueRenderer.multiLine(Integer.MAX_VALUE).render(value2);
    }

    private static class ReplState {
        VmTyped module;

        public ReplState(VmTyped module) {
            this.module = module;
        }
    }
}

