/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;

public class FileSystemManager {
    private static final EconomicMap<URI, FileSystem> fileSystems = EconomicMaps.create();
    private static final Map<FileSystem, Integer> counts = new IdentityHashMap<FileSystem, Integer>();
    private static final List<FileSystem> externalFileSystems = new ArrayList<FileSystem>();

    public static synchronized FileSystem getFileSystem(URI uri) throws IOException {
        FileSystem fs = (FileSystem)fileSystems.get(uri);
        if (fs != null) {
            counts.put(fs, counts.get(fs) + 1);
            return fs;
        }
        try {
            fs = new Handle(FileSystems.newFileSystem(uri, new HashMap()));
            fileSystems.put(uri, fs);
            counts.put(fs, 1);
            return fs;
        }
        catch (FileSystemAlreadyExistsException e2) {
            fs = new Handle(FileSystems.getFileSystem(uri));
            externalFileSystems.add(fs);
            fileSystems.put(uri, fs);
            counts.put(fs, 1);
            return fs;
        }
    }

    private static synchronized void close(Handle fs) throws IOException {
        boolean isExternal;
        int count2 = counts.get(fs) - 1;
        if (count2 > 0) {
            counts.put(fs, count2);
            return;
        }
        counts.remove(fs);
        UnmodifiableMapCursor cursor = fileSystems.getEntries();
        while (cursor.advance()) {
            FileSystem fileSystem = (FileSystem)cursor.getValue();
            if (!fileSystem.equals(fs)) continue;
            URI key2 = (URI)cursor.getKey();
            fileSystems.removeKey(key2);
            break;
        }
        if (isExternal = externalFileSystems.contains(fs)) {
            externalFileSystems.remove(fs);
        } else {
            fs.delegate.close();
        }
    }

    private static class Handle
    extends FileSystem {
        final FileSystem delegate;

        public Handle(FileSystem delegate) {
            this.delegate = delegate;
        }

        @Override
        public FileSystemProvider provider() {
            return this.delegate.provider();
        }

        @Override
        public void close() throws IOException {
            FileSystemManager.close(this);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return this.delegate.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return this.delegate.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return this.delegate.supportedFileAttributeViews();
        }

        @Override
        public Path getPath(String first2, String ... more) {
            return this.delegate.getPath(first2, more);
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return this.delegate.getPathMatcher(syntaxAndPattern);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return this.delegate.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return this.delegate.newWatchService();
        }
    }
}

