/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Identifier
implements Comparable<Identifier> {
    private static final Map<String, Identifier> pool = new ConcurrentHashMap<String, Identifier>();
    private static final Map<String, Identifier> localPropertyPool = new ConcurrentHashMap<String, Identifier>();
    private static final Map<String, Identifier> localMethodPool = new ConcurrentHashMap<String, Identifier>();
    public static final Identifier LIST = Identifier.get("List");
    public static final Identifier SET = Identifier.get("Set");
    public static final Identifier MAP = Identifier.get("Map");
    public static final Identifier ANY = Identifier.get("Any");
    public static final Identifier TYPED = Identifier.get("Typed");
    public static final Identifier MODULE = Identifier.get("Module");
    public static final Identifier MODULE_INFO = Identifier.get("ModuleInfo");
    public static final Identifier TO_STRING = Identifier.get("toString");
    public static final Identifier MESSAGE = Identifier.get("message");
    public static final Identifier DEFAULT = Identifier.get("default");
    public static final Identifier MODE = Identifier.get("mode");
    public static final Identifier INDENT = Identifier.get("indent");
    public static final Identifier INDENT_WIDTH = Identifier.get("indentWidth");
    public static final Identifier OMIT_NULL_PROPERTIES = Identifier.get("omitNullProperties");
    public static final Identifier USE_CUSTOM_STRING_DELIMITERS = Identifier.get("useCustomStringDelimiters");
    public static final Identifier IS_STREAM = Identifier.get("isStream");
    public static final Identifier RESTRICT_CHARSET = Identifier.get("restrictCharset");
    public static final Identifier XML_VERSION = Identifier.get("xmlVersion");
    public static final Identifier ROOT_ELEMENT_NAME = Identifier.get("rootElementName");
    public static final Identifier ROOT_ELEMENT_ATTRIBUTES = Identifier.get("rootElementAttributes");
    public static final Identifier CONVERTERS = Identifier.get("converters");
    public static final Identifier USE_MAPPING = Identifier.get("useMapping");
    public static final Identifier START = Identifier.get("start");
    public static final Identifier END = Identifier.get("end");
    public static final Identifier VALUE = Identifier.get("value");
    public static final Identifier GROUPS = Identifier.get("groups");
    public static final Identifier OUTPUT = Identifier.get("output");
    public static final Identifier FILES = Identifier.get("files");
    public static final Identifier TEXT = Identifier.get("text");
    public static final Identifier BASE64 = Identifier.get("base64");
    public static final Identifier URI = Identifier.get("uri");
    public static final Identifier MIN_PKL_VERSION = Identifier.get("minPklVersion");
    public static final Identifier NS = Identifier.get("ns");
    public static final Identifier US = Identifier.get("us");
    public static final Identifier MS = Identifier.get("ms");
    public static final Identifier S = Identifier.get("s");
    public static final Identifier MIN = Identifier.get("min");
    public static final Identifier H = Identifier.get("h");
    public static final Identifier D = Identifier.get("d");
    public static final Identifier B = Identifier.get("b");
    public static final Identifier KB = Identifier.get("kb");
    public static final Identifier KIB = Identifier.get("kib");
    public static final Identifier MB = Identifier.get("mb");
    public static final Identifier MIB = Identifier.get("mib");
    public static final Identifier GB = Identifier.get("gb");
    public static final Identifier GIB = Identifier.get("gib");
    public static final Identifier TB = Identifier.get("tb");
    public static final Identifier TIB = Identifier.get("tib");
    public static final Identifier PB = Identifier.get("pb");
    public static final Identifier PIB = Identifier.get("pib");
    public static final Identifier FIRST = Identifier.get("first");
    public static final Identifier SECOND = Identifier.get("second");
    public static final Identifier APPLY = Identifier.get("apply");
    public static final Identifier BEFORE = Identifier.get("before");
    public static final Identifier AFTER = Identifier.get("after");
    public static final Identifier IS_XML_ELEMENT = Identifier.get("_isXmlElement");
    public static final Identifier NAME = Identifier.get("name");
    public static final Identifier ATTRIBUTES = Identifier.get("attributes");
    public static final Identifier IS_BLOCK_FORMAT = Identifier.get("isBlockFormat");
    public static final Identifier PATH = Identifier.get("path");
    public static final Identifier FACTS = Identifier.get("facts");
    public static final Identifier EXAMPLES = Identifier.get("examples");
    public static final Identifier ITERATIONS = Identifier.get("iterations");
    public static final Identifier ITERATION_TIME = Identifier.get("iterationTime");
    public static final Identifier IS_VERBOSE = Identifier.get("isVerbose");
    public static final Identifier EXPRESSION = Identifier.get("expression");
    public static final Identifier SOURCE_MODULE = Identifier.get("sourceModule");
    public static final Identifier SOURCE_TEXT = Identifier.get("sourceText");
    public static final Identifier SOURCE_URI = Identifier.get("sourceUri");
    public static final Identifier MAX_COLLECTION_ALIASES = Identifier.get("maxCollectionAliases");
    public static final Identifier DEPENDENCIES = Identifier.get("dependencies");
    public static final Identifier IT = Identifier.get("it");
    private final String name;

    private Identifier(String name) {
        this.name = name;
    }

    @CompilerDirectives.TruffleBoundary
    public static Identifier get(String name) {
        return pool.computeIfAbsent(name, Identifier::new);
    }

    @CompilerDirectives.TruffleBoundary
    public static Identifier localProperty(String name) {
        return localPropertyPool.computeIfAbsent(name, Identifier::new);
    }

    @CompilerDirectives.TruffleBoundary
    public static Identifier localMethod(String name) {
        return localMethodPool.computeIfAbsent(name, Identifier::new);
    }

    @CompilerDirectives.TruffleBoundary
    public static Identifier property(String name, boolean isLocal) {
        return isLocal ? Identifier.localProperty(name) : Identifier.get(name);
    }

    @CompilerDirectives.TruffleBoundary
    public static Identifier method(String name, boolean isLocal) {
        return isLocal ? Identifier.localMethod(name) : Identifier.get(name);
    }

    public Identifier toLocalProperty() {
        return Identifier.localProperty(this.name);
    }

    public Identifier toRegular() {
        return Identifier.get(this.name);
    }

    public Identifier toLocalMethod() {
        return Identifier.localMethod(this.name);
    }

    public boolean isRegular() {
        return Identifier.get(this.name) == this;
    }

    public boolean isLocalProp() {
        return Identifier.localProperty(this.name) == this;
    }

    public boolean isLocalMethod() {
        return Identifier.localMethod(this.name) == this;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int compareTo(Identifier other) {
        return this.name.compareTo(other.name);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.name;
    }
}

