/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.Member;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.StringSimilarity;

public class MemberLookupSuggestions {
    private static final StringSimilarity STRING_SIMILARITY = new StringSimilarity();
    private static final double SIMILARITY_THRESHOLD = 0.77;
    private final VmObjectLike composite;
    private final Object memberName;
    private final int memberArity;
    private final Set<Candidate.Kind> memberKinds;
    private final Set<Candidate> candidates = new LinkedHashSet<Candidate>();

    public MemberLookupSuggestions(VmObjectLike composite, Object memberName, int memberArity, Set<Candidate.Kind> memberKinds) {
        this.composite = composite;
        this.memberName = memberName;
        this.memberArity = memberArity;
        this.memberKinds = memberKinds;
    }

    public List<Candidate> find(boolean isImplicitReceiver) {
        VmObjectLike curr;
        this.candidates.clear();
        if (isImplicitReceiver) {
            for (curr = this.composite; curr != null; curr = curr.getEnclosingOwner()) {
                this.addPropertyCandidates(curr, true);
                if (!curr.isPrototype()) continue;
                this.addMethodCandidates(curr.getVmClass().getDeclaredMethods(), true);
            }
            this.addPropertyCandidates(BaseModule.getModule(), false);
            this.addMethodCandidates(BaseModule.getModule().getVmClass().getMethods(), false);
        }
        for (curr = this.composite; curr != null; curr = curr.getParent()) {
            this.addPropertyCandidates(curr, false);
        }
        this.addMethodCandidates(this.composite.getVmClass().getMethods(), false);
        return this.candidates.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void addPropertyCandidates(VmObjectLike object, boolean includeLocal) {
        if (!this.memberKinds.contains((Object)Candidate.Kind.PROPERTY)) {
            return;
        }
        for (ObjectMember member : EconomicMaps.getValues(object.getMembers())) {
            this.addIfSimilar(member, Candidate.Kind.PROPERTY, -1, includeLocal);
        }
    }

    private void addMethodCandidates(Iterable<ClassMethod> methods, boolean includeLocal) {
        if (!this.memberKinds.contains((Object)Candidate.Kind.METHOD)) {
            return;
        }
        for (ClassMethod method : methods) {
            this.addIfSimilar(method, Candidate.Kind.METHOD, method.getParameterCount(), includeLocal);
        }
    }

    private void addIfSimilar(Member member, Candidate.Kind kind, int arity, boolean includeLocal) {
        double nameSimilarity;
        Identifier memberName = member.getNameOrNull();
        if (memberName == null) {
            return;
        }
        if ((includeLocal || !member.isLocal()) && (nameSimilarity = STRING_SIMILARITY.similarity(memberName.toString(), this.memberName.toString())) >= 0.77) {
            int arityDifference = Math.abs(arity - this.memberArity);
            String signature = member.getCallSignature();
            assert (signature != null);
            if (nameSimilarity < 1.0 || this.memberArity == 0) {
                this.candidates.add(new Candidate(kind, memberName.toString(), signature, nameSimilarity, arityDifference));
            } else if (nameSimilarity == 1.0 && this.memberArity >= 0) {
                this.candidates.add(new Candidate(kind, memberName.toString(), signature + ".apply(...)", nameSimilarity, arityDifference));
            }
        }
    }

    public static final class Candidate
    implements Comparable<Candidate> {
        private final Kind kind;
        private final String name;
        private final String callSignature;
        private final double nameSimilarity;
        private final int arityDifference;

        public Candidate(Kind kind, String name, String callSignature, double nameSimilarity, int arityDifference) {
            this.kind = kind;
            this.name = name;
            this.callSignature = callSignature;
            this.nameSimilarity = nameSimilarity;
            this.arityDifference = arityDifference;
        }

        @Override
        public int compareTo(Candidate other) {
            if (this.nameSimilarity == other.nameSimilarity) {
                return Integer.compare(this.arityDifference, other.arityDifference);
            }
            return Double.compare(other.nameSimilarity, this.nameSimilarity);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Candidate)) {
                return false;
            }
            Candidate other = (Candidate)obj;
            return this.kind == other.kind && this.name.equals(other.name);
        }

        public int hashCode() {
            return this.kind.hashCode() * 31 + this.name.hashCode();
        }

        public String toString() {
            return this.callSignature;
        }

        public static enum Kind {
            PROPERTY,
            METHOD;

        }
    }
}

