/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import org.pkl.core.ModuleSchema;
import org.pkl.core.PClass;
import org.pkl.core.TypeAlias;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.expression.unary.ImportGlobNode;
import org.pkl.core.ast.expression.unary.ImportNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

public final class ModuleInfo {
    private final SourceSection headerSection;
    private final SourceSection sourceSection;
    private final @Nullable SourceSection docComment;
    private final String moduleName;
    private final ModuleKey moduleKey;
    private final ResolvedModuleKey resolvedModuleKey;
    private final boolean isAmend;
    @LateInit
    private List<VmTyped> annotations;
    @LateInit
    private VmTyped __mirror;
    private final Object mirrorLock = new Object();
    @LateInit
    private ModuleSchema __moduleSchema;
    private final Object moduleSchemaLock = new Object();

    public ModuleInfo(SourceSection sourceSection, SourceSection headerSection, @Nullable SourceSection docComment, String moduleName, ModuleKey moduleKey, ResolvedModuleKey resolvedModuleKey, boolean isAmend) {
        this.sourceSection = sourceSection;
        this.headerSection = headerSection;
        this.docComment = docComment;
        this.moduleName = moduleName;
        this.moduleKey = moduleKey;
        this.resolvedModuleKey = resolvedModuleKey;
        this.isAmend = isAmend;
    }

    public void initAnnotations(List<VmTyped> annotations) {
        assert (this.annotations == null);
        this.annotations = annotations;
    }

    public List<VmTyped> getAnnotations() {
        assert (this.annotations != null);
        return this.annotations;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public SourceSection getHeaderSection() {
        return this.headerSection;
    }

    public @Nullable SourceSection getDocComment() {
        return this.docComment;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ModuleKey getModuleKey() {
        return this.moduleKey;
    }

    public ResolvedModuleKey getResolvedModuleKey() {
        return this.resolvedModuleKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmTyped getMirror(VmTyped module) {
        Object object = this.mirrorLock;
        synchronized (object) {
            assert (module.getModuleInfo() == this);
            if (this.__mirror == null) {
                this.__mirror = MirrorFactories.moduleFactory.create(module);
            }
            return this.__mirror;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSchema getModuleSchema(VmTyped module) {
        Object object = this.moduleSchemaLock;
        synchronized (object) {
            assert (module.getModuleInfo() == this);
            if (this.__moduleSchema == null) {
                VmTyped parent = module.getParent();
                assert (parent != null);
                ModuleSchema supermodule = null;
                if (parent != BaseModule.getModuleClass().getPrototype()) {
                    supermodule = parent.getModuleInfo().getModuleSchema(parent);
                }
                LinkedHashMap<String, URI> imports = new LinkedHashMap<String, URI>();
                LinkedHashMap<String, PClass> classes = new LinkedHashMap<String, PClass>();
                LinkedHashMap<String, TypeAlias> typeAliases = new LinkedHashMap<String, TypeAlias>();
                for (ObjectMember propertyDef : EconomicMaps.getValues(module.getMembers())) {
                    if (propertyDef.isImport()) {
                        MemberNode memberNode = propertyDef.getMemberNode();
                        assert (memberNode != null);
                        ExpressionNode importNode = memberNode.getBodyNode();
                        URI importUri = importNode instanceof ImportNode ? ((ImportNode)importNode).getImportUri() : ((ImportGlobNode)importNode).getImportUri();
                        imports.put(propertyDef.getName().toString(), importUri);
                        continue;
                    }
                    if (propertyDef.isLocal()) continue;
                    if (propertyDef.isClass()) {
                        VmClass clazz = (VmClass)module.getCachedValue(propertyDef.getName());
                        if (clazz == null) {
                            clazz = (VmClass)propertyDef.getCallTarget().call(module, module);
                        }
                        classes.put(clazz.getSimpleName(), clazz.export());
                        continue;
                    }
                    if (!propertyDef.isTypeAlias()) continue;
                    VmTypeAlias typeAlias = (VmTypeAlias)module.getCachedValue(propertyDef.getName());
                    if (typeAlias == null) {
                        typeAlias = (VmTypeAlias)propertyDef.getCallTarget().call(module, module);
                    }
                    typeAliases.put(typeAlias.getSimpleName(), typeAlias.export());
                }
                this.__moduleSchema = new ModuleSchema(this.moduleKey.getUri(), this.moduleName, this.isAmend, supermodule, module.getVmClass().export(), VmUtils.exportDocComment(module.getModuleInfo().docComment), VmUtils.exportAnnotations(module.getModuleInfo().annotations), classes, typeAliases, imports);
            }
            return this.__moduleSchema;
        }
    }

    public boolean isAmend() {
        return this.isAmend;
    }
}

