/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.pkl.core.Member;
import org.pkl.core.PObject;
import org.pkl.core.TypeAlias;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

public final class VmTypeAlias
extends VmValue {
    private final SourceSection sourceSection;
    private final SourceSection headerSection;
    private final @Nullable SourceSection docComment;
    private final int modifiers;
    private final List<VmTyped> annotations;
    private final String simpleName;
    private final VmTyped module;
    private final String qualifiedName;
    private final List<TypeParameter> typeParameters;
    @LateInit
    private TypeNode typeNode;
    @LateInit
    @GuardedBy(value="pTypeAliasLock")
    private TypeAlias __pTypeAlias;
    private final Object pTypeAliasLock = new Object();
    @LateInit
    @GuardedBy(value="mirrorLock")
    private VmTyped __mirror;
    private final Object mirrorLock = new Object();

    public VmTypeAlias(SourceSection sourceSection, SourceSection headerSection, @Nullable SourceSection docComment, int modifiers, List<VmTyped> annotations, String simpleName2, VmTyped module, String qualifiedName, List<TypeParameter> typeParameters) {
        this.sourceSection = sourceSection;
        this.headerSection = headerSection;
        this.docComment = docComment;
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.simpleName = simpleName2;
        this.module = module;
        this.qualifiedName = qualifiedName;
        this.typeParameters = typeParameters;
    }

    public void initTypeCheckNode(TypeNode typeNode) {
        assert (this.typeNode == null);
        this.typeNode = typeNode;
    }

    public SourceSection getHeaderSection() {
        return this.headerSection;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getBaseTypeSection() {
        if (this.typeNode instanceof TypeNode.ConstrainedTypeNode) {
            return ((TypeNode.ConstrainedTypeNode)this.typeNode).getBaseTypeSection();
        }
        throw new VmExceptionBuilder().bug("Not a type alias of the form `typealias X = Y(constraint)`.", new Object[0]).withSourceSection(this.typeNode.getSourceSection()).build();
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getConstraintSection() {
        if (this.typeNode instanceof TypeNode.ConstrainedTypeNode) {
            return ((TypeNode.ConstrainedTypeNode)this.typeNode).getFirstConstraintSection();
        }
        throw new VmExceptionBuilder().bug("Not a type alias of the form `typealias X = Y(constraint)`.", new Object[0]).withSourceSection(this.typeNode.getSourceSection()).build();
    }

    public boolean isInitialized() {
        return this.typeNode != null;
    }

    public @Nullable SourceSection getDocComment() {
        return this.docComment;
    }

    public List<VmTyped> getAnnotations() {
        return this.annotations;
    }

    public String getModuleName() {
        return this.module.getVmClass().getModuleName();
    }

    public VmTyped getModuleMirror() {
        return this.module.getModuleInfo().getMirror(this.module);
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int getTypeParameterCount() {
        return this.typeParameters.size();
    }

    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    @CompilerDirectives.TruffleBoundary
    public TypeNode instantiate(TypeNode[] typeArgumentNodes) {
        TypeNode clone = (TypeNode)this.typeNode.deepCopy();
        if (this.typeParameters.isEmpty()) {
            return clone;
        }
        clone.accept((Node node) -> {
            if (node instanceof TypeNode.TypeVariableNode) {
                TypeNode.TypeVariableNode typeVarNode = (TypeNode.TypeVariableNode)node;
                int index = typeVarNode.getTypeParameterIndex();
                node.replace(typeArgumentNodes.length == 0 ? new TypeNode.UnknownTypeNode(this.sourceSection) : typeArgumentNodes[index]);
            }
            return true;
        });
        return clone;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getTypeAliasClass();
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeAlias export() {
        Object object = this.pTypeAliasLock;
        synchronized (object) {
            if (this.__pTypeAlias == null) {
                ArrayList<PObject> pAnnotations = new ArrayList<PObject>(this.annotations.size());
                this.__pTypeAlias = new TypeAlias(VmUtils.exportDocComment(this.docComment), new Member.SourceLocation(this.headerSection.getStartLine(), this.sourceSection.getEndLine()), VmModifier.export(this.modifiers, true), pAnnotations, this.simpleName, this.getModuleName(), this.qualifiedName, this.typeParameters);
                for (TypeParameter parameter : this.typeParameters) {
                    parameter.initOwner(this.__pTypeAlias);
                }
                VmUtils.exportAnnotations(this.annotations, pAnnotations);
                this.__pTypeAlias.initAliasedType(TypeNode.export(this.typeNode));
            }
            return this.__pTypeAlias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmTyped getMirror() {
        Object object = this.mirrorLock;
        synchronized (object) {
            if (this.__mirror == null) {
                this.__mirror = MirrorFactories.typeAliasFactory.create(this);
            }
            return this.__mirror;
        }
    }

    public VmSet getModifierMirrors() {
        return VmModifier.getMirrors(this.modifiers, false);
    }

    public VmList getTypeParameterMirrors() {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (TypeParameter typeParameter : this.typeParameters) {
            builder.add(MirrorFactories.typeParameterFactory.create(typeParameter));
        }
        return builder.build();
    }

    public VmTyped getTypeMirror() {
        return this.typeNode.getMirror();
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitTypeAlias(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertTypeAlias(this, path);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public String toString() {
        return this.qualifiedName.startsWith("pkl.base#") ? this.simpleName : this.qualifiedName;
    }
}

