/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.net.URI;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.StdLibModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;

public final class XmlModule
extends StdLibModule {
    private static final VmTyped instance = VmUtils.createEmptyModule();

    public static VmTyped getModule() {
        return instance;
    }

    public static VmClass getInlineClass() {
        return InlineClass.instance;
    }

    public static VmClass getCommentClass() {
        return CommentClass.instance;
    }

    public static VmClass getCDataClass() {
        return CDataClass.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static VmClass loadClass(String className) {
        VmTyped theModule = XmlModule.getModule();
        return (VmClass)VmUtils.readMember(theModule, Identifier.get(className));
    }

    static {
        XmlModule.loadModule(URI.create("pkl:xml"), instance);
    }

    private static final class CDataClass {
        static final VmClass instance = XmlModule.loadClass("CData");

        private CDataClass() {
        }
    }

    private static final class CommentClass {
        static final VmClass instance = XmlModule.loadClass("Comment");

        private CommentClass() {
        }
    }

    private static final class InlineClass {
        static final VmClass instance = XmlModule.loadClass("Inline");

        private InlineClass() {
        }
    }
}

