/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import java.util.PrimitiveIterator;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.stdlib.PklName;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;

public final class IntSeqNodes {
    private IntSeqNodes() {
    }

    private static void reportLoopCount(Node node, long count2) {
        LoopNode.reportLoopCount(node, count2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count2);
    }

    public static abstract class toListing
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmListing eval(VmIntSeq self) {
            EconomicMap<Object, ObjectMember> result = EconomicMaps.create();
            PrimitiveIterator.OfLong iterator = self.iterator();
            long idx = 0L;
            while (iterator.hasNext()) {
                EconomicMaps.put(result, idx, VmUtils.createSyntheticObjectElement(String.valueOf(idx), iterator.nextLong()));
                ++idx;
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), result, result.size());
        }
    }

    public static abstract class toList
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(VmIntSeq self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            PrimitiveIterator.OfLong iterator = self.iterator();
            while (iterator.hasNext()) {
                builder.add(iterator.nextLong());
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class map
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmIntSeq self, VmFunction function) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            PrimitiveIterator.OfLong iterator = self.iterator();
            while (iterator.hasNext()) {
                builder.add(this.applyLambdaNode.execute(function, iterator.nextLong()));
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmIntSeq self, Object initial, VmFunction function) {
            Object result = initial;
            PrimitiveIterator.OfLong iter = self.iterator();
            while (iter.hasNext()) {
                result = this.applyLambdaNode.execute(function, result, iter.nextLong());
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return result;
        }
    }

    @PklName(value="step")
    public static abstract class stepMethod
    extends ExternalMethod1Node {
        @Specialization
        protected VmIntSeq eval(VmIntSeq self, long step2) {
            return new VmIntSeq(self.start, self.end, step2);
        }
    }

    public static abstract class step
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmIntSeq self) {
            return self.step;
        }
    }

    public static abstract class end
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmIntSeq self) {
            return self.end;
        }
    }

    public static abstract class start
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmIntSeq self) {
            return self.start;
        }
    }
}

