/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import org.pkl.core.ast.lambda.ApplyVmFunction3Node;
import org.pkl.core.ast.lambda.ApplyVmFunction3NodeGen;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.MutableLong;
import org.pkl.core.util.MutableReference;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;

public final class MappingNodes {
    private MappingNodes() {
    }

    public static abstract class toMap
    extends ExternalMethod0Node {
        @Specialization
        protected VmMap eval(VmMapping self) {
            VmMap.Builder builder = VmMap.builder();
            self.forceAndIterateMemberValues((key2, def, value2) -> {
                builder.add(key2, value2);
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction3Node applyLambdaNode = ApplyVmFunction3NodeGen.create();

        @Specialization
        protected Object eval(VmMapping self, Object initial, VmFunction function) {
            MutableReference<Object> result = new MutableReference<Object>(initial);
            self.forceAndIterateMemberValues((key2, def, value2) -> {
                result.set(this.applyLambdaNode.execute(function, result.get(), key2, value2));
                return true;
            });
            return result.get();
        }
    }

    public static abstract class getOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private IndirectCallNode callNode = IndirectCallNode.create();

        @Specialization
        protected Object eval(VmMapping self, Object key2) {
            return VmNull.lift(VmUtils.readMemberOrNull((VmObjectLike)self, key2, this.callNode));
        }
    }

    public static abstract class containsKey
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmMapping self, Object key2) {
            if (self.hasCachedValue(key2)) {
                return true;
            }
            for (VmObjectLike curr = self; curr != null; curr = ((VmObjectLike)curr).getParent()) {
                if (!((VmObjectLike)curr).hasMember(key2)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class keys
    extends ExternalPropertyNode {
        @Specialization
        protected VmSet eval(VmMapping self) {
            return self.getAllKeys();
        }
    }

    public static abstract class length
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected long eval(VmMapping self) {
            MutableLong count2 = new MutableLong(0L);
            self.iterateMemberValues((key2, member, value2) -> {
                count2.getAndIncrement();
                return true;
            });
            return count2.get();
        }
    }

    public static abstract class isEmpty
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected boolean eval(VmMapping self) {
            for (VmObjectLike curr = self; curr != null; curr = ((VmObjectLike)curr).getParent()) {
                UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(((VmObjectLike)curr).getMembers());
                while (cursor.advance()) {
                    if (cursor.getKey() instanceof Identifier) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

