/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import org.pkl.core.ValueFormatter;
import org.pkl.core.parser.Lexer;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.LateInit;

public final class PcfRenderer
extends AbstractRenderer {
    private final ValueFormatter valueFormatter;
    private boolean isDocument;
    @LateInit
    private Object topLevelValue;

    public PcfRenderer(StringBuilder builder, String indent, PklConverter converter, boolean omitNullProperties, boolean useCustomStringDelimiters) {
        super("Pcf", builder, indent, converter, omitNullProperties, false);
        this.valueFormatter = new ValueFormatter(true, useCustomStringDelimiters);
    }

    @Override
    public void visitString(String value2) {
        this.increaseIndent();
        this.valueFormatter.formatStringValue(value2, (CharSequence)this.currIndent, this.builder);
        this.decreaseIndent();
    }

    private void renderStringElement(String value2) {
        this.valueFormatter.formatStringValue(value2, (CharSequence)this.currIndent, this.builder);
    }

    @Override
    public void visitTyped(VmTyped value2) {
        if (VmUtils.isPcfRenderDirective(value2)) {
            this.visitPcfRenderDirective(value2);
        } else {
            super.visitTyped(value2);
        }
    }

    @Override
    public void visitInt(Long value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitFloat(Double value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitBoolean(Boolean value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitDuration(VmDuration value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitDataSize(VmDataSize value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitPair(VmPair value2) {
        this.builder.append("Pair(");
        this.visitStandaloneValue(value2.getFirst());
        this.builder.append(", ");
        this.visitStandaloneValue(value2.getSecond());
        this.builder.append(')');
    }

    @Override
    public void visitRegex(VmRegex value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitIntSeq(VmIntSeq value2) {
        this.builder.append(value2);
    }

    @Override
    public void visitNull(VmNull value2) {
        this.builder.append("null");
    }

    @Override
    protected void visitRenderDirective(VmTyped value2) {
        this.builder.append(VmUtils.readTextProperty(value2));
    }

    private void visitPcfRenderDirective(VmTyped value2) {
        Object before = VmUtils.readMember(value2, Identifier.BEFORE);
        if (before instanceof String) {
            this.builder.append((String)before);
        }
        this.visit(VmUtils.readMember(value2, Identifier.VALUE));
        Object after = VmUtils.readMember(value2, Identifier.AFTER);
        if (after instanceof String) {
            this.builder.append((String)after);
        }
    }

    @Override
    protected void visitDocument(Object value2) {
        if (!(value2 instanceof VmTyped) && !(value2 instanceof VmDynamic)) {
            throw new VmExceptionBuilder().evalError("invalidPcfTopLevelValue", VmUtils.getClass(value2)).withProgramValue("Value", value2).build();
        }
        this.isDocument = true;
        this.topLevelValue = value2;
        this.visit(value2);
        if (this.builder.length() > 0) {
            this.builder.append('\n');
        }
    }

    @Override
    protected void visitTopLevelValue(Object value2) {
        this.topLevelValue = value2;
        this.visit(value2);
    }

    @Override
    protected boolean canRenderPropertyOrEntryOf(VmDynamic object) {
        return true;
    }

    @Override
    protected void startDynamic(VmDynamic value2) {
        this.startObject(value2);
    }

    @Override
    protected void startTyped(VmTyped value2) {
        this.startObject(value2);
    }

    @Override
    protected void startListing(VmListing value2) {
        this.startObject(value2);
    }

    @Override
    protected void startMapping(VmMapping value2) {
        this.startObject(value2);
    }

    @Override
    protected void startList(VmList value2) {
        this.builder.append("List(");
    }

    @Override
    protected void startSet(VmSet value2) {
        this.builder.append("Set(");
    }

    @Override
    protected void startMap(VmMap value2) {
        this.builder.append("Map(");
    }

    @Override
    protected void visitElement(long index, Object value2, boolean isFirst) {
        if (this.enclosingValue instanceof VmObjectLike) {
            this.builder.append('\n');
            this.builder.append((CharSequence)this.currIndent);
            if (value2 instanceof String) {
                this.renderStringElement((String)value2);
            } else {
                this.visitStandaloneValue(value2);
            }
        } else {
            if (!isFirst) {
                this.builder.append(", ");
            }
            this.visitStandaloneValue(value2);
        }
    }

    private void visitStandaloneValue(Object value2) {
        if (value2 instanceof VmObjectLike && !VmUtils.isRenderDirective(value2)) {
            this.builder.append("new ");
        }
        this.visit(value2);
    }

    @Override
    protected void visitEntryKey(Object key2, boolean isFirst) {
        if (this.enclosingValue instanceof VmObjectLike) {
            this.builder.append('\n');
            this.builder.append((CharSequence)this.currIndent);
            this.builder.append('[');
            this.visitStandaloneValue(key2);
            this.builder.append(']');
        } else {
            if (!isFirst) {
                this.builder.append(", ");
            }
            this.visitStandaloneValue(key2);
        }
    }

    @Override
    protected void visitEntryValue(Object value2) {
        if (this.enclosingValue instanceof VmObjectLike) {
            if (value2 instanceof VmObjectLike) {
                this.builder.append(' ');
            } else {
                this.builder.append(" = ");
            }
            this.visit(value2);
        } else {
            this.builder.append(", ");
            this.visitStandaloneValue(value2);
        }
    }

    @Override
    protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
        if (this.builder.length() > 0) {
            this.builder.append('\n');
            this.builder.append((CharSequence)this.currIndent);
        }
        this.builder.append(Lexer.maybeQuoteIdentifier(name.toString()));
        if (value2 instanceof VmObjectLike) {
            this.builder.append(' ');
        } else {
            this.builder.append(" = ");
        }
        this.visit(value2);
    }

    @Override
    protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
        this.endObject(value2, isEmpty2);
    }

    @Override
    protected void endTyped(VmTyped value2, boolean isEmpty2) {
        this.endObject(value2, isEmpty2);
    }

    @Override
    protected void endListing(VmListing value2, boolean isEmpty2) {
        this.endObject(value2, isEmpty2);
    }

    @Override
    protected void endMapping(VmMapping value2, boolean isEmpty2) {
        this.endObject(value2, isEmpty2);
    }

    @Override
    protected void endList(VmList value2) {
        this.builder.append(')');
    }

    @Override
    protected void endSet(VmSet value2) {
        this.builder.append(')');
    }

    @Override
    protected void endMap(VmMap value2) {
        this.builder.append(')');
    }

    private void startObject(VmObjectLike value2) {
        if (this.isDocument && value2 == this.topLevelValue) {
            return;
        }
        this.increaseIndent();
        this.builder.append('{');
    }

    private void endObject(VmObjectLike value2, boolean isEmpty2) {
        if (this.isDocument && value2 == this.topLevelValue) {
            return;
        }
        this.decreaseIndent();
        if (!isEmpty2) {
            this.builder.append('\n');
            this.builder.append((CharSequence)this.currIndent);
        }
        this.builder.append('}');
    }
}

