/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.properties.PropertiesUtils;

public final class PropertiesRendererNodes {
    private PropertiesRendererNodes() {
    }

    private static PropertiesRenderer createRenderer(VmTyped self, StringBuilder builder) {
        boolean omitNullProperties = (Boolean)VmUtils.readMember(self, Identifier.OMIT_NULL_PROPERTIES);
        boolean restrictCharset = (Boolean)VmUtils.readMember(self, Identifier.RESTRICT_CHARSET);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        PklConverter PklConverter2 = new PklConverter(converters);
        return new PropertiesRenderer(builder, omitNullProperties, restrictCharset, PklConverter2);
    }

    private static final class PropertiesRenderer
    extends AbstractRenderer {
        private final boolean restrictCharset;
        private boolean isDocument;

        public PropertiesRenderer(StringBuilder builder, boolean omitNullProperties, boolean restrictCharset, PklConverter converter) {
            super("Properties", builder, "", converter, omitNullProperties, omitNullProperties);
            this.restrictCharset = restrictCharset;
        }

        @Override
        public void visitString(String value2) {
            this.visitPropertyValue(value2);
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.visitPropertyValue(value2);
        }

        @Override
        public void visitInt(Long value2) {
            this.visitPropertyValue(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            this.visitPropertyValue(value2);
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitNull(VmNull value2) {
            if (this.isDocument) {
                this.writeKey();
                this.writeSeparator();
                this.writeLineBreak();
            }
        }

        @Override
        protected void visitDocument(Object value2) {
            if (!(value2 instanceof VmMap || value2 instanceof VmTyped || value2 instanceof VmMapping || value2 instanceof VmDynamic)) {
                throw new VmExceptionBuilder().evalError("invalidPropertiesTopLevelValue", VmUtils.getClass(value2)).withProgramValue("Value", value2).build();
            }
            if (!VmUtils.isRenderDirective(value2)) {
                this.isDocument = true;
            }
            this.visit(value2);
        }

        @Override
        protected void visitTopLevelValue(Object value2) {
            if ((value2 instanceof VmMap || value2 instanceof VmTyped || value2 instanceof VmMapping || value2 instanceof VmDynamic) && !VmUtils.isRenderDirective(value2)) {
                this.cannotRenderTypeAddConverter((VmValue)value2);
            }
            this.isDocument = false;
            this.visit(value2);
        }

        @Override
        protected void visitRenderDirective(VmTyped value2) {
            if (this.isDocument) {
                this.writeKey();
                this.writeSeparator();
            }
            this.builder.append(VmUtils.readTextProperty(value2));
            if (this.isDocument) {
                this.writeLineBreak();
            }
        }

        @Override
        protected void startDynamic(VmDynamic value2) {
        }

        @Override
        protected void startTyped(VmTyped value2) {
        }

        @Override
        protected void startListing(VmListing value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void startMapping(VmMapping value2) {
        }

        @Override
        protected void startList(VmList value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void startSet(VmSet value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void startMap(VmMap value2) {
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
        }

        @Override
        protected void visitEntryValue(Object value2) {
            this.visitKeyedValue(value2);
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            this.visitKeyedValue(value2);
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
        }

        @Override
        protected void endList(VmList value2) {
        }

        @Override
        protected void endSet(VmSet value2) {
        }

        @Override
        protected void endMap(VmMap value2) {
        }

        private void writeValue(String value2) {
            this.builder.append(PropertiesUtils.renderPropertiesKeyOrValue(value2, false, this.restrictCharset));
        }

        private void writeSeparator() {
            this.builder.append(" = ");
        }

        private void writeLineBreak() {
            this.builder.append("\n");
        }

        private void visitPropertyValue(Object value2) {
            if (this.isDocument) {
                this.writeKey();
                this.writeSeparator();
            }
            this.writeValue(value2.toString());
            if (this.isDocument) {
                this.writeLineBreak();
            }
        }

        private void visitKeyedValue(Object value2) {
            if (value2 instanceof VmDynamic && ((VmDynamic)value2).hasElements()) {
                VmListing newValue = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)((VmDynamic)value2), EconomicMaps.create(), ((VmDynamic)value2).getLength());
                this.visit(this.converter.convert(newValue, this.currPath));
            } else {
                this.visit(value2);
            }
        }

        private void writeKey() {
            MutableBoolean isFollowing = new MutableBoolean(false);
            this.currPath.descendingIterator().forEachRemaining(path -> {
                if (path == VmValueConverter.TOP_LEVEL_VALUE) {
                    return;
                }
                if (isFollowing.get()) {
                    this.builder.append('.');
                }
                if (VmUtils.isRenderDirective(path)) {
                    this.builder.append(VmUtils.readTextProperty(path));
                } else {
                    this.builder.append(PropertiesUtils.renderPropertiesKeyOrValue(path.toString(), true, this.restrictCharset));
                }
                isFollowing.set(true);
            });
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            PropertiesRendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            PropertiesRendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

