/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.yaml.YamlEmitter;

public final class YamlRendererNodes {
    private YamlRendererNodes() {
    }

    private static YamlRenderer createRenderer(VmTyped self, StringBuilder builder) {
        String mode = (String)VmUtils.readMember(self, Identifier.MODE);
        int indentWidth = ((Long)VmUtils.readMember(self, Identifier.INDENT_WIDTH)).intValue();
        boolean omitNullProperties = (Boolean)VmUtils.readMember(self, Identifier.OMIT_NULL_PROPERTIES);
        boolean isStream = (Boolean)VmUtils.readMember(self, Identifier.IS_STREAM);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        PklConverter converter = new PklConverter(converters);
        return new YamlRenderer(builder, " ".repeat(indentWidth), converter, omitNullProperties, mode, isStream);
    }

    private static final class YamlRenderer
    extends AbstractRenderer {
        private final boolean isStream;
        private final YamlEmitter emitter;
        private final String elementIndent;

        private YamlRenderer(StringBuilder builder, String indent, PklConverter converter, boolean omitNullProperties, String mode, boolean isStream) {
            super("YAML", builder, indent, converter, omitNullProperties, omitNullProperties);
            this.isStream = isStream;
            this.emitter = YamlEmitter.create(builder, mode, indent);
            this.elementIndent = indent.substring(1);
        }

        @Override
        public void visitDocument(Object value2) {
            if (this.isStream) {
                this.visitStream(value2);
            } else {
                this.visit(value2);
            }
            this.startNewLine();
        }

        private void visitStream(Object value2) {
            if (value2 instanceof VmListing) {
                MutableBoolean isFirst = new MutableBoolean(true);
                ((VmListing)value2).forceAndIterateMemberValues((key2, member, element) -> {
                    if (!isFirst.getAndSetFalse()) {
                        this.startNewLine();
                        this.builder.append("---");
                    }
                    this.visit(element);
                    return true;
                });
                return;
            }
            if (value2 instanceof VmCollection) {
                boolean first2 = true;
                for (Object element2 : (VmCollection)value2) {
                    if (first2) {
                        first2 = false;
                    } else {
                        this.startNewLine();
                        this.builder.append("---");
                    }
                    this.visit(element2);
                }
                return;
            }
            throw new VmExceptionBuilder().evalError("invalidYamlStreamTopLevelValue", VmUtils.getClass(value2)).withProgramValue("Value", value2).build();
        }

        @Override
        public void visitTopLevelValue(Object value2) {
            this.visit(value2);
        }

        @Override
        public void visitString(String value2) {
            if (this.builder.length() > 0) {
                this.builder.append(' ');
            }
            this.emitter.emit(value2, this.currIndent, false);
        }

        @Override
        public void visitInt(Long value2) {
            if (this.builder.length() > 0) {
                this.builder.append(' ');
            }
            this.emitter.emit(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            if (this.builder.length() > 0) {
                this.builder.append(' ');
            }
            this.emitter.emit(value2);
        }

        @Override
        public void visitBoolean(Boolean value2) {
            if (this.builder.length() > 0) {
                this.builder.append(' ');
            }
            this.emitter.emit(value2);
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitRenderDirective(VmTyped value2) {
            this.builder.append(VmUtils.readTextProperty(value2));
        }

        @Override
        public void visitNull(VmNull value2) {
            if (this.builder.length() > 0) {
                this.builder.append(' ');
            }
            this.emitter.emitNull();
        }

        @Override
        protected void startDynamic(VmDynamic value2) {
            if (value2.hasElements()) {
                this.startYamlSequence();
            } else {
                this.startYamlMapping();
            }
        }

        @Override
        protected void startTyped(VmTyped value2) {
            this.startYamlMapping();
        }

        @Override
        protected void startListing(VmListing value2) {
            this.startYamlSequence();
        }

        @Override
        protected void startMapping(VmMapping value2) {
            this.startYamlMapping();
        }

        @Override
        protected void startList(VmList value2) {
            this.startYamlSequence();
        }

        @Override
        protected void startSet(VmSet value2) {
            this.startYamlSequence();
        }

        @Override
        protected void startMap(VmMap value2) {
            this.startYamlMapping();
        }

        private void startYamlMapping() {
            if (this.enclosingValue != null) {
                this.increaseIndent();
            }
            if (this.hasEnclosingSequence()) {
                this.builder.append(this.elementIndent);
            } else {
                this.startNewLine();
            }
        }

        private void startYamlSequence() {
            if (this.hasEnclosingSequence()) {
                this.increaseIndent();
                this.builder.append(this.elementIndent);
            } else {
                this.startNewLine();
            }
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
            if (!isFirst) {
                this.startNewLine();
            }
            this.builder.append('-');
            this.visit(value2);
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
            if (!isFirst) {
                this.startNewLine();
            }
            if (key2 instanceof String) {
                this.emitter.emit((String)key2, this.currIndent, true);
                this.builder.append(':');
                return;
            }
            if (VmUtils.isRenderDirective(key2)) {
                this.visitRenderDirective((VmTyped)key2);
                this.builder.append(':');
                return;
            }
            this.cannotRenderNonStringKey(key2);
        }

        @Override
        protected void visitEntryValue(Object value2) {
            this.visit(value2);
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            if (!isFirst) {
                this.startNewLine();
            }
            this.emitter.emit(name.toString(), this.currIndent, true);
            this.builder.append(':');
            this.visit(value2);
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
            if (value2.hasElements()) {
                this.endYamlSequence(isEmpty2);
            } else {
                this.endYamlMapping(isEmpty2);
            }
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
            this.endYamlMapping(isEmpty2);
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
            this.endYamlSequence(isEmpty2);
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
            this.endYamlMapping(isEmpty2);
        }

        @Override
        protected void endList(VmList value2) {
            this.endYamlSequence(value2.isEmpty());
        }

        @Override
        protected void endSet(VmSet value2) {
            this.endYamlSequence(value2.isEmpty());
        }

        @Override
        protected void endMap(VmMap value2) {
            this.endYamlMapping(value2.isEmpty());
        }

        private void endYamlSequence(boolean isEmpty2) {
            boolean hasEnclosingSequence = this.hasEnclosingSequence();
            if (isEmpty2) {
                if (hasEnclosingSequence) {
                    this.builder.append("[]");
                } else {
                    this.undoStartNewLine();
                    this.builder.append(" []");
                }
            }
            if (hasEnclosingSequence) {
                this.decreaseIndent();
            }
        }

        private void endYamlMapping(boolean isEmpty2) {
            if (isEmpty2) {
                if (this.hasEnclosingSequence()) {
                    this.builder.append("{}");
                } else {
                    this.undoStartNewLine();
                    this.builder.append(" {}");
                }
            }
            if (this.enclosingValue != null) {
                this.decreaseIndent();
            }
        }

        private boolean hasEnclosingSequence() {
            return this.enclosingValue != null && this.enclosingValue.isSequence();
        }

        private void startNewLine() {
            int length2 = this.builder.length();
            if (length2 == 0) {
                return;
            }
            if (this.builder.charAt(length2 - 1) != '\n') {
                this.builder.append('\n');
            }
            this.builder.append((CharSequence)this.currIndent);
        }

        private void undoStartNewLine() {
            int length2 = this.builder.length();
            if (length2 == 0) {
                return;
            }
            this.builder.setLength(length2 - this.currIndent.length() - 1);
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            YamlRendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            YamlRendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

