/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.jsonnet;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.JsonnetModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.ArrayCharEscaper;
import org.pkl.core.util.IoUtils;

public final class RendererNodes {
    private static Renderer createRenderer(VmTyped self, StringBuilder builder) {
        String indent = (String)VmNull.unwrap(VmUtils.readMember(self, Identifier.INDENT));
        if (indent == null) {
            indent = "";
        }
        boolean omitNullProperties = (Boolean)VmUtils.readMember(self, Identifier.OMIT_NULL_PROPERTIES);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        PklConverter converter = new PklConverter(converters);
        return new Renderer(builder, indent, omitNullProperties, converter);
    }

    private static final class Renderer
    extends AbstractRenderer {
        private static final Pattern ID_PATTERN = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
        private static final Set<String> RESERVED_KEYWORDS = Set.of("assert", "else", "error", "false", "for", "function", "if", "import", "importstr", "in", "local", "null", "self", "super", "tailstrict", "then", "true");
        private static final Pattern FIRST_NON_EMPTY_LINE_STARTS_WITH_NON_WHITESPACE = Pattern.compile("\\n*\\S");
        private static final ArrayCharEscaper SINGLE_QUOTE_ESCAPER = Renderer.createBaseEscaper().withEscape('\'', "\\'").build();
        private static final ArrayCharEscaper DOUBLE_QUOTE_ESCAPER = Renderer.createBaseEscaper().withEscape('\"', "\\\"").build();
        private final boolean renderInline;
        private final char memberSeparator;

        private static ArrayCharEscaper.Builder createBaseEscaper() {
            char ch;
            ArrayCharEscaper.Builder builder = ArrayCharEscaper.builder();
            for (ch = '\u0000'; ch < ' '; ch = (char)(ch + '\u0001')) {
                builder.withEscape(ch, IoUtils.toUnicodeEscape(ch));
            }
            for (ch = '\u0080'; ch <= '\u009f'; ch = (char)(ch + '\u0001')) {
                builder.withEscape(ch, IoUtils.toUnicodeEscape(ch));
            }
            return builder.withEscape('\\', "\\\\").withEscape('\b', "\\b").withEscape('\f', "\\f").withEscape('\n', "\\n").withEscape('\r', "\\r");
        }

        private Renderer(StringBuilder builder, String indent, boolean omitNullProperties, PklConverter converter) {
            super("Jsonnet", builder, indent, converter, omitNullProperties, omitNullProperties);
            this.renderInline = indent.isEmpty();
            this.memberSeparator = (char)(this.renderInline ? 32 : 10);
        }

        @Override
        protected void visitDocument(Object value2) {
            this.visit(value2);
            this.builder.append('\n');
        }

        @Override
        protected void visitTopLevelValue(Object value2) {
            this.visit(value2);
        }

        @Override
        protected void visitRenderDirective(VmTyped value2) {
            this.builder.append(VmUtils.readTextProperty(value2));
        }

        @Override
        public void visitTyped(VmTyped value2) {
            VmClass vmClass = value2.getVmClass();
            if (vmClass == JsonnetModule.getImportStrClass()) {
                this.builder.append("importstr ");
                this.renderAsQuotedString((String)VmUtils.readMember(value2, Identifier.PATH));
            } else if (vmClass == JsonnetModule.getExtVarClass()) {
                this.builder.append("std.extVar(");
                this.visitString((String)VmUtils.readMember(value2, Identifier.NAME));
                this.builder.append(')');
            } else {
                super.visitTyped(value2);
            }
        }

        @Override
        public void visitString(String value2) {
            this.renderAsString(value2);
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitInt(Long value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        private void startArray() {
            this.builder.append('[');
            this.increaseIndent();
        }

        private void startObject() {
            this.builder.append('{');
            this.increaseIndent();
        }

        private void endArray(boolean isEmpty2) {
            this.endValue(isEmpty2);
            this.builder.append(']');
        }

        private void endObject(boolean isEmpty2) {
            this.endValue(isEmpty2);
            if (!isEmpty2 && this.renderInline) {
                this.builder.append(" }");
            } else {
                this.builder.append('}');
            }
        }

        private void endValue(boolean isEmpty2) {
            this.decreaseIndent();
            if (!isEmpty2 && !this.renderInline) {
                this.builder.append(",\n").append((CharSequence)this.currIndent);
            }
        }

        @Override
        public void startList(VmList value2) {
            this.startArray();
        }

        @Override
        public void startSet(VmSet value2) {
            this.startArray();
        }

        @Override
        public void startMap(VmMap value2) {
            this.startObject();
        }

        @Override
        public void startTyped(VmTyped value2) {
            this.startObject();
        }

        @Override
        public void startDynamic(VmDynamic value2) {
            if (value2.hasElements()) {
                this.startArray();
            } else {
                this.startObject();
            }
        }

        @Override
        public void startListing(VmListing value2) {
            this.startArray();
        }

        @Override
        public void startMapping(VmMapping value2) {
            this.startObject();
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
            if (!isFirst) {
                this.builder.append(',');
            }
            this.builder.append(this.memberSeparator).append((CharSequence)this.currIndent);
            if (key2 instanceof String) {
                this.renderAsFieldName((String)key2);
            } else if (VmUtils.isRenderDirective(key2)) {
                this.visitRenderDirective((VmTyped)key2);
                this.builder.append(": ");
            } else {
                this.cannotRenderNonStringKey(key2);
            }
        }

        @Override
        protected void visitEntryValue(Object value2) {
            this.visit(value2);
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            if (!isFirst) {
                this.builder.append(',');
            }
            this.builder.append(this.memberSeparator).append((CharSequence)this.currIndent);
            this.renderAsFieldName(name.toString());
            this.visit(value2);
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
            if (!isFirst) {
                this.builder.append(',');
            }
            if (!isFirst || !this.renderInline) {
                this.builder.append(this.memberSeparator).append((CharSequence)this.currIndent);
            }
            this.visit(value2);
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
            if (value2.hasElements()) {
                this.endArray(isEmpty2);
            } else {
                this.endObject(isEmpty2);
            }
        }

        @Override
        protected void endList(VmList value2) {
            this.endArray(value2.isEmpty());
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
            this.endArray(isEmpty2);
        }

        @Override
        protected void endMap(VmMap value2) {
            this.endObject(value2.isEmpty());
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
            this.endObject(isEmpty2);
        }

        @Override
        protected void endSet(VmSet value2) {
            this.endArray(value2.isEmpty());
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
            this.endObject(isEmpty2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitNull(VmNull value2) {
            this.builder.append("null");
        }

        private void renderAsFieldName(String key2) {
            if (ID_PATTERN.matcher(key2).matches() && !RESERVED_KEYWORDS.contains(key2)) {
                this.builder.append(key2);
            } else {
                this.renderAsString(key2);
            }
            this.builder.append(": ");
        }

        private void renderAsString(String value2) {
            if (this.renderInline || !value2.contains("\n") || !FIRST_NON_EMPTY_LINE_STARTS_WITH_NON_WHITESPACE.matcher(value2).lookingAt()) {
                this.renderAsQuotedString(value2);
            } else {
                this.renderAsTextBlock(value2);
            }
        }

        private void renderAsQuotedString(String value2) {
            if (value2.contains("'") && !value2.contains("\"")) {
                this.builder.append('\"').append(DOUBLE_QUOTE_ESCAPER.escape(value2)).append('\"');
            } else {
                this.builder.append('\'').append(SINGLE_QUOTE_ESCAPER.escape(value2)).append('\'');
            }
        }

        private void renderAsTextBlock(String value2) {
            this.builder.append("|||\n");
            value2.lines().forEach(line -> this.builder.append((CharSequence)this.currIndent).append(this.indent).append((String)line).append('\n'));
            this.builder.append((CharSequence)this.currIndent).append("|||");
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            RendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            RendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

