/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.reflect;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.Pair;

public final class ReflectNodes {
    private ReflectNodes() {
    }

    public static abstract class nothingType
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self) {
            return MirrorFactories.nothingTypeFactory.create(null);
        }
    }

    public static abstract class unknownType
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self) {
            return MirrorFactories.unknownTypeFactory.create(null);
        }
    }

    public static abstract class moduleType
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self) {
            return MirrorFactories.moduleTypeFactory.create(null);
        }
    }

    public static abstract class TypeVariable
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmTyped referent) {
            return MirrorFactories.typeVariableFactory2.create(referent);
        }
    }

    public static abstract class UnionType
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmList members) {
            return MirrorFactories.unionTypeFactory2.create(members);
        }
    }

    public static abstract class StringLiteralType
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, String value2) {
            return MirrorFactories.stringLiteralTypeFactory2.create(value2);
        }
    }

    public static abstract class FunctionType
    extends ExternalMethod2Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmList parameterTypes, VmTyped returnType) {
            return MirrorFactories.functionTypeFactory2.create(Pair.of(parameterTypes, returnType));
        }
    }

    public static abstract class DeclaredType
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmTyped referent) {
            Object extraStorage = referent.getExtraStorage();
            assert (extraStorage instanceof VmClass || extraStorage instanceof VmTypeAlias);
            int typeParameterCount = extraStorage instanceof VmClass ? ((VmClass)extraStorage).getTypeParameterCount() : ((VmTypeAlias)extraStorage).getTypeParameterCount();
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            for (int i = 0; i < typeParameterCount; ++i) {
                builder.add(MirrorFactories.unknownTypeFactory.create(null));
            }
            return MirrorFactories.declaredTypeFactory.create(Pair.of(referent, builder.build()));
        }
    }

    public static abstract class TypeAlias
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmTypeAlias typeAlias) {
            return typeAlias.getMirror();
        }
    }

    public static abstract class Class
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmClass clazz) {
            return clazz.getMirror();
        }
    }

    public static abstract class moduleOf
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmTyped module) {
            VmTyped candidate = module;
            while (!candidate.isModuleObject()) {
                if ((candidate = candidate.getParent()) != null) continue;
                throw this.exceptionBuilder().bug("No module found in prototype chain.", new Object[0]).withLocation(this.getArg1Node()).build();
            }
            return candidate.getModuleMirror();
        }
    }

    public static abstract class Module
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmTyped module) {
            if (!module.isModuleObject()) {
                throw this.exceptionBuilder().evalError("expectedModule", new Object[0]).withLocation(this.getArg1Node()).build();
            }
            return module.getModuleMirror();
        }
    }
}

