/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.properties;

public class PropertiesUtils {
    private static final int[] bitmapEscapeSpace = new int[]{13824, 603979787, 0x10000000, 0};
    private static final int[] bitmapNoEscapeSpace = new int[]{13824, 603979786, 0x10000000, 0};
    private static final char[] hexDigitTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] hashtable = new char[]{' ', '!', '\u0000', '#', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 't', 'n', '\u0000', 'f', 'r', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ':', '\u0000', '\\', '=', '\u0000', '\u0000'};

    private PropertiesUtils() {
    }

    public static String renderPropertiesKeyOrValue(String value2, boolean escapeSpace, boolean restrictCharset) {
        if (value2.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (!escapeSpace && value2.charAt(0) == ' ') {
            builder.append('\\');
        }
        for (int i = 0; i < value2.length(); ++i) {
            boolean isEscapeChar;
            char c = value2.charAt(i);
            int[] bitmap = escapeSpace ? bitmapEscapeSpace : bitmapNoEscapeSpace;
            boolean bl = isEscapeChar = c < '\u0080' && (bitmap[c >> 5] & '\u0001' << c) != 0;
            if (isEscapeChar) {
                builder.append('\\').append(hashtable[c % 32]);
                continue;
            }
            if (restrictCharset && (c < ' ' || c > '~')) {
                builder.append('\\').append('u').append(hexDigitTable[c >> 12 & 0xF]).append(hexDigitTable[c >> 8 & 0xF]).append(hexDigitTable[c >> 4 & 0xF]).append(hexDigitTable[c & 0xF]);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

