/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml;

import org.pkl.core.util.yaml.Yaml11Emitter;
import org.pkl.core.util.yaml.Yaml12Emitter;
import org.pkl.core.util.yaml.YamlCompatEmitter;
import org.pkl.core.util.yaml.YamlEscaper;

public abstract class YamlEmitter {
    private static final YamlEscaper escaper = new YamlEscaper();
    protected final StringBuilder builder;
    protected final String indent;

    protected YamlEmitter(StringBuilder builder, String indent) {
        this.builder = builder;
        this.indent = indent;
    }

    public static YamlEmitter create(StringBuilder builder, String mode, String indent) {
        switch (mode) {
            case "compat": {
                return new YamlCompatEmitter(builder, indent);
            }
            case "1.1": {
                return new Yaml11Emitter(builder, indent);
            }
            case "1.2": {
                return new Yaml12Emitter(builder, indent);
            }
        }
        throw new IllegalArgumentException(mode);
    }

    public void emit(String str, StringBuilder currIndent, boolean isKey) {
        if (this.isReservedWord(str)) {
            this.emitSingleQuotedString(str, -1);
            return;
        }
        int length2 = str.length();
        boolean needsEscaping = false;
        boolean needsQuoting = false;
        boolean hasNonNumberChar = false;
        int newlineIndex = -1;
        int colonIndex = -1;
        int singleQuoteIndex = -1;
        char first2 = str.charAt(0);
        switch (first2) {
            case '\n': {
                newlineIndex = 0;
                break;
            }
            case '\'': {
                needsQuoting = true;
                singleQuoteIndex = 0;
                break;
            }
            case ' ': 
            case '!': 
            case '\"': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case ',': 
            case '>': 
            case '@': 
            case '[': 
            case ']': 
            case '`': 
            case '{': 
            case '|': 
            case '}': {
                needsQuoting = true;
                break;
            }
            case '-': 
            case ':': 
            case '?': {
                needsQuoting = length2 == 1 || str.charAt(1) == ' ';
            }
            case '+': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'o': {
                break;
            }
            default: {
                needsEscaping = first2 < ' ';
                hasNonNumberChar = true;
            }
        }
        block16: for (int i = 1; i < length2; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    if (newlineIndex != -1) continue block16;
                    newlineIndex = i;
                    continue block16;
                }
                case '\'': {
                    hasNonNumberChar = true;
                    if (singleQuoteIndex != -1) continue block16;
                    singleQuoteIndex = i;
                    continue block16;
                }
                case ' ': {
                    needsQuoting = needsQuoting || i == length2 - 1;
                    hasNonNumberChar = true;
                    continue block16;
                }
                case ',': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    needsQuoting = needsQuoting || isKey;
                    hasNonNumberChar = true;
                    continue block16;
                }
                case '#': {
                    needsQuoting = needsQuoting || str.charAt(i - 1) == ' ';
                    hasNonNumberChar = true;
                    continue block16;
                }
                case ':': {
                    if (colonIndex == -1) {
                        colonIndex = i;
                    }
                    needsQuoting = needsQuoting || i == length2 - 1 || i + 1 < length2 && str.charAt(i + 1) == ' ';
                    continue block16;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'o': 
                case 'x': {
                    continue block16;
                }
                default: {
                    needsEscaping = needsEscaping || ch < ' ';
                    hasNonNumberChar = true;
                }
            }
        }
        int pos = this.builder.length();
        if (needsEscaping) {
            this.emitDoubleQuotedString(str);
        } else if (newlineIndex != -1) {
            this.emitMultilineString(str, newlineIndex, currIndent);
        } else if (needsQuoting || !hasNonNumberChar && this.isNumber(str, colonIndex)) {
            this.emitSingleQuotedString(str, singleQuoteIndex);
        } else {
            this.builder.append(str);
        }
        if (isKey && (this.builder.length() - pos > 1024 || !needsEscaping && newlineIndex != -1)) {
            this.builder.insert(pos, "? ").append('\n').append((CharSequence)currIndent);
        }
    }

    public final void emit(long value2) {
        this.builder.append(value2);
    }

    public final void emit(double value2) {
        this.builder.append(Double.isNaN(value2) ? ".NaN" : (value2 == Double.POSITIVE_INFINITY ? ".Inf" : (value2 == Double.NEGATIVE_INFINITY ? "-.Inf" : Double.valueOf(value2))));
    }

    public final void emit(boolean value2) {
        this.builder.append(value2);
    }

    public final void emitNull() {
        this.builder.append("null");
    }

    protected abstract boolean isNumber(String var1, int var2);

    public final String getResult() {
        return this.builder.toString();
    }

    protected abstract boolean isReservedWord(String var1);

    protected static boolean isReserved11Word(String str) {
        if (str.length() > 5) {
            return false;
        }
        switch (str) {
            case "": 
            case "~": 
            case "null": 
            case "Null": 
            case "NULL": 
            case ".nan": 
            case ".NaN": 
            case ".NAN": 
            case ".inf": 
            case ".Inf": 
            case ".INF": 
            case "+.inf": 
            case "+.Inf": 
            case "+.INF": 
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": 
            case "true": 
            case "True": 
            case "TRUE": 
            case "false": 
            case "False": 
            case "FALSE": 
            case "on": 
            case "On": 
            case "ON": 
            case "off": 
            case "Off": 
            case "OFF": 
            case "y": 
            case "Y": 
            case "yes": 
            case "Yes": 
            case "YES": 
            case "n": 
            case "N": 
            case "no": 
            case "No": 
            case "NO": {
                return true;
            }
        }
        return false;
    }

    private void emitMultilineString(String str, int newlineIndex, StringBuilder currIndent) {
        int length2;
        currIndent.append(this.indent);
        this.builder.append('|');
        if (str.charAt(0) == ' ') {
            this.builder.append(this.indent.length());
        }
        if (str.charAt((length2 = str.length()) - 1) == '\n') {
            if (length2 == 1 || str.charAt(length2 - 2) == '\n') {
                this.builder.append('+');
            }
        } else {
            this.builder.append('-');
        }
        this.builder.append('\n');
        int start2 = 0;
        for (int i = newlineIndex; i < length2; ++i) {
            char ch = str.charAt(i);
            if (ch != '\n') continue;
            if (i == start2) {
                this.builder.append('\n');
            } else {
                this.builder.append((CharSequence)currIndent).append(str, start2, i + 1);
            }
            start2 = i + 1;
        }
        if (start2 < length2) {
            this.builder.append((CharSequence)currIndent).append(str, start2, length2);
        }
        currIndent.setLength(currIndent.length() - this.indent.length());
    }

    private void emitDoubleQuotedString(String str) {
        this.builder.append('\"');
        escaper.escape(str, this.builder);
        this.builder.append('\"');
    }

    private void emitSingleQuotedString(String str, int singleQuoteIndex) {
        this.builder.append('\'');
        if (singleQuoteIndex == -1) {
            this.builder.append(str);
        } else {
            int start2 = 0;
            int length2 = str.length();
            for (int i = singleQuoteIndex; i < length2; ++i) {
                if (str.charAt(i) != '\'') continue;
                this.builder.append(str, start2, i).append("''");
                start2 = i + 1;
            }
            if (start2 < length2) {
                this.builder.append(str, start2, length2);
            }
        }
        this.builder.append('\'');
    }
}

