/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml.snake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Tag;
import org.pkl.thirdparty.snakeyaml.engine.v2.resolver.ScalarResolver;

public abstract class YamlResolver
implements ScalarResolver {
    private final Map<Character, List<ResolverTuple>> yamlImplicitResolvers = new HashMap<Character, List<ResolverTuple>>();

    protected void addImplicitResolver(Tag tag, Pattern regexp, String initialChars) {
        for (int i = 0; i < initialChars.length(); ++i) {
            this.yamlImplicitResolvers.computeIfAbsent(Character.valueOf(initialChars.charAt(i)), ch -> new ArrayList()).add(new ResolverTuple(tag, regexp));
        }
    }

    @Override
    public Tag resolve(String value2, Boolean implicit) {
        if (!implicit.booleanValue()) {
            return Tag.STR;
        }
        List<ResolverTuple> resolvers = this.yamlImplicitResolvers.get(Character.valueOf(value2.isEmpty() ? (char)'\u0000' : value2.charAt(0)));
        if (resolvers == null) {
            return Tag.STR;
        }
        for (ResolverTuple resolver : resolvers) {
            if (!resolver.regexp.matcher(value2).matches()) continue;
            return resolver.tag;
        }
        return Tag.STR;
    }

    private static final class ResolverTuple {
        private final Tag tag;
        private final Pattern regexp;

        ResolverTuple(Tag tag, Pattern regexp) {
            this.tag = tag;
            this.regexp = regexp;
        }

        public String toString() {
            return "Tuple tag=" + this.tag + " regexp=" + this.regexp;
        }
    }
}

