/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.AbstractUnmodSet;
import org.pkl.thirdparty.paguro.collections.Sized;
import org.pkl.thirdparty.paguro.collections.UnmodCollection;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.collections.UnmodIterator;
import org.pkl.thirdparty.paguro.collections.UnmodSet;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterator;
import org.pkl.thirdparty.paguro.tuple.Tuple2;

public interface UnmodMap<K, V>
extends Map<K, V>,
UnmodIterable<UnEntry<K, V>>,
Sized {
    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V compute(K key2, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V computeIfAbsent(K key2, @NotNull Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V computeIfPresent(K key2, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    default public boolean containsValue(Object value2) {
        for (UnEntry item : this) {
            if (!Objects.equals(item.getValue(), value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    default public UnmodSet<Map.Entry<K, V>> entrySet() {
        class EntrySet
        extends AbstractUnmodSet<Map.Entry<K, V>>
        implements Serializable {
            private static final long serialVersionUID = 20160903104400L;
            private final UnmodMap<K, V> parent;

            private EntrySet(UnmodMap<K, V> p) {
                this.parent = p;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                if (!this.parent.containsKey(entry.getKey())) {
                    return false;
                }
                Object value2 = this.parent.get(entry.getKey());
                return Objects.equals(entry.getValue(), value2);
            }

            @Override
            @NotNull
            public UnmodIterator<Map.Entry<K, V>> iterator() {
                return this.parent.iterator();
            }

            @Override
            public int size() {
                return this.parent.size();
            }

            @Override
            @NotNull
            public String toString() {
                return UnmodIterable.toString("UnmodMap.entrySet", this);
            }
        }
        return new EntrySet(this);
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public UnmodSet<K> keySet() {
        class KeySet
        extends AbstractUnmodSet<K>
        implements Serializable {
            private static final long serialVersionUID = 20160903104400L;
            private final UnmodMap<K, V> parent;

            private KeySet(UnmodMap<K, V> p) {
                this.parent = p;
            }

            @Override
            public boolean contains(Object o) {
                return this.parent.containsKey(o);
            }

            @Override
            @NotNull
            public UnmodIterator<K> iterator() {
                return this.parent.keyIterator();
            }

            @Override
            public int size() {
                return this.parent.size();
            }

            @Override
            @NotNull
            public String toString() {
                return UnmodIterable.toString("UnmodMap.keySet", this);
            }
        }
        return new KeySet(this);
    }

    @NotNull
    default public UnmodIterator<K> keyIterator() {
        return new UnEntry.UnmodKeyIter(this.iterator());
    }

    @NotNull
    default public UnmodIterator<V> valIterator() {
        return new UnEntry.UnmodValIter(this.iterator());
    }

    @Override
    @Deprecated
    default public V merge(K key2, @NotNull V value2, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V put(K key2, V value2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V putIfAbsent(K key2, V value2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V remove(Object key2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean remove(Object key2, Object value2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean replace(K key2, V oldValue, V newValue) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public V replace(K key2, V value2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    @NotNull
    default public UnmodCollection<V> values() {
        class Impl
        implements UnmodCollection<V>,
        Serializable {
            private static final long serialVersionUID = 20160903104400L;
            private final UnmodMap<K, V> parent;

            private Impl(UnmodMap<K, V> p) {
                this.parent = p;
            }

            @Override
            public boolean contains(Object o) {
                return this.parent.containsValue(o);
            }

            @Override
            @NotNull
            public UnmodIterator<V> iterator() {
                return this.parent.valIterator();
            }

            @Override
            public int size() {
                return this.parent.size();
            }

            @NotNull
            public String toString() {
                return UnmodIterable.toString("UnmodMap.values", this);
            }
        }
        return new Impl(this);
    }

    public static interface UnEntry<K, V>
    extends Map.Entry<K, V> {
        @NotNull
        public static <K, V> UnmodIterator<UnEntry<K, V>> entryIterToUnEntryUnIter(Iterator<Map.Entry<K, V>> innerIter) {
            return new EntryToUnEntryIter<K, V>(innerIter);
        }

        @NotNull
        public static <K, V> UnmodSortedIterator<UnEntry<K, V>> entryIterToUnEntrySortedUnIter(Iterator<Map.Entry<K, V>> innerIter) {
            return new EntryToUnEntrySortedIter<K, V>(innerIter);
        }

        @Override
        @Deprecated
        default public V setValue(V value2) {
            throw new UnsupportedOperationException("Modification attempted");
        }

        public static class UnmodSortedValIter<K, V>
        extends UnmodValIter<K, V>
        implements UnmodSortedIterator<V> {
            UnmodSortedValIter(Iterator<? extends Map.Entry<K, V>> i) {
                super(i);
            }
        }

        public static class UnmodValIter<K, V>
        implements UnmodIterator<V> {
            private final Iterator<? extends Map.Entry<K, V>> iter;

            UnmodValIter(Iterator<? extends Map.Entry<K, V>> i) {
                this.iter = i;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public V next() {
                return this.iter.next().getValue();
            }
        }

        public static class UnmodSortedKeyIter<K, V>
        extends UnmodKeyIter<K, V>
        implements UnmodSortedIterator<K> {
            UnmodSortedKeyIter(Iterator<? extends Map.Entry<K, V>> i) {
                super(i);
            }
        }

        public static class UnmodKeyIter<K, V>
        implements UnmodIterator<K> {
            private final Iterator<? extends Map.Entry<K, V>> iter;

            UnmodKeyIter(Iterator<? extends Map.Entry<K, V>> i) {
                this.iter = i;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public K next() {
                return this.iter.next().getKey();
            }
        }

        public static class EntryToUnEntrySortedIter<K, V>
        extends EntryToUnEntryIter<K, V>
        implements UnmodSortedIterator<UnEntry<K, V>> {
            EntryToUnEntrySortedIter(Iterator<Map.Entry<K, V>> i) {
                super(i);
            }
        }

        public static class EntryToUnEntryIter<K, V>
        implements UnmodIterator<UnEntry<K, V>> {
            private final Iterator<Map.Entry<K, V>> innerIter;

            EntryToUnEntryIter(Iterator<Map.Entry<K, V>> i) {
                this.innerIter = i;
            }

            @Override
            public boolean hasNext() {
                return this.innerIter.hasNext();
            }

            @Override
            @NotNull
            public UnEntry<K, V> next() {
                return Tuple2.of(this.innerIter.next());
            }
        }
    }
}

