/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.pkl.config.java.ConfigEvaluator;
import org.pkl.config.java.ConfigEvaluatorImpl;
import org.pkl.config.java.mapper.ValueMapperBuilder;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.SecurityManager;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Project;
import org.pkl.core.util.Nullable;

public final class ConfigEvaluatorBuilder {
    private EvaluatorBuilder evaluatorBuilder;
    private ValueMapperBuilder mapperBuilder;

    private ConfigEvaluatorBuilder(EvaluatorBuilder evaluatorBuilder, ValueMapperBuilder mapperBuilder) {
        this.evaluatorBuilder = evaluatorBuilder;
        this.mapperBuilder = mapperBuilder;
    }

    public static ConfigEvaluatorBuilder preconfigured() {
        return new ConfigEvaluatorBuilder(EvaluatorBuilder.preconfigured(), ValueMapperBuilder.preconfigured());
    }

    public static ConfigEvaluatorBuilder unconfigured() {
        return new ConfigEvaluatorBuilder(EvaluatorBuilder.unconfigured(), ValueMapperBuilder.unconfigured());
    }

    public ConfigEvaluatorBuilder setEvaluatorBuilder(EvaluatorBuilder evaluatorBuilder) {
        this.evaluatorBuilder = evaluatorBuilder;
        return this;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return this.evaluatorBuilder;
    }

    public ConfigEvaluatorBuilder setValueMapperBuilder(ValueMapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
        return this;
    }

    public ValueMapperBuilder getValueMapperBuilder() {
        return this.mapperBuilder;
    }

    public ConfigEvaluatorBuilder addEnvironmentVariable(String name, String value) {
        this.evaluatorBuilder.addEnvironmentVariable(name, value);
        return this;
    }

    public ConfigEvaluatorBuilder addEnvironmentVariables(Map<String, String> envVars) {
        this.evaluatorBuilder.addEnvironmentVariables(envVars);
        return this;
    }

    public ConfigEvaluatorBuilder setEnvironmentVariables(Map<String, String> envVars) {
        this.evaluatorBuilder.setEnvironmentVariables(envVars);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.evaluatorBuilder.getEnvironmentVariables();
    }

    public ConfigEvaluatorBuilder addExternalProperty(String name, String value) {
        this.evaluatorBuilder.addExternalProperty(name, value);
        return this;
    }

    public ConfigEvaluatorBuilder addExternalProperties(Map<String, String> properties) {
        this.evaluatorBuilder.addExternalProperties(properties);
        return this;
    }

    public ConfigEvaluatorBuilder setExternalProperties(Map<String, String> properties) {
        this.evaluatorBuilder.setExternalProperties(properties);
        return this;
    }

    public Map<String, String> getExternalProperties() {
        return this.evaluatorBuilder.getExternalProperties();
    }

    public ConfigEvaluatorBuilder setSecurityManager(SecurityManager manager) {
        this.evaluatorBuilder.setSecurityManager(manager);
        return this;
    }

    public @Nullable SecurityManager getSecurityManager() {
        return this.evaluatorBuilder.getSecurityManager();
    }

    public ConfigEvaluatorBuilder setStackFrameTransformer(StackFrameTransformer stackFrameTransformer) {
        this.evaluatorBuilder.setStackFrameTransformer(stackFrameTransformer);
        return this;
    }

    public @Nullable StackFrameTransformer getStackFrameTransformer() {
        return this.evaluatorBuilder.getStackFrameTransformer();
    }

    public ConfigEvaluatorBuilder setProjectDependencies(DeclaredDependencies dependencies) {
        this.evaluatorBuilder.setProjectDependencies(dependencies);
        return this;
    }

    public ConfigEvaluatorBuilder applyFromProject(Project project) {
        this.evaluatorBuilder.applyFromProject(project);
        return this;
    }

    public ConfigEvaluatorBuilder setTimeout(Duration timeout) {
        this.evaluatorBuilder.setTimeout(timeout);
        return this;
    }

    public ConfigEvaluatorBuilder setAllowedModules(Collection<Pattern> patterns) {
        this.evaluatorBuilder.setAllowedModules(patterns);
        return this;
    }

    public List<Pattern> getAllowedModules() {
        return this.evaluatorBuilder.getAllowedModules();
    }

    public ConfigEvaluatorBuilder setAllowedResources(Collection<Pattern> patterns) {
        this.evaluatorBuilder.setAllowedResources(patterns);
        return this;
    }

    public List<Pattern> getAllowedResources() {
        return this.evaluatorBuilder.getAllowedResources();
    }

    public ConfigEvaluatorBuilder setRootDir(@Nullable Path rootDir) {
        this.evaluatorBuilder.setRootDir(rootDir);
        return this;
    }

    public @Nullable Path getRootDir() {
        return this.evaluatorBuilder.getRootDir();
    }

    public @Nullable Duration getTimeout() {
        return this.evaluatorBuilder.getTimeout();
    }

    public ConfigEvaluator build() {
        return new ConfigEvaluatorImpl(this.evaluatorBuilder.build(), this.mapperBuilder.build());
    }
}

