/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pkl.config.java.mapper.Conversion;
import org.pkl.config.java.mapper.Conversions;
import org.pkl.config.java.mapper.ConverterFactories;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.TypeMapping;
import org.pkl.config.java.mapper.TypeMappings;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.config.java.mapper.ValueMapperImpl;

public final class ValueMapperBuilder {
    private final List<Conversion<?, ?>> conversions = new ArrayList();
    private final List<ConverterFactory> factories = new ArrayList<ConverterFactory>();
    private final List<TypeMapping<?, ?>> mappings = new ArrayList();

    private ValueMapperBuilder() {
    }

    public static ValueMapperBuilder unconfigured() {
        return new ValueMapperBuilder();
    }

    public static ValueMapperBuilder preconfigured() {
        return ValueMapperBuilder.unconfigured().addConversions(Conversions.all).addConverterFactories(ConverterFactories.all).addTypeMappings(TypeMappings.all);
    }

    public ValueMapperBuilder addConversion(Conversion<?, ?> conversion) {
        Class clazz;
        this.conversions.add(conversion);
        if (conversion.targetType instanceof Class && (clazz = (Class)conversion.targetType).isPrimitive()) {
            this.conversions.add(Conversion.of(conversion.sourceType, Reflection.toWrapperType(clazz), conversion.converter));
        }
        return this;
    }

    public ValueMapperBuilder addConversions(Collection<Conversion<?, ?>> conversions) {
        conversions.forEach(this::addConversion);
        return this;
    }

    public ValueMapperBuilder setConversions(Collection<Conversion<?, ?>> conversions) {
        this.conversions.clear();
        return this.addConversions(conversions);
    }

    public List<Conversion<?, ?>> getConversions() {
        return this.conversions;
    }

    public ValueMapperBuilder addConverterFactory(ConverterFactory factory) {
        this.factories.add(factory);
        return this;
    }

    public ValueMapperBuilder addConverterFactories(Collection<ConverterFactory> factories) {
        factories.forEach(this::addConverterFactory);
        return this;
    }

    public ValueMapperBuilder setConverterFactories(Collection<ConverterFactory> factories) {
        this.factories.clear();
        return this.addConverterFactories(factories);
    }

    public List<ConverterFactory> getConverterFactories() {
        return this.factories;
    }

    public ValueMapperBuilder addTypeMapping(TypeMapping<?, ?> mapping) {
        this.mappings.add(mapping);
        return this;
    }

    public ValueMapperBuilder addTypeMappings(Collection<TypeMapping<?, ?>> mappings) {
        mappings.forEach(this::addTypeMapping);
        return this;
    }

    public ValueMapperBuilder setTypeMappings(Collection<TypeMapping<?, ?>> mappings) {
        this.mappings.clear();
        return this.addTypeMappings(mappings);
    }

    public List<TypeMapping<?, ?>> getTypeMappings() {
        return this.mappings;
    }

    public ValueMapper build() {
        return new ValueMapperImpl(new ArrayList(this.conversions), new ArrayList<ConverterFactory>(this.factories), new ArrayList(this.mappings));
    }
}

