/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.pkl.config.java.mapper.Conversion;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PClassInfo;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Version;

public final class Conversions {
    public static final Conversion<Long, Byte> pIntToByte = Conversion.of(PClassInfo.Int, Byte.TYPE, (value, mapper) -> {
        if (value < -128L || value > 127L) {
            throw new ConversionException(String.format("Cannot convert pkl.base#Int `%s` to java.lang.Byte because it is outside range `%s..%s`", value, (byte)-128, (byte)127));
        }
        return value.byteValue();
    });
    public static final Conversion<Long, Short> pIntToShort = Conversion.of(PClassInfo.Int, Short.TYPE, (value, mapper) -> {
        if (value < -32768L || value > 32767L) {
            throw new ConversionException(String.format("Cannot convert pkl.base#Int `%s` to java.lang.Short because it is outside range `%s..%s`", value, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE));
        }
        return value.shortValue();
    });
    public static final Conversion<Long, Integer> pIntToInteger = Conversion.of(PClassInfo.Int, Integer.TYPE, (value, mapper) -> {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new ConversionException(String.format("Cannot convert pkl.base#Int `%s` to java.lang.Integer because it is outside range `%s..%s`", value, Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        return value.intValue();
    });
    public static final Conversion<Long, Float> pIntToFloat = Conversion.of(PClassInfo.Int, Float.TYPE, (value, mapper) -> Float.valueOf(value.floatValue()));
    public static final Conversion<Long, Double> pIntToDouble = Conversion.of(PClassInfo.Int, Double.TYPE, (value, mapper) -> value.doubleValue());
    public static final Conversion<Long, BigInteger> pIntToBigInteger = Conversion.of(PClassInfo.Int, BigInteger.class, (value, mapper) -> BigInteger.valueOf(value));
    public static final Conversion<Long, BigDecimal> pIntToBigDecimal = Conversion.of(PClassInfo.Int, BigDecimal.class, (value, mapper) -> BigDecimal.valueOf(value));
    public static final Conversion<Double, Float> pFloatToFloat = Conversion.of(PClassInfo.Float, Float.TYPE, (value, mapper) -> Float.valueOf(value.floatValue()));
    public static final Conversion<Double, BigDecimal> pFloatToBigDecimal = Conversion.of(PClassInfo.Float, BigDecimal.class, (value, mapper) -> BigDecimal.valueOf(value));
    public static final Conversion<String, Character> pStringToCharacter = Conversion.of(PClassInfo.String, Character.class, (value, mapper) -> {
        if (value.length() != 1) {
            throw new ConversionException(String.format("Cannot convert pkl.base#String `%s` to java.lang.Character because it is not of length 1.", value));
        }
        return Character.valueOf(value.charAt(0));
    });
    public static final Conversion<String, URI> pStringToURI = Conversion.of(PClassInfo.String, URI.class, (value, mapper) -> {
        try {
            return new URI((String)value);
        }
        catch (URISyntaxException e) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.net.URI`.", e);
        }
    });
    public static final Conversion<String, URL> pStringToURL = Conversion.of(PClassInfo.String, URL.class, (value, mapper) -> {
        try {
            return new URL((String)value);
        }
        catch (MalformedURLException e) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.net.URL`.", e);
        }
    });
    public static final Conversion<String, File> pStringToFile = Conversion.of(PClassInfo.String, File.class, (value, mapper) -> new File((String)value));
    public static final Conversion<String, Path> pStringToPath = Conversion.of(PClassInfo.String, Path.class, (value, mapper) -> {
        try {
            return Path.of(value, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.nio.file.Path`.", e);
        }
    });
    public static final Conversion<String, Pattern> pStringToPattern = Conversion.of(PClassInfo.String, Pattern.class, (value, mapper) -> {
        try {
            return Pattern.compile(value);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.util.regex.Pattern`.", e);
        }
    });
    public static final Conversion<Pattern, String> pRegexToString = Conversion.of(PClassInfo.Regex, String.class, (value, mapper) -> value.pattern());
    public static final Conversion<Duration, java.time.Duration> pDurationToDuration = Conversion.of(PClassInfo.Duration, java.time.Duration.class, (value, mapper) -> value.toJavaDuration());
    public static final Conversion<PObject, Version> pVersionToVersion = Conversion.of(PClassInfo.Version, Version.class, (value, mapper) -> {
        try {
            return new Version(Math.toIntExact((Long)value.getProperty("major")), Math.toIntExact((Long)value.getProperty("minor")), Math.toIntExact((Long)value.getProperty("patch")), (String)value.get("preRelease"), (String)value.get("build"));
        }
        catch (ArithmeticException e) {
            throw new ConversionException("Failed to convert `pkl.semver#Version` to `org.pkl.core.Version`.", e);
        }
    });
    public static final Conversion<PObject, String> pVersionToString = Conversion.of(PClassInfo.Version, String.class, (value, mapper) -> {
        Object build;
        StringBuilder builder = new StringBuilder();
        builder.append(value.get("major"));
        builder.append('.');
        builder.append(value.get("minor"));
        builder.append('.');
        builder.append(value.get("patch"));
        Object preRelease = value.get("preRelease");
        if (preRelease != null) {
            builder.append('-');
            builder.append(preRelease);
        }
        if ((build = value.get("build")) != null) {
            builder.append('+');
            builder.append(build);
        }
        return builder.toString();
    });
    public static final Conversion<String, Version> pStringToVersion = Conversion.of(PClassInfo.String, Version.class, (value, mapper) -> {
        try {
            return Version.parse((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `org.pkl.core.Version`.", e);
        }
    });
    public static final Collection<Conversion<?, ?>> identities = List.of(Conversion.of(PClassInfo.Boolean, Boolean.TYPE, Converter.identity()), Conversion.of(PClassInfo.Boolean, Object.class, Converter.identity()), Conversion.of(PClassInfo.String, String.class, Converter.identity()), Conversion.of(PClassInfo.String, Object.class, Converter.identity()), Conversion.of(PClassInfo.Int, Long.TYPE, Converter.identity()), Conversion.of(PClassInfo.Int, Number.class, Converter.identity()), Conversion.of(PClassInfo.Int, Object.class, Converter.identity()), Conversion.of(PClassInfo.Float, Double.TYPE, Converter.identity()), Conversion.of(PClassInfo.Float, Number.class, Converter.identity()), Conversion.of(PClassInfo.Float, Object.class, Converter.identity()), Conversion.of(PClassInfo.Duration, Duration.class, Converter.identity()), Conversion.of(PClassInfo.Duration, Object.class, Converter.identity()), Conversion.of(PClassInfo.DataSize, DataSize.class, Converter.identity()), Conversion.of(PClassInfo.DataSize, Object.class, Converter.identity()), Conversion.of(PClassInfo.Module, PModule.class, Converter.identity()), Conversion.of(PClassInfo.Module, Object.class, Converter.identity()), Conversion.of(PClassInfo.Class, PClass.class, Converter.identity()), Conversion.of(PClassInfo.Class, Object.class, Converter.identity()), Conversion.of(PClassInfo.Regex, Pattern.class, Converter.identity()), Conversion.of(PClassInfo.Regex, Object.class, Converter.identity()), Conversion.of(PClassInfo.Null, PNull.class, Converter.identity()));
    public static final Collection<Conversion<?, ?>> numeric = List.of(pIntToByte, pIntToShort, pIntToInteger, pIntToFloat, pIntToDouble, pIntToBigInteger, pIntToBigDecimal, pFloatToFloat, pFloatToBigDecimal);
    public static final Collection<Conversion<?, ?>> misc = List.of(pStringToCharacter, pStringToURI, pStringToURL, pStringToFile, pStringToPath, pStringToPattern, pRegexToString, pDurationToDuration, pVersionToVersion, pVersionToString, pStringToVersion);
    public static final Collection<Conversion<?, ?>> all = Conversions.collectAll();

    private Conversions() {
    }

    private static Collection<Conversion<?, ?>> collectAll() {
        ArrayList result = new ArrayList(identities.size() + numeric.size() + misc.size());
        result.addAll(identities);
        result.addAll(numeric);
        result.addAll(misc);
        return Collections.unmodifiableList(result);
    }
}

