/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.pkl.config.java.InvalidMappingException;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public class ClassRegistry {
    private static final Properties classMappings = new Properties();
    private static final Object lock = new Object();
    private static final String CLASSES_DIRECTORY = "/META-INF/org/pkl/config/java/mapper/classes";
    private static final String PREFIX = "org.pkl.config.java.mapper.";
    private static final Set<String> loadedModules = new HashSet<String>();

    private ClassRegistry() {
    }

    @Nullable
    static Class<?> get(PClassInfo<?> pklClassInfo) {
        String pklModuleName = pklClassInfo.getModuleName();
        String pklClassName = pklClassInfo.getQualifiedName();
        ClassRegistry.initClassMappings(pklModuleName);
        String javaName = classMappings.getProperty(PREFIX + pklClassInfo.getQualifiedName());
        if (javaName == null) {
            return null;
        }
        try {
            return Class.forName(javaName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidMappingException(pklClassName, javaName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initClassMappings(String pklModuleName) {
        Object object = lock;
        synchronized (object) {
            if (loadedModules.contains(pklModuleName)) {
                return;
            }
            loadedModules.add(pklModuleName);
            InputStream url = ClassRegistry.class.getResourceAsStream("/META-INF/org/pkl/config/java/mapper/classes/" + IoUtils.encodePath((String)pklModuleName) + ".properties");
            if (url == null) {
                return;
            }
            try {
                classMappings.load(url);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

