/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Named;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.Tuple2;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.Composite;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.util.Nullable;

public class PObjectToDataObject
implements ConverterFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    @Nullable
    private static final Class<? extends Annotation> javaxInjectNamedClass = Reflection.tryLoadClass("javax.inject.Named");
    @Nullable
    private static final Method javaxInjectNamedValueMethod;

    protected PObjectToDataObject() {
    }

    @Override
    public final Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        if (sourceType != PClassInfo.Module && sourceType.getJavaClass() != PObject.class) {
            return Optional.empty();
        }
        return this.selectConstructor(Reflection.toRawType(targetType)).flatMap(constructor -> this.getParameters((Constructor<?>)constructor, targetType).map(parameters -> {
            try {
                return new ConverterImpl(targetType, lookup.unreflectConstructor((Constructor<?>)constructor), (Collection<Tuple2<String, Type>>)parameters);
            }
            catch (IllegalAccessException e) {
                throw new ConversionException(String.format("Error accessing constructor `%s`.", constructor), e);
            }
        }));
    }

    protected Optional<Constructor<?>> selectConstructor(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredConstructors()).max(Comparator.comparingInt(Constructor::getParameterCount));
    }

    protected Optional<List<String>> getParameterNames(Constructor<?> constructor) {
        ArrayList<String> paramNames = new ArrayList<String>(constructor.getParameterCount());
        ConstructorProperties properties = PObjectToDataObject.getAnnotation(constructor, ConstructorProperties.class);
        if (properties != null) {
            return Optional.of(Arrays.asList(properties.value()));
        }
        for (Parameter parameter : constructor.getParameters()) {
            String name = PObjectToDataObject.getParameterName(parameter);
            if (name == null) {
                return Optional.empty();
            }
            paramNames.add(name);
        }
        return Optional.of(paramNames);
    }

    private Optional<List<Tuple2<String, Type>>> getParameters(Constructor<?> constructor, Type targetType) {
        return this.getParameterNames(constructor).map(paramNames -> {
            Type[] paramTypes = Reflection.getExactParameterTypes(constructor, targetType);
            ArrayList<Tuple2<String, Type>> parameters = new ArrayList<Tuple2<String, Type>>(paramNames.size());
            for (int i = 0; i < paramNames.size(); ++i) {
                String name = (String)paramNames.get(i);
                parameters.add(Tuple2.of(name, paramTypes[i]));
            }
            return parameters;
        });
    }

    @Nullable
    private static String getParameterName(Parameter parameter) {
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        Named named = PObjectToDataObject.getAnnotation(parameter, Named.class);
        if (named != null) {
            return named.value();
        }
        if (javaxInjectNamedClass != null) {
            assert (javaxInjectNamedValueMethod != null);
            Annotation ann = PObjectToDataObject.getAnnotation(parameter, javaxInjectNamedClass);
            if (ann != null) {
                try {
                    return (String)javaxInjectNamedValueMethod.invoke((Object)ann, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ConversionException("Failed to invoke `javax.inject.Named.value()`.", e);
                }
            }
        }
        return null;
    }

    @Nullable
    private static <T extends Annotation> T getAnnotation(Constructor<?> constructor, Class<T> annotationClass) {
        try {
            return (T)constructor.getAnnotation(annotationClass);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Nullable
    private static <T extends Annotation> T getAnnotation(Parameter parameter, Class<T> annotationClass) {
        try {
            return parameter.getAnnotation(annotationClass);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    static {
        try {
            javaxInjectNamedValueMethod = javaxInjectNamedClass == null ? null : javaxInjectNamedClass.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class ConverterImpl<T>
    implements Converter<Composite, T> {
        private final Type targetType;
        private final MethodHandle constructorHandle;
        private final Collection<Tuple2<String, Type>> parameters;
        private final PClassInfo<Object>[] cachedPropertyTypes;
        private final Converter<Object, T>[] cachedConverters;

        ConverterImpl(Type targetType, MethodHandle constructorHandle, Collection<Tuple2<String, Type>> parameters) {
            this.targetType = targetType;
            this.constructorHandle = constructorHandle;
            this.parameters = parameters;
            Object[] cachedPropertyTypes = new PClassInfo[parameters.size()];
            this.cachedPropertyTypes = cachedPropertyTypes;
            Arrays.fill(cachedPropertyTypes, PClassInfo.Unavailable);
            Converter[] cachedConverters = new Converter[parameters.size()];
            this.cachedConverters = cachedConverters;
        }

        @Override
        public T convert(Composite value, ValueMapper valueMapper) {
            Map properties = value.getProperties();
            Object[] args = new Object[this.parameters.size()];
            int i = 0;
            for (Tuple2<String, Type> param : this.parameters) {
                Object property = properties.get(param.first);
                if (property == null) {
                    String message = String.format("Cannot convert Pkl object to Java object.%nPkl type             : %s%nJava type            : %s%nMissing Pkl property : %s%nActual Pkl properties: %s", value.getClassInfo(), this.targetType.getTypeName(), param.first, properties.keySet());
                    throw new ConversionException(message);
                }
                try {
                    PClassInfo cachedPropertyType = this.cachedPropertyTypes[i];
                    if (!cachedPropertyType.isExactClassOf(property)) {
                        this.cachedPropertyTypes[i] = cachedPropertyType = PClassInfo.forValue(property);
                        this.cachedConverters[i] = valueMapper.getConverter(cachedPropertyType, (Type)param.second);
                    }
                    assert (this.cachedConverters[i] != null);
                    args[i] = this.cachedConverters[i].convert(property, valueMapper);
                    ++i;
                }
                catch (ConversionException e) {
                    throw new ConversionException(String.format("Error converting property `%s` in Pkl object of type `%s` to equally named constructor parameter in Java class `%s`: " + e.getMessage(), param.first, value.getClassInfo(), Reflection.toRawType(this.targetType).getTypeName()), e.getCause());
                }
            }
            try {
                Object result = this.constructorHandle.invokeWithArguments(args);
                return (T)result;
            }
            catch (Throwable t) {
                throw new ConversionException(String.format("Error invoking constructor `%s`.", this.constructorHandle), t);
            }
        }
    }
}

