/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.PClassInfo;
import org.pkl.core.Pair;
import org.pkl.core.util.Nullable;

final class PPairToPair
implements ConverterFactory {
    PPairToPair() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        if (sourceType != PClassInfo.Pair) {
            return Optional.empty();
        }
        Class<?> targetClass = Reflection.toRawType(targetType);
        if (!Pair.class.isAssignableFrom(targetClass)) {
            return Optional.empty();
        }
        ParameterizedType pairType = (ParameterizedType)Reflection.getExactSupertype(targetType, Pair.class);
        return Optional.of(new ConverterImpl(pairType.getActualTypeArguments()[0], pairType.getActualTypeArguments()[1]));
    }

    private static class ConverterImpl<F, S>
    implements Converter<Pair<Object, Object>, Pair<F, S>> {
        private final Type firstTargetType;
        private final Type secondTargetType;
        private PClassInfo<Object> firstCachedType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, F> firstCachedConverter;
        private PClassInfo<Object> secondCachedType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, S> secondCachedConverter;

        public ConverterImpl(Type firstTargetType, Type secondTargetType) {
            this.firstTargetType = firstTargetType;
            this.secondTargetType = secondTargetType;
        }

        @Override
        public Pair<F, S> convert(Pair<Object, Object> value, ValueMapper valueMapper) {
            Object second;
            Object first = value.getFirst();
            if (!this.firstCachedType.isExactClassOf(first)) {
                this.firstCachedType = PClassInfo.forValue((Object)first);
                this.firstCachedConverter = valueMapper.getConverter(this.firstCachedType, this.firstTargetType);
            }
            if (!this.secondCachedType.isExactClassOf(second = value.getSecond())) {
                this.secondCachedType = PClassInfo.forValue((Object)second);
                this.secondCachedConverter = valueMapper.getConverter(this.secondCachedType, this.secondTargetType);
            }
            assert (this.firstCachedConverter != null);
            assert (this.secondCachedConverter != null);
            return new Pair(this.firstCachedConverter.convert(first, valueMapper), this.secondCachedConverter.convert(second, valueMapper));
        }
    }
}

