/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import io.leangen.geantyref.TypeArgumentNotInBoundException;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.core.Pair;

public final class Types {
    private Types() {
    }

    public static ParameterizedType parameterizedType(Class<?> rawType, Type ... typeArguments) {
        int typeParamsCount = rawType.getTypeParameters().length;
        if (typeParamsCount == 0) {
            throw new IllegalArgumentException(String.format("Cannot parameterize `%s` because it does not have any type parameters.", rawType.getTypeName()));
        }
        if (typeArguments.length != typeParamsCount) {
            throw new IllegalArgumentException(String.format("Expected %d type arguments for `%s`, but got %d.", typeParamsCount, rawType.getTypeName(), typeArguments.length));
        }
        for (Type arg : typeArguments) {
            Class clazz;
            if (!(arg instanceof Class) || !(clazz = (Class)arg).isPrimitive()) continue;
            throw new IllegalArgumentException(String.format("`%s.class` is not a valid type argument. Did you mean `%s.class`?", clazz, Reflection.toWrapperType(clazz).getSimpleName()));
        }
        try {
            return (ParameterizedType)TypeFactory.parameterizedClass(rawType, (Type[])typeArguments);
        }
        catch (TypeArgumentNotInBoundException e) {
            throw new IllegalArgumentException(String.format("Type argument `%s` for type parameter `%s` is not within bound `%s`.", e.getArgument().getTypeName(), e.getParameter().getTypeName(), e.getBound().getTypeName()));
        }
    }

    public static ParameterizedType optionalOf(Type elementType) {
        return Types.parameterizedType(Optional.class, elementType);
    }

    public static Type arrayOf(Type elementType) {
        return TypeFactory.arrayOf((Type)elementType);
    }

    public static ParameterizedType pairOf(Type firstType, Type secondType) {
        return Types.parameterizedType(Pair.class, firstType, secondType);
    }

    public static ParameterizedType iterableOf(Type elementType) {
        return Types.parameterizedType(Iterable.class, elementType);
    }

    public static ParameterizedType collectionOf(Type elementType) {
        return Types.parameterizedType(Collection.class, elementType);
    }

    public static ParameterizedType listOf(Type elementType) {
        return Types.parameterizedType(List.class, elementType);
    }

    public static ParameterizedType setOf(Type elementType) {
        return Types.parameterizedType(Set.class, elementType);
    }

    public static ParameterizedType mapOf(Type keyType, Type valueType) {
        return Types.parameterizedType(Map.class, keyType, valueType);
    }
}

