/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.PClassInfo;
import org.pkl.core.PNull;

final class PAnyToOptional
implements ConverterFactory {
    PAnyToOptional() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        if (Reflection.toRawType(targetType) != Optional.class) {
            return Optional.empty();
        }
        ParameterizedType optionalType = (ParameterizedType)Reflection.getExactSupertype(targetType, Optional.class);
        Type elementType = optionalType.getActualTypeArguments()[0];
        return Optional.of(new ConverterImpl(elementType));
    }

    private static class ConverterImpl
    implements Converter<Object, Optional<?>> {
        private final Type elementType;

        public ConverterImpl(Type elementType) {
            this.elementType = elementType;
        }

        @Override
        public Optional<?> convert(Object value, ValueMapper valueMapper) {
            return value instanceof PNull ? Optional.empty() : Optional.of(valueMapper.map(value, this.elementType));
        }
    }
}

