/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.Types;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.Nullable;

class PMapToMap
implements ConverterFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    PMapToMap() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        Class<?> targetClass = Reflection.toRawType(targetType);
        if (sourceType != PClassInfo.Map || !Map.class.isAssignableFrom(targetClass)) {
            return Optional.empty();
        }
        ParameterizedType mapType = Properties.class.isAssignableFrom(targetClass) ? Types.mapOf(String.class, String.class) : (ParameterizedType)Reflection.getExactSupertype(targetType, Map.class);
        Type[] typeArguments = mapType.getActualTypeArguments();
        Type keyType = Reflection.normalize(typeArguments[0]);
        Type valueType = Reflection.normalize(typeArguments[1]);
        return this.createInstantiator(targetClass).map(instantiator -> new ConverterImpl(instantiator, keyType, valueType));
    }

    private <K, V> Optional<Function<Integer, Map<K, V>>> createInstantiator(Class<?> clazz) {
        try {
            MethodHandle ctor2 = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, Integer.TYPE, Float.TYPE));
            return Optional.of(length -> {
                try {
                    return ctor2.invoke((int)((float)length.intValue() / 0.75f) + 1, 0.75f);
                }
                catch (Throwable t) {
                    throw new ConversionException(String.format("Error invoking constructor of class `%s`.", clazz), t);
                }
            });
        }
        catch (NoSuchMethodException e2) {
            try {
                MethodHandle ctor0 = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
                return Optional.of(length -> {
                    try {
                        return ctor0.invoke();
                    }
                    catch (Throwable t) {
                        throw new ConversionException(String.format("Error invoking constructor of class `%s`.", clazz), t);
                    }
                });
            }
            catch (NoSuchMethodException e0) {
                return Optional.empty();
            }
            catch (IllegalAccessException e) {
                throw new ConversionException(String.format("Error accessing constructor of class `%s`.", clazz), e);
            }
        }
        catch (IllegalAccessException e) {
            throw new ConversionException(String.format("Error accessing constructor of class `%s`.", clazz), e);
        }
    }

    private static class ConverterImpl<K, V>
    implements Converter<Map<Object, Object>, Map<K, V>> {
        private final Function<Integer, Map<K, V>> targetInstantiator;
        private final Type targetKeyType;
        private final Type targetValueType;
        private PClassInfo<Object> cachedKeyType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, K> cachedKeyConverter;
        private PClassInfo<Object> cachedValueType = PClassInfo.Unavailable;
        @Nullable
        private Converter<Object, V> cachedValueConverter;

        private ConverterImpl(Function<Integer, Map<K, V>> targetInstantiator, Type targetKeyType, Type targetValueType) {
            this.targetInstantiator = targetInstantiator;
            this.targetKeyType = targetKeyType;
            this.targetValueType = targetValueType;
        }

        @Override
        public Map<K, V> convert(Map<Object, Object> map, ValueMapper valueMapper) {
            Map<K, V> result = this.targetInstantiator.apply(map.size());
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!this.cachedKeyType.isExactClassOf(key)) {
                    this.cachedKeyType = PClassInfo.forValue((Object)key);
                    this.cachedKeyConverter = valueMapper.getConverter(this.cachedKeyType, this.targetKeyType);
                }
                assert (this.cachedKeyConverter != null);
                Object value = entry.getValue();
                if (!this.cachedValueType.isExactClassOf(value)) {
                    this.cachedValueType = PClassInfo.forValue((Object)value);
                    this.cachedValueConverter = valueMapper.getConverter(this.cachedValueType, this.targetValueType);
                }
                assert (this.cachedValueConverter != null);
                result.put(this.cachedKeyConverter.convert(key, valueMapper), this.cachedValueConverter.convert(value, valueMapper));
            }
            return result;
        }
    }
}

