/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.gradle.task;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

public abstract class BasePklTask
extends DefaultTask {
    @LateInit
    protected CliBaseOptions cachedOptions;

    @Input
    public abstract ListProperty<String> getAllowedModules();

    @Input
    public abstract ListProperty<String> getAllowedResources();

    @Input
    public abstract MapProperty<String, String> getEnvironmentVariables();

    @Input
    public abstract MapProperty<String, String> getExternalProperties();

    @InputFiles
    public abstract ConfigurableFileCollection getModulePath();

    @Internal
    public abstract Property<Object> getSettingsModule();

    @Internal
    public Provider<Object> getParsedSettingsModule() {
        return this.getSettingsModule().map(this::parseModuleNotation);
    }

    @InputFile
    @Optional
    public Provider<File> getSettingsModuleFile() {
        return this.getParsedSettingsModule().map(it -> {
            if (it instanceof File) {
                File file = (File)it;
                return file;
            }
            return null;
        });
    }

    @Input
    @Optional
    public Provider<URI> getSettingsModuleUri() {
        return this.getParsedSettingsModule().map(it -> {
            if (it instanceof URI) {
                URI uri = (URI)it;
                return uri;
            }
            return null;
        });
    }

    @Internal
    public abstract DirectoryProperty getEvalRootDir();

    @Input
    @Optional
    public Provider<String> getEvalRootDirPath() {
        return this.getEvalRootDir().map(it -> it.getAsFile().getAbsolutePath());
    }

    @Internal
    public abstract DirectoryProperty getModuleCacheDir();

    @Input
    @Optional
    public abstract Property<Boolean> getNoCache();

    @Input
    @Optional
    public abstract Property<Duration> getEvalTimeout();

    @Input
    @Optional
    public abstract Property<Integer> getTestPort();

    @Input
    @Optional
    public abstract Property<URI> getHttpProxy();

    @Input
    @Optional
    public abstract ListProperty<String> getHttpNoProxy();

    @TaskAction
    public void runTask() {
        this.doRunTask();
    }

    protected abstract void doRunTask();

    @Internal
    protected CliBaseOptions getCliBaseOptions() {
        if (this.cachedOptions == null) {
            this.cachedOptions = new CliBaseOptions(this.getSourceModulesAsUris(), this.patternsFromStrings((List)this.getAllowedModules().get()), this.patternsFromStrings((List)this.getAllowedResources().get()), (Map)this.getEnvironmentVariables().get(), (Map)this.getExternalProperties().get(), this.parseModulePath(), this.getProject().getProjectDir().toPath(), this.mapAndGetOrNull(this.getEvalRootDirPath(), x$0 -> Paths.get(x$0, new String[0])), this.mapAndGetOrNull((Provider)this.getSettingsModule(), (Function)this::parseModuleNotationToUri), null, (Duration)this.getEvalTimeout().getOrNull(), this.mapAndGetOrNull((Provider)this.getModuleCacheDir(), (Function)it1 -> it1.getAsFile().toPath()), ((Boolean)this.getNoCache().getOrElse((Object)false)).booleanValue(), false, false, false, ((Integer)this.getTestPort().getOrElse((Object)-1)).intValue(), Collections.emptyList(), (URI)this.getHttpProxy().getOrNull(), (List)this.getHttpNoProxy().getOrElse(List.of()));
        }
        return this.cachedOptions;
    }

    @Internal
    protected List<URI> getSourceModulesAsUris() {
        return Collections.emptyList();
    }

    protected List<Path> parseModulePath() {
        return this.getModulePath().getFiles().stream().map(File::toPath).collect(Collectors.toList());
    }

    protected Object parseModuleNotation(Object notation) {
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            if ("file".equals(uri.getScheme())) {
                return new File(uri.getPath());
            }
            return uri;
        }
        if (notation instanceof File) {
            return notation;
        }
        if (notation instanceof Path) {
            Path path = (Path)notation;
            try {
                return path.toFile();
            }
            catch (UnsupportedOperationException e) {
                throw new InvalidUserDataException("Failed to parse Pkl module file path: " + notation, (Throwable)e);
            }
        }
        if (notation instanceof URL) {
            URL url = (URL)notation;
            try {
                return this.parseModuleNotation(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new InvalidUserDataException("Failed to parse Pkl module URI: " + notation, (Throwable)e);
            }
        }
        if (notation instanceof CharSequence) {
            String s = notation.toString();
            if (IoUtils.isUriLike((String)s)) {
                try {
                    return this.parseModuleNotation(IoUtils.toUri((String)s));
                }
                catch (URISyntaxException e) {
                    throw new InvalidUserDataException("Failed to parse Pkl module URI: " + s, (Throwable)e);
                }
            }
            try {
                return Paths.get(s, new String[0]).toFile();
            }
            catch (UnsupportedOperationException | InvalidPathException e) {
                throw new InvalidUserDataException("Failed to parse Pkl module file path: " + s, (Throwable)e);
            }
        }
        if (notation instanceof FileSystemLocation) {
            FileSystemLocation location = (FileSystemLocation)notation;
            return location.getAsFile();
        }
        throw new InvalidUserDataException("Unsupported value of type " + notation.getClass() + " used as a module path: " + notation);
    }

    protected URI parseModuleNotationToUri(Object m) {
        Object parsed1 = this.parseModuleNotation(m);
        return this.parsedModuleNotationToUri(parsed1);
    }

    private URI parsedModuleNotationToUri(Object notation) {
        if (notation instanceof File) {
            File file = (File)notation;
            return IoUtils.createUri((String)file.getPath());
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            return uri;
        }
        throw new IllegalArgumentException("Invalid parsed module notation: " + notation);
    }

    protected List<Pattern> patternsFromStrings(List<String> patterns) {
        return patterns.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @Nullable
    protected <T, U> U mapAndGetOrNull(Provider<T> provider, Function<T, U> f) {
        @Nullable Object value = provider.getOrNull();
        return value == null ? null : (U)f.apply(value);
    }
}

