/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.gradle.task;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Pair;
import org.pkl.gradle.task.BasePklTask;

public abstract class ModulesTask
extends BasePklTask {
    private final Map<List<Object>, Pair<List<File>, List<URI>>> parsedSourceModulesCache = new HashMap<List<Object>, Pair<List<File>, List<URI>>>();

    @Internal
    public abstract ListProperty<Object> getSourceModules();

    @InputFiles
    public abstract ConfigurableFileCollection getTransitiveModules();

    @Internal
    public Provider<Pair<List<File>, List<URI>>> getParsedSourceModules() {
        return this.getSourceModules().map(it -> this.parsedSourceModulesCache.computeIfAbsent((List<Object>)it, this::splitFilesAndUris));
    }

    @InputFiles
    public FileCollection getSourceModuleFiles() {
        return this.getProject().files(new Object[]{this.getParsedSourceModules().map(it -> (List)it.first)});
    }

    @Input
    public Provider<List<URI>> getSourceModuleUris() {
        return this.getParsedSourceModules().map(it -> (List)it.second);
    }

    @Override
    @Internal
    protected List<URI> getSourceModulesAsUris() {
        return ((List)this.getSourceModules().get()).stream().map(this::parseModuleNotationToUri).collect(Collectors.toList());
    }

    @Internal
    public abstract DirectoryProperty getProjectDir();

    @Input
    @Optional
    public Provider<String> getProjectDirPath() {
        return this.getProjectDir().map(it -> it.getAsFile().getAbsolutePath());
    }

    @Input
    @Optional
    public abstract Property<Boolean> getOmitProjectSettings();

    @Input
    @Optional
    public abstract Property<Boolean> getNoProject();

    private Pair<List<File>, List<URI>> splitFilesAndUris(List<Object> modules) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Object m : modules) {
            Object parsed = this.parseModuleNotation(m);
            if (parsed instanceof File) {
                File file = (File)parsed;
                files.add(file);
                continue;
            }
            if (!(parsed instanceof URI)) continue;
            URI uri = (URI)parsed;
            uris.add(uri);
        }
        return Pair.of(files, uris);
    }

    private URI parsedModuleNotationToUri(Object notation) {
        if (notation instanceof File) {
            File file = (File)notation;
            return IoUtils.createUri((String)IoUtils.toNormalizedPathString((Path)file.toPath()));
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            return uri;
        }
        throw new IllegalArgumentException("Invalid parsed module notation: " + notation);
    }

    @Override
    protected URI parseModuleNotationToUri(Object m) {
        Object parsed1 = this.parseModuleNotation(m);
        return this.parsedModuleNotationToUri(parsed1);
    }

    @Override
    @TaskAction
    public void runTask() {
        if (this.getCliBaseOptions().getNormalizedSourceModules().isEmpty()) {
            throw new InvalidUserDataException("No source modules specified.");
        }
        this.doRunTask();
    }

    @Override
    @Internal
    protected CliBaseOptions getCliBaseOptions() {
        if (this.cachedOptions == null) {
            this.cachedOptions = new CliBaseOptions(this.getSourceModulesAsUris(), this.patternsFromStrings((List)this.getAllowedModules().get()), this.patternsFromStrings((List)this.getAllowedResources().get()), (Map)this.getEnvironmentVariables().get(), (Map)this.getExternalProperties().get(), this.parseModulePath(), this.getProject().getProjectDir().toPath(), this.mapAndGetOrNull(this.getEvalRootDirPath(), x$0 -> Paths.get(x$0, new String[0])), this.mapAndGetOrNull(this.getSettingsModule(), this::parseModuleNotationToUri), this.getProjectDir().isPresent() ? ((Directory)this.getProjectDir().get()).getAsFile().toPath() : null, (Duration)this.getEvalTimeout().getOrNull(), this.mapAndGetOrNull(this.getModuleCacheDir(), it1 -> it1.getAsFile().toPath()), ((Boolean)this.getNoCache().getOrElse((Object)false)).booleanValue(), ((Boolean)this.getOmitProjectSettings().getOrElse((Object)false)).booleanValue(), ((Boolean)this.getNoProject().getOrElse((Object)false)).booleanValue(), false, ((Integer)this.getTestPort().getOrElse((Object)-1)).intValue(), Collections.emptyList(), null, List.of());
        }
        return this.cachedOptions;
    }
}

