/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.commons.cli.CliCommand;
import org.pkl.commons.cli.CliException;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.packages.PackageUri;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/pkl/cli/CliPackageDownloader;", "Lorg/pkl/commons/cli/CliCommand;", "baseOptions", "Lorg/pkl/commons/cli/CliBaseOptions;", "packageUris", "", "Lorg/pkl/core/packages/PackageUri;", "noTransitive", "", "(Lorg/pkl/commons/cli/CliBaseOptions;Ljava/util/List;Z)V", "doRun", "", "pkl-cli"})
public final class CliPackageDownloader
extends CliCommand {
    @NotNull
    private final List<PackageUri> packageUris;
    private final boolean noTransitive;

    public CliPackageDownloader(@NotNull CliBaseOptions baseOptions, @NotNull List<PackageUri> packageUris, boolean noTransitive) {
        Intrinsics.checkNotNullParameter(baseOptions, "baseOptions");
        Intrinsics.checkNotNullParameter(packageUris, "packageUris");
        super(baseOptions);
        this.packageUris = packageUris;
        this.noTransitive = noTransitive;
    }

    @Override
    protected void doRun() {
        StringBuilder stringBuilder;
        if (this.getModuleCacheDir() == null) {
            throw new CliException("Cannot download packages because no cache directory is specified.", 0, 2, null);
        }
        PackageResolver packageResolver = PackageResolver.getInstance(this.getSecurityManager(), this.getHttpClient(), this.getModuleCacheDir());
        Intrinsics.checkNotNullExpressionValue(packageResolver, "getInstance(securityMana\u2026tpClient, moduleCacheDir)");
        PackageResolver packageResolver2 = packageResolver;
        Map errors = new LinkedHashMap();
        for (PackageUri pkg : this.packageUris) {
            try {
                packageResolver2.downloadPackage(pkg, pkg.getChecksums(), this.noTransitive);
            }
            catch (Throwable e2) {
                errors.put(pkg, e2);
            }
        }
        switch (errors.size()) {
            case 0: {
                return;
            }
            case 1: {
                Object object = ((Throwable)CollectionsKt.single(errors.values())).getMessage();
                if (object == null) {
                    object = "An unexpected error occurred: " + CollectionsKt.single(errors.values());
                }
                throw new CliException((String)object, 0, 2, null);
            }
        }
        StringBuilder $this$doRun_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$doRun_u24lambda_u2d0.append("Failed to download some packages.");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        for (Map.Entry entry : errors.entrySet()) {
            PackageUri uri = (PackageUri)entry.getKey();
            Throwable error = (Throwable)entry.getValue();
            Intrinsics.checkNotNullExpressionValue($this$doRun_u24lambda_u2d0.append('\n'), "append('\\n')");
            StringBuilder stringBuilder3 = $this$doRun_u24lambda_u2d0.append("Failed to download " + uri + " because:");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
            StringBuilder stringBuilder4 = $this$doRun_u24lambda_u2d0.append(String.valueOf(error.getMessage()));
            Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        int n2 = 0;
        String string2 = string;
        throw new CliException(string2, n2, n, defaultConstructorMarker);
    }
}

