/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import org.pkl.cli.CliProjectCommand;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.core.SecurityManagers;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.project.Project;
import org.pkl.core.project.ProjectDependenciesResolver;
import org.pkl.core.project.ProjectDeps;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.io.CloseableKt;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.text.Charsets;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pkl/cli/CliProjectResolver;", "Lorg/pkl/cli/CliProjectCommand;", "baseOptions", "Lorg/pkl/commons/cli/CliBaseOptions;", "projectDirs", "", "Ljava/nio/file/Path;", "consoleWriter", "Ljava/io/Writer;", "errWriter", "(Lorg/pkl/commons/cli/CliBaseOptions;Ljava/util/List;Ljava/io/Writer;Ljava/io/Writer;)V", "doRun", "", "pkl-cli"})
public final class CliProjectResolver
extends CliProjectCommand {
    @NotNull
    private final Writer consoleWriter;
    @NotNull
    private final Writer errWriter;

    public CliProjectResolver(@NotNull CliBaseOptions baseOptions, @NotNull List<? extends Path> projectDirs, @NotNull Writer consoleWriter, @NotNull Writer errWriter) {
        Intrinsics.checkNotNullParameter(baseOptions, "baseOptions");
        Intrinsics.checkNotNullParameter(projectDirs, "projectDirs");
        Intrinsics.checkNotNullParameter(consoleWriter, "consoleWriter");
        Intrinsics.checkNotNullParameter(errWriter, "errWriter");
        super(baseOptions, projectDirs);
        this.consoleWriter = consoleWriter;
        this.errWriter = errWriter;
    }

    public /* synthetic */ CliProjectResolver(CliBaseOptions cliBaseOptions, List list, Writer writer, Writer writer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Charset charset;
        OutputStream outputStream2;
        if ((n & 4) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            outputStream2 = printStream;
            charset = Charsets.UTF_8;
            writer = new OutputStreamWriter(outputStream2, charset);
        }
        if ((n & 8) != 0) {
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue(printStream, "err");
            outputStream2 = printStream;
            charset = Charsets.UTF_8;
            writer2 = new OutputStreamWriter(outputStream2, charset);
        }
        this(cliBaseOptions, list, writer, writer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        for (Path projectFile : this.getNormalizedProjectFiles()) {
            PackageResolver packageResolver;
            Project project2 = this.loadProject(projectFile);
            Intrinsics.checkNotNullExpressionValue(PackageResolver.getInstance(SecurityManagers.standard(this.getAllowedModules(), this.getAllowedResources(), SecurityManagers.defaultTrustLevels, this.getRootDir()), this.getHttpClient(), this.getModuleCacheDir()), "getInstance(\n          S\u2026 moduleCacheDir\n        )");
            Intrinsics.checkNotNullExpressionValue(new ProjectDependenciesResolver(project2, packageResolver, this.errWriter).resolve(), "ProjectDependenciesResol\u2026ver, errWriter).resolve()");
            File depsFile = projectFile.getParent().resolve("PklProject.deps.json").toFile();
            Intrinsics.checkNotNullExpressionValue(depsFile, "depsFile");
            Closeable closeable = new FileOutputStream(depsFile);
            Throwable throwable = null;
            try {
                ProjectDeps dependencies;
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                dependencies.writeTo(it);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Appendable appendable = ((Appendable)this.consoleWriter).append(depsFile.toString());
            Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
            Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
            this.consoleWriter.flush();
        }
    }
}

