/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli.repl;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.pkl.cli.repl.Command;
import org.pkl.cli.repl.CommandCompleter;
import org.pkl.cli.repl.FileCompleter;
import org.pkl.cli.repl.ParsedCommand;
import org.pkl.cli.repl.Repl;
import org.pkl.cli.repl.ReplCommandsKt;
import org.pkl.cli.repl.ReplMessages;
import org.pkl.core.repl.ReplRequest;
import org.pkl.core.repl.ReplResponse;
import org.pkl.core.repl.ReplServer;
import org.pkl.core.util.IoUtils;
import org.pkl.thirdparty.jansiAnsi;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jline.reader.Completer;
import org.pkl.thirdparty.jline.reader.EndOfFileException;
import org.pkl.thirdparty.jline.reader.LineReader;
import org.pkl.thirdparty.jline.reader.LineReaderBuilder;
import org.pkl.thirdparty.jline.reader.UserInterruptException;
import org.pkl.thirdparty.jline.reader.impl.completer.AggregateCompleter;
import org.pkl.thirdparty.jline.reader.impl.history.DefaultHistory;
import org.pkl.thirdparty.jline.terminal.Terminal;
import org.pkl.thirdparty.jline.terminal.TerminalBuilder;
import org.pkl.thirdparty.jline.utils.InfoCmp;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin._Assertions;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.text.StringsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010\u000b\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001aH\u0002J\u0012\u0010*\u001a\u00020\u00142\b\b\u0002\u0010)\u001a\u00020\u001aH\u0002J\b\u0010\r\u001a\u00020\u0014H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002J\u0006\u0010,\u001a\u00020\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/pkl/cli/repl/Repl;", "", "workingDir", "Ljava/nio/file/Path;", "server", "Lorg/pkl/core/repl/ReplServer;", "(Ljava/nio/file/Path;Lorg/pkl/core/repl/ReplServer;)V", "continuation", "", "history", "Lorg/pkl/thirdparty/jline/reader/impl/history/DefaultHistory;", "nextRequestId", "", "quit", "reader", "Lorg/pkl/thirdparty/jline/reader/LineReader;", "org.pkl.thirdparty.kotlin.jvm.PlatformType", "terminal", "Lorg/pkl/thirdparty/jline/terminal/Terminal;", "clear", "", "doExecuteCommand", "command", "Lorg/pkl/cli/repl/ParsedCommand;", "evaluate", "inputBuffer", "", "examples", "executeCommand", "force", "handleEvalRequest", "request", "Lorg/pkl/core/repl/ReplRequest;", "help", "highlight", "str", "load", "loadModule", "uri", "Ljava/net/URI;", "print", "msg", "println", "reset", "run", "pkl-cli"})
public final class Repl {
    @NotNull
    private final ReplServer server;
    private final Terminal terminal;
    @NotNull
    private final DefaultHistory history;
    private final LineReader reader;
    private boolean continuation;
    private boolean quit;
    private int nextRequestId;

    /*
     * WARNING - void declaration
     */
    public Repl(@NotNull Path workingDir, @NotNull ReplServer server) {
        void $this$reader_u24lambda_u2d1;
        Object $this$terminal_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(workingDir, "workingDir");
        Intrinsics.checkNotNullParameter(server, "server");
        this.server = server;
        Object object = TerminalBuilder.builder();
        TerminalBuilder terminalBuilder = object;
        Repl repl = this;
        boolean bl = false;
        ((TerminalBuilder)$this$terminal_u24lambda_u2d0).jansi(true);
        repl.terminal = ((TerminalBuilder)object).build();
        this.history = new DefaultHistory();
        $this$terminal_u24lambda_u2d0 = object = LineReaderBuilder.builder();
        repl = this;
        boolean bl2 = false;
        $this$reader_u24lambda_u2d1.history(this.history);
        $this$reader_u24lambda_u2d1.terminal(this.terminal);
        Completer[] completerArray = new Completer[]{CommandCompleter.INSTANCE, new FileCompleter(workingDir)};
        $this$reader_u24lambda_u2d1.completer(new AggregateCompleter(completerArray));
        $this$reader_u24lambda_u2d1.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        $this$reader_u24lambda_u2d1.variable("history-file", IoUtils.getPklHomeDir().resolve("repl-history"));
        repl.reader = ((LineReaderBuilder)object).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Path path2 = IoUtils.getPklHomeDir().resolve("repl-history.bin");
        Intrinsics.checkNotNullExpressionValue(path2, "getPklHomeDir().resolve(\"repl-history.bin\")");
        Files.deleteIfExists(path2);
        this.println(ReplMessages.INSTANCE.getWelcome());
        Repl.println$default(this, null, 1, null);
        String inputBuffer = "";
        try {
            while (!this.quit) {
                String string;
                try {
                    String string2;
                    if (this.continuation) {
                        --this.nextRequestId;
                        string2 = this.reader.readLine(StringsKt.repeat(" ", ("pkl" + this.nextRequestId + "> ").length()));
                    } else {
                        string2 = this.reader.readLine("pkl" + this.nextRequestId + "> ");
                    }
                    string = string2;
                }
                catch (UserInterruptException e2) {
                    string = ":quit";
                }
                catch (EndOfFileException e3) {
                    string = ":quit";
                }
                String line = string;
                Intrinsics.checkNotNullExpressionValue(line, "line");
                String input2 = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (((CharSequence)input2).length() == 0) continue;
                if (this.continuation) {
                    inputBuffer = ((Object)StringsKt.trim((CharSequence)(inputBuffer + "\n" + input2))).toString();
                    this.continuation = false;
                } else {
                    inputBuffer = input2;
                }
                if (StringsKt.startsWith$default(inputBuffer, ":", false, 2, null)) {
                    this.executeCommand(inputBuffer);
                    continue;
                }
                this.evaluate(inputBuffer);
            }
        }
        finally {
            try {
                this.history.save();
            }
            catch (IOException iOException) {}
            try {
                this.terminal.close();
            }
            catch (IOException iOException) {}
        }
    }

    private final void executeCommand(String inputBuffer) {
        List<ParsedCommand> candidates = ReplCommandsKt.getMatchingCommands(inputBuffer);
        if (candidates.isEmpty()) {
            this.println("Unknown command: `" + StringsKt.drop(inputBuffer, 1) + "`");
        } else if (candidates.size() > 1) {
            this.print("Which of the following did you mean?  ");
            this.println(CollectionsKt.joinToString$default(candidates, "  ", null, null, 0, null, executeCommand.1.INSTANCE, 30, null));
        } else {
            this.doExecuteCommand(CollectionsKt.single(candidates));
        }
    }

    private final void doExecuteCommand(ParsedCommand command2) {
        switch (WhenMappings.$EnumSwitchMapping$0[command2.getType().ordinal()]) {
            case 1: {
                this.clear();
                break;
            }
            case 2: {
                this.examples();
                break;
            }
            case 3: {
                this.force(command2);
                break;
            }
            case 4: {
                this.help();
                break;
            }
            case 5: {
                this.load(command2);
                break;
            }
            case 6: {
                this.quit();
                break;
            }
            case 7: {
                this.reset();
            }
        }
    }

    private final void clear() {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        this.terminal.flush();
    }

    private final void examples() {
        this.println(ReplMessages.INSTANCE.getExamples());
    }

    private final void help() {
        this.println(ReplMessages.INSTANCE.getHelp());
    }

    private final void quit() {
        this.quit = true;
    }

    private final void reset() {
        this.server.handleRequest(new ReplRequest.Reset(this.nextRequestId()));
        this.clear();
        this.nextRequestId = 0;
    }

    private final void evaluate(String inputBuffer) {
        this.handleEvalRequest(new ReplRequest.Eval(this.nextRequestId(), inputBuffer, false, false));
    }

    private final void loadModule(URI uri) {
        this.handleEvalRequest(new ReplRequest.Load(this.nextRequestId(), uri));
    }

    private final void force(ParsedCommand command2) {
        this.handleEvalRequest(new ReplRequest.Eval(this.nextRequestId(), command2.getArg(), false, true));
    }

    private final void load(ParsedCommand command2) {
        URI uRI = IoUtils.toUri(command2.getArg());
        Intrinsics.checkNotNullExpressionValue(uRI, "toUri(command.arg)");
        this.loadModule(uRI);
    }

    private final void handleEvalRequest(ReplRequest request) {
        List<ReplResponse> list = this.server.handleRequest(request);
        Intrinsics.checkNotNullExpressionValue(list, "server.handleRequest(request)");
        List<ReplResponse> responses = list;
        for (ReplResponse response : responses) {
            ReplResponse replResponse = response;
            if (replResponse instanceof ReplResponse.EvalSuccess) {
                String string = ((ReplResponse.EvalSuccess)response).getResult();
                Intrinsics.checkNotNullExpressionValue(string, "response.result");
                this.println(string);
                continue;
            }
            if (replResponse instanceof ReplResponse.EvalError) {
                String string = ((ReplResponse.EvalError)response).getMessage();
                Intrinsics.checkNotNullExpressionValue(string, "response.message");
                this.println(string);
                continue;
            }
            if (replResponse instanceof ReplResponse.InternalError) {
                Throwable throwable = ((ReplResponse.InternalError)response).getCause();
                Intrinsics.checkNotNullExpressionValue(throwable, "response.cause");
                throw throwable;
            }
            if (replResponse instanceof ReplResponse.IncompleteInput) {
                boolean bl;
                boolean bl2 = bl = responses.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                this.continuation = true;
                continue;
            }
            throw new IllegalStateException("Unexpected response: " + response);
        }
    }

    private final String nextRequestId() {
        String string;
        String $this$nextRequestId_u24lambda_u2d2 = string = "pkl" + this.nextRequestId;
        boolean bl = false;
        ++this.nextRequestId;
        return string;
    }

    private final void print(String msg) {
        this.terminal.writer().print(this.highlight(msg));
    }

    private final void println(String msg) {
        this.terminal.writer().println(this.highlight(msg));
    }

    static /* synthetic */ void println$default(Repl repl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        repl.println(string);
    }

    private final String highlight(String str) {
        jansiAnsi ansi = jansiAnsi.ansi();
        boolean normal = true;
        String[] stringArray = new String[]{"`", "```"};
        for (String part : StringsKt.split$default((CharSequence)str, stringArray, false, 0, 6, null)) {
            ansi.a(part);
            boolean bl = normal = !normal;
            if (!normal) {
                ansi.bold();
                continue;
            }
            ansi.boldOff();
        }
        ansi.reset();
        String string = ansi.toString();
        Intrinsics.checkNotNullExpressionValue(string, "ansi.toString()");
        return string;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Command.values().length];
            nArray[Command.Clear.ordinal()] = 1;
            nArray[Command.Examples.ordinal()] = 2;
            nArray[Command.Force.ordinal()] = 3;
            nArray[Command.Help.ordinal()] = 4;
            nArray[Command.Load.ordinal()] = 5;
            nArray[Command.Quit.ordinal()] = 6;
            nArray[Command.Reset.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

