/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.commons;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.pkl.commons.PathsKt;
import org.pkl.commons.StringsKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.Lazy;
import org.pkl.thirdparty.kotlin.LazyKt;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.jdk7.AutoCloseableKt;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.text.Charsets;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a+\u0010\t\u001a\u00020\u0001*\u00020\u00012\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\"\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0002\u0010\r\u001aC\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\"\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0002\u0010\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0001\u001a\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0010*\u00020\u0001\u001a3\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c*\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u000b\"\u00020 \u00a2\u0006\u0002\u0010!\u001a5\u0010\"\u001a\u00020\u0001*\u00020\u00012\u0006\u0010#\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\u000b\"\u00020$\u00a2\u0006\u0002\u0010%\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006&"}, d2={"currentWorkingDir", "Ljava/nio/file/Path;", "getCurrentWorkingDir", "()Ljava/nio/file/Path;", "isWindows", "", "()Z", "isWindows$delegate", "Lorg/pkl/thirdparty/kotlin/Lazy;", "createParentDirectories", "attributes", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createTempFile", "prefix", "", "suffix", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "deleteRecursively", "", "readString", "charset", "Ljava/nio/charset/Charset;", "resolveSafely", "other", "toNormalizedPathString", "walk", "Ljava/util/stream/Stream;", "maxDepth", "", "options", "Ljava/nio/file/FileVisitOption;", "(Ljava/nio/file/Path;I[Ljava/nio/file/FileVisitOption;)Ljava/util/stream/Stream;", "writeString", "text", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "pkl-commons"})
public final class PathsKt {
    @NotNull
    private static final Lazy isWindows$delegate = LazyKt.lazy(isWindows.2.INSTANCE);

    @NotNull
    public static final Path getCurrentWorkingDir() {
        String string = System.getProperty("user.dir");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"user.dir\")");
        return StringsKt.toPath(string);
    }

    @NotNull
    public static final Path resolveSafely(@NotNull Path $this$resolveSafely, @NotNull Path other) {
        Path path2;
        Intrinsics.checkNotNullParameter($this$resolveSafely, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.isAbsolute()) {
            path2 = other;
        } else {
            Path path3 = $this$resolveSafely.resolve(other);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "resolve(other)");
        }
        return path2;
    }

    @NotNull
    public static final Stream<Path> walk(@NotNull Path $this$walk, int maxDepth, FileVisitOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter($this$walk, "<this>");
        Intrinsics.checkNotNullParameter(options, "options");
        Stream<Path> stream = Files.walk($this$walk, maxDepth, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(stream, "walk(this, maxDepth, *options)");
        return stream;
    }

    public static /* synthetic */ Stream walk$default(Path path2, int n, FileVisitOption[] fileVisitOptionArray, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return PathsKt.walk(path2, n, fileVisitOptionArray);
    }

    @NotNull
    public static final Path createTempFile(@NotNull Path $this$createTempFile, @Nullable String prefix, @Nullable String suffix, FileAttribute<?> ... attributes2) throws IOException {
        Intrinsics.checkNotNullParameter($this$createTempFile, "<this>");
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        Path path2 = Files.createTempFile($this$createTempFile, prefix, suffix, Arrays.copyOf(attributes2, attributes2.length));
        Intrinsics.checkNotNullExpressionValue(path2, "createTempFile(this, prefix, suffix, *attributes)");
        return path2;
    }

    public static /* synthetic */ Path createTempFile$default(Path path2, String string, String string2, FileAttribute[] fileAttributeArray, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return PathsKt.createTempFile(path2, string, string2, fileAttributeArray);
    }

    @NotNull
    public static final Path createParentDirectories(@NotNull Path $this$createParentDirectories, FileAttribute<?> ... attributes2) throws IOException {
        boolean bl;
        Path path2;
        Path path3;
        Intrinsics.checkNotNullParameter($this$createParentDirectories, "<this>");
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        Path $this$createParentDirectories_u24lambda_u2d0 = path3 = $this$createParentDirectories;
        boolean bl2 = false;
        Path path4 = path2 = $this$createParentDirectories_u24lambda_u2d0.getParent();
        if (path4 != null) {
            Intrinsics.checkNotNullExpressionValue(path4, "parent");
            bl = Files.isSymbolicLink(path2);
        } else {
            bl = false;
        }
        if (!bl) {
            Path path5 = path2 = $this$createParentDirectories_u24lambda_u2d0.getParent();
            if (path5 != null) {
                Intrinsics.checkNotNullExpressionValue(path5, "parent");
                FileAttribute<?>[] fileAttributeArray = Arrays.copyOf(attributes2, attributes2.length);
                Path path6 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                v5 = path6;
                Intrinsics.checkNotNullExpressionValue(path6, "createDirectories(this, *attributes)");
            } else {
                v5 = null;
            }
        }
        return path3;
    }

    @NotNull
    public static final Path writeString(@NotNull Path $this$writeString, @NotNull String text, @NotNull Charset charset, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter($this$writeString, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        Path path2 = Files.writeString($this$writeString, (CharSequence)text, charset, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(path2, "writeString(this, text, charset, *options)");
        return path2;
    }

    public static /* synthetic */ Path writeString$default(Path path2, String string, Charset charset, OpenOption[] openOptionArray, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathsKt.writeString(path2, string, charset, openOptionArray);
    }

    @NotNull
    public static final String readString(@NotNull Path $this$readString, @NotNull Charset charset) throws IOException {
        Intrinsics.checkNotNullParameter($this$readString, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        String string = Files.readString($this$readString, charset);
        Intrinsics.checkNotNullExpressionValue(string, "readString(this, charset)");
        return string;
    }

    public static /* synthetic */ String readString$default(Path path2, Charset charset, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathsKt.readString(path2, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteRecursively(@NotNull Path $this$deleteRecursively) throws IOException {
        Intrinsics.checkNotNullParameter($this$deleteRecursively, "<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$deleteRecursively, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            AutoCloseable autoCloseable = PathsKt.walk$default($this$deleteRecursively, 0, new FileVisitOption[0], 1, null);
            Throwable throwable = null;
            try {
                Stream paths = (Stream)autoCloseable;
                boolean bl = false;
                paths.sorted(Comparator.reverseOrder()).forEach(PathsKt::deleteRecursively$lambda-2$lambda-1);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
    }

    private static final boolean isWindows() {
        Lazy lazy = isWindows$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public static final String toNormalizedPathString(@NotNull Path $this$toNormalizedPathString) {
        Intrinsics.checkNotNullParameter($this$toNormalizedPathString, "<this>");
        if (PathsKt.isWindows()) {
            return org.pkl.thirdparty.kotlin.text.StringsKt.replace$default(((Object)$this$toNormalizedPathString).toString(), "\\", "/", false, 4, null);
        }
        return ((Object)$this$toNormalizedPathString).toString();
    }

    private static final void deleteRecursively$lambda-2$lambda-1(Path it) {
        Intrinsics.checkNotNullExpressionValue(it, "it");
        Files.deleteIfExists(it);
    }
}

