/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.pkl.config.java.ConfigEvaluator;
import org.pkl.config.java.ConfigEvaluatorImpl;
import org.pkl.config.java.mapper.ValueMapperBuilder;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.SecurityManager;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Project;
import org.pkl.core.util.Nullable;

public final class ConfigEvaluatorBuilder {
    private EvaluatorBuilder evaluatorBuilder;
    private ValueMapperBuilder mapperBuilder;

    private ConfigEvaluatorBuilder(EvaluatorBuilder evaluatorBuilder, ValueMapperBuilder mapperBuilder) {
        this.evaluatorBuilder = evaluatorBuilder;
        this.mapperBuilder = mapperBuilder;
    }

    public static ConfigEvaluatorBuilder preconfigured() {
        return new ConfigEvaluatorBuilder(EvaluatorBuilder.preconfigured(), ValueMapperBuilder.preconfigured());
    }

    public static ConfigEvaluatorBuilder unconfigured() {
        return new ConfigEvaluatorBuilder(EvaluatorBuilder.unconfigured(), ValueMapperBuilder.unconfigured());
    }

    public ConfigEvaluatorBuilder setEvaluatorBuilder(EvaluatorBuilder evaluatorBuilder) {
        this.evaluatorBuilder = evaluatorBuilder;
        return this;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return this.evaluatorBuilder;
    }

    public ConfigEvaluatorBuilder setValueMapperBuilder(ValueMapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
        return this;
    }

    public ValueMapperBuilder getValueMapperBuilder() {
        return this.mapperBuilder;
    }

    public ConfigEvaluatorBuilder addEnvironmentVariable(String name, String value2) {
        this.evaluatorBuilder.addEnvironmentVariable(name, value2);
        return this;
    }

    public ConfigEvaluatorBuilder addEnvironmentVariables(Map<String, String> envVars) {
        this.evaluatorBuilder.addEnvironmentVariables(envVars);
        return this;
    }

    public ConfigEvaluatorBuilder setEnvironmentVariables(Map<String, String> envVars) {
        this.evaluatorBuilder.setEnvironmentVariables(envVars);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.evaluatorBuilder.getEnvironmentVariables();
    }

    public ConfigEvaluatorBuilder addExternalProperty(String name, String value2) {
        this.evaluatorBuilder.addExternalProperty(name, value2);
        return this;
    }

    public ConfigEvaluatorBuilder addExternalProperties(Map<String, String> properties2) {
        this.evaluatorBuilder.addExternalProperties(properties2);
        return this;
    }

    public ConfigEvaluatorBuilder setExternalProperties(Map<String, String> properties2) {
        this.evaluatorBuilder.setExternalProperties(properties2);
        return this;
    }

    public Map<String, String> getExternalProperties() {
        return this.evaluatorBuilder.getExternalProperties();
    }

    public ConfigEvaluatorBuilder setSecurityManager(SecurityManager manager) {
        this.evaluatorBuilder.setSecurityManager(manager);
        return this;
    }

    @Nullable
    public SecurityManager getSecurityManager() {
        return this.evaluatorBuilder.getSecurityManager();
    }

    public ConfigEvaluatorBuilder setStackFrameTransformer(StackFrameTransformer stackFrameTransformer2) {
        this.evaluatorBuilder.setStackFrameTransformer(stackFrameTransformer2);
        return this;
    }

    @Nullable
    public StackFrameTransformer getStackFrameTransformer() {
        return this.evaluatorBuilder.getStackFrameTransformer();
    }

    public ConfigEvaluatorBuilder setProjectDependencies(DeclaredDependencies dependencies) {
        this.evaluatorBuilder.setProjectDependencies(dependencies);
        return this;
    }

    public ConfigEvaluatorBuilder applyFromProject(Project project2) {
        this.evaluatorBuilder.applyFromProject(project2);
        return this;
    }

    public ConfigEvaluatorBuilder setTimeout(Duration timeout) {
        this.evaluatorBuilder.setTimeout(timeout);
        return this;
    }

    public ConfigEvaluatorBuilder setAllowedModules(Collection<Pattern> patterns) {
        this.evaluatorBuilder.setAllowedModules(patterns);
        return this;
    }

    public List<Pattern> getAllowedModules() {
        return this.evaluatorBuilder.getAllowedModules();
    }

    public ConfigEvaluatorBuilder setAllowedResources(Collection<Pattern> patterns) {
        this.evaluatorBuilder.setAllowedResources(patterns);
        return this;
    }

    public List<Pattern> getAllowedResources() {
        return this.evaluatorBuilder.getAllowedResources();
    }

    public ConfigEvaluatorBuilder setRootDir(@Nullable Path rootDir2) {
        this.evaluatorBuilder.setRootDir(rootDir2);
        return this;
    }

    @Nullable
    public Path getRootDir() {
        return this.evaluatorBuilder.getRootDir();
    }

    @Nullable
    public Duration getTimeout() {
        return this.evaluatorBuilder.getTimeout();
    }

    public ConfigEvaluator build() {
        return new ConfigEvaluatorImpl(this.evaluatorBuilder.build(), this.mapperBuilder.build());
    }
}

