/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.pkl.config.java.mapper.Types;
import org.pkl.core.Pair;
import org.pkl.core.util.Nullable;

public class JavaType<T> {
    private final Type type;

    protected JavaType() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalStateException("JavaType token must be parameterized.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)superclass;
        this.type = parameterizedType.getActualTypeArguments()[0];
    }

    private JavaType(Type type2) {
        this.type = type2;
    }

    public static <T> JavaType<T> of(Class<T> type2) {
        return new JavaType<T>(type2);
    }

    public static <T> JavaType<T> of(Type type2) {
        return new JavaType<T>(type2);
    }

    public static <E> JavaType<Optional<E>> optionalOf(Class<E> elementType) {
        return JavaType.of(Types.optionalOf(elementType));
    }

    public static <E> JavaType<Optional<E>> optionalOf(JavaType<E> elementType) {
        return JavaType.of(Types.optionalOf(elementType.type));
    }

    public static <F, S> JavaType<Pair<F, S>> pairOf(Class<F> firstType, Class<S> secondType) {
        return JavaType.of(Types.pairOf(firstType, secondType));
    }

    public static <F, S> JavaType<Pair<F, S>> pairOf(JavaType<F> firstType, JavaType<S> secondType) {
        return JavaType.of(Types.pairOf(firstType.type, secondType.type));
    }

    public static <E> JavaType<E[]> arrayOf(Class<E> elementType) {
        return JavaType.of(Types.arrayOf(elementType));
    }

    public static <E> JavaType<E[]> arrayOf(JavaType<E> elementType) {
        return JavaType.of(Types.arrayOf(elementType.type));
    }

    public static <E> JavaType<Iterable<E>> iterableOf(Class<E> elementType) {
        return JavaType.of(Types.iterableOf(elementType));
    }

    public static <E> JavaType<Iterable<E>> iterableOf(JavaType<E> elementType) {
        return JavaType.of(Types.iterableOf(elementType.type));
    }

    public static <E> JavaType<Collection<E>> collectionOf(Class<E> elementType) {
        return JavaType.of(Types.collectionOf(elementType));
    }

    public static <E> JavaType<Collection<E>> collectionOf(JavaType<E> elementType) {
        return JavaType.of(Types.collectionOf(elementType.type));
    }

    public static <E> JavaType<List<E>> listOf(Class<E> elementType) {
        return JavaType.of(Types.listOf(elementType));
    }

    public static <E> JavaType<List<E>> listOf(JavaType<E> elementType) {
        return JavaType.of(Types.listOf(elementType.type));
    }

    public static <E> JavaType<Set<E>> setOf(Class<E> elementType) {
        return JavaType.of(Types.setOf(elementType));
    }

    public static <E> JavaType<Set<E>> setOf(JavaType<E> elementType) {
        return JavaType.of(Types.setOf(elementType.type));
    }

    public static <K, V> JavaType<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return JavaType.of(Types.mapOf(keyType, valueType));
    }

    public static <K, V> JavaType<Map<K, V>> mapOf(JavaType<K> keyType, JavaType<V> valueType) {
        return JavaType.of(Types.mapOf(keyType.type, valueType.type));
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaType)) {
            return false;
        }
        JavaType other = (JavaType)obj;
        return this.type.equals(other.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type.toString();
    }
}

